/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.BidiMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;

public class NumericSortInterpretation
implements SortInterpretation {
    private final BidiMap<Rational> mValues = new BidiMap();
    private Rational mBiggest = Rational.TWO;

    public NumericSortInterpretation() {
        this.mValues.add(0, Rational.ZERO);
        this.mValues.add(1, Rational.ONE);
    }

    public Term toSMTLIB(Theory t, Sort sort) {
        throw new InternalError("Should never be called!");
    }

    public int extend(Rational rat) {
        if (this.mValues.containsVal(rat)) {
            return this.mValues.get(rat);
        }
        int idx = this.mValues.size();
        this.mValues.add(idx, rat);
        if (rat.compareTo(this.mBiggest) > 0) {
            this.mBiggest = rat.ceil().add(Rational.ONE);
        }
        return idx;
    }

    public int extendFresh() {
        int idx = this.mValues.size();
        this.mValues.add(idx, this.mBiggest);
        this.mBiggest = this.mBiggest.add(Rational.ONE);
        return idx;
    }

    public String toString() {
        return this.mValues.toString();
    }

    public int ensureCapacity(int numValues) {
        while (this.mValues.size() < numValues) {
            this.extendFresh();
        }
        return this.mValues.size();
    }

    public int size() {
        return this.mValues.size();
    }

    public Term get(int idx, Sort s, Theory t) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.mValues.size()) {
            throw new IndexOutOfBoundsException();
        }
        Rational rat = this.mValues.get(idx);
        return rat.toTerm(s);
    }

    public Rational get(int idx) {
        return this.mValues.get(idx);
    }
}

