/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import java.util.AbstractQueue;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomQueue
extends AbstractQueue<DPLLAtom> {
    DPLLAtom[] mAtoms = new DPLLAtom[100];
    int mSize = 0;

    @Override
    public Iterator<DPLLAtom> iterator() {
        return new Iterator<DPLLAtom>(){
            int mPos = 0;

            @Override
            public boolean hasNext() {
                return this.mPos < AtomQueue.this.mSize;
            }

            @Override
            public DPLLAtom next() {
                return AtomQueue.this.mAtoms[this.mPos++];
            }

            @Override
            public void remove() {
                AtomQueue.this.remove(AtomQueue.this.mAtoms[this.mPos - 1]);
            }
        };
    }

    @Override
    public int size() {
        return this.mSize;
    }

    private void sink(DPLLAtom atom, int pos) {
        int parent;
        while (pos > 0 && this.mAtoms[parent = (pos - 1) / 2].compareActivityTo(atom) > 0) {
            this.mAtoms[pos] = this.mAtoms[parent];
            this.mAtoms[pos].mAtomQueueIndex = pos;
            pos = parent;
        }
        this.mAtoms[pos] = atom;
        atom.mAtomQueueIndex = pos;
    }

    @Override
    public boolean offer(DPLLAtom atom) {
        assert (atom.mAtomQueueIndex == -1 || this.mAtoms[atom.mAtomQueueIndex] == atom);
        if (atom.mAtomQueueIndex != -1) {
            return false;
        }
        if (this.mSize >= this.mAtoms.length) {
            DPLLAtom[] newAtoms = new DPLLAtom[2 * this.mSize];
            System.arraycopy(this.mAtoms, 0, newAtoms, 0, this.mSize);
            this.mAtoms = newAtoms;
        }
        this.sink(atom, this.mSize++);
        return true;
    }

    @Override
    public DPLLAtom peek() {
        assert (this.mSize <= 1 || this.mAtoms[0].compareActivityTo(this.mAtoms[1]) <= 0);
        assert (this.mSize <= 2 || this.mAtoms[0].compareActivityTo(this.mAtoms[2]) <= 0);
        return this.mAtoms[0];
    }

    @Override
    public DPLLAtom poll() {
        DPLLAtom atom = this.mAtoms[0];
        this.remove(atom);
        return atom;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof DPLLAtom)) {
            return false;
        }
        assert (((DPLLAtom)o).mAtomQueueIndex == -1 || this.mAtoms[((DPLLAtom)o).mAtomQueueIndex] == o);
        return ((DPLLAtom)o).mAtomQueueIndex != -1;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof DPLLAtom)) {
            return false;
        }
        DPLLAtom atom = (DPLLAtom)o;
        if (atom.mAtomQueueIndex == -1) {
            return false;
        }
        assert (this.mAtoms[atom.mAtomQueueIndex] == atom);
        int pos = atom.mAtomQueueIndex;
        atom.mAtomQueueIndex = -1;
        while (2 * pos + 2 < this.mSize) {
            int child = 2 * pos + 1;
            if (this.mAtoms[child].compareActivityTo(this.mAtoms[child + 1]) > 0) {
                ++child;
            }
            this.mAtoms[pos] = this.mAtoms[child];
            this.mAtoms[pos].mAtomQueueIndex = pos;
            pos = child;
        }
        if (pos != --this.mSize) {
            this.sink(this.mAtoms[this.mSize], pos);
        }
        this.mAtoms[this.mSize] = null;
        return true;
    }
}

