/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoopScript
implements Script {
    private static final TermVariable[] EMPTY_TVAR_ARRAY = new TermVariable[0];
    private Theory mTheory;
    protected int mStackLevel = 0;
    protected Theory.SolverSetup mSolverSetup;

    public NoopScript() {
        this(null, null);
    }

    protected NoopScript(Theory theory) {
        this(theory, null);
    }

    protected NoopScript(Theory theory, Theory.SolverSetup setup) {
        this.mTheory = theory;
        this.mSolverSetup = setup;
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    @Override
    public void setLogic(String logic) throws UnsupportedOperationException {
        try {
            this.setLogic(Logics.valueOf(logic));
        }
        catch (IllegalArgumentException eLogicUnsupported) {
            throw new UnsupportedOperationException("Logic " + logic + " not supported");
        }
    }

    @Override
    public void setLogic(Logics logic) throws UnsupportedOperationException {
        if (this.mTheory != null) {
            throw new SMTLIBException("Logic already set!");
        }
        this.mTheory = new Theory(logic, this.mSolverSetup);
    }

    @Override
    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
    }

    @Override
    public void setInfo(String info, Object value) {
    }

    @Override
    public void declareSort(String sort, int arity) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        try {
            this.mTheory.declareSort(sort, arity);
        }
        catch (IllegalArgumentException eiae) {
            throw new SMTLIBException(eiae.getMessage());
        }
    }

    @Override
    public void defineSort(String sort, Sort[] sortParams, Sort definition) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        try {
            this.mTheory.defineSort(sort, sortParams.length, definition);
        }
        catch (IllegalArgumentException eiae) {
            throw new SMTLIBException(eiae.getMessage());
        }
    }

    @Override
    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        try {
            this.mTheory.declareFunction(fun, paramSorts, resultSort);
        }
        catch (IllegalArgumentException eiae) {
            throw new SMTLIBException(eiae.getMessage());
        }
    }

    @Override
    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        this.defineFunInternal(fun, params, resultSort, definition);
    }

    private void defineFunInternal(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!resultSort.equals(definition.getSort())) {
            throw new SMTLIBException("Sort mismatch");
        }
        try {
            this.mTheory.defineFunction(fun, params, definition);
        }
        catch (IllegalArgumentException eiae) {
            throw new SMTLIBException(eiae.getMessage());
        }
    }

    @Override
    public void push(int levels) {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.mStackLevel += levels;
        for (int i = 0; i < levels; ++i) {
            this.mTheory.push();
        }
    }

    @Override
    public void pop(int levels) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (levels > this.mStackLevel) {
            throw new SMTLIBException("Not enough levels on assertion stack");
        }
        this.mStackLevel -= levels;
        for (int i = 0; i < levels; ++i) {
            this.mTheory.pop();
        }
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Script.LBool checkSat() {
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Term[] getAssertions() throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getOption(String opt) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getInfo(String info) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term simplify(Term term) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.mTheory = null;
        this.mStackLevel = 0;
    }

    @Override
    public Term[] getInterpolants(Term[] partition) throws SMTLIBException, UnsupportedOperationException {
        int[] startOfSubtrees = new int[partition.length];
        return this.getInterpolants(partition, startOfSubtrees);
    }

    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exit() {
    }

    @Override
    public Sort sort(String sortname, Sort ... params) throws SMTLIBException {
        return this.sort(sortname, (BigInteger[])null, params);
    }

    @Override
    public Sort sort(String sortname, BigInteger[] indices, Sort ... params) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Sort res = this.mTheory.getSort(sortname, indices, params);
        if (res == null) {
            throw new SMTLIBException("Sort " + sortname + " not declared");
        }
        return res;
    }

    @Override
    public Term term(String funcname, Term ... params) throws SMTLIBException {
        return this.term(funcname, (BigInteger[])null, (Sort)null, params);
    }

    @Override
    public Term term(String funcname, BigInteger[] indices, Sort returnSort, Term ... params) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Sort[] sorts = new Sort[params.length];
        for (int i = 0; i < sorts.length; ++i) {
            sorts[i] = params[i].getSort();
        }
        FunctionSymbol fsym = this.mTheory.getFunctionWithResult(funcname, indices, returnSort, sorts);
        if (fsym == null) {
            StringBuilder sb = new StringBuilder();
            PrintTerm pt = new PrintTerm();
            sb.append("Undeclared function symbol (").append(funcname);
            for (Sort s : sorts) {
                sb.append(' ');
                pt.append((Appendable)sb, s);
            }
            sb.append(')');
            throw new SMTLIBException(sb.toString());
        }
        return this.mTheory.term(fsym, params);
    }

    @Override
    public TermVariable variable(String varname, Sort sort) throws SMTLIBException {
        if (sort == null || varname == null) {
            throw new SMTLIBException("Invalid input to create a term variable");
        }
        return this.mTheory.createTermVariable(varname, sort);
    }

    @Override
    public Term quantifier(int quantor, TermVariable[] vars, Term body, Term[] ... patterns) throws SMTLIBException {
        if (!this.mTheory.getLogic().isQuantified()) {
            throw new SMTLIBException("Cannot create quantifier in quantifier-free logic");
        }
        if (vars.length == 0) {
            throw new SMTLIBException("No quantified variables given");
        }
        if (body == null) {
            throw new SMTLIBException("Empty quantifier body");
        }
        if (patterns != null && patterns.length > 0) {
            Annotation[] annots = new Annotation[patterns.length];
            int i = 0;
            for (Term[] p : patterns) {
                annots[i++] = new Annotation(":pattern", p);
            }
            body = this.mTheory.annotatedTerm(annots, body);
        }
        if (quantor == 0) {
            return this.mTheory.exists(vars, body);
        }
        if (quantor == 1) {
            return this.mTheory.forall(vars, body);
        }
        throw new SMTLIBException("Unknown Quantifier");
    }

    @Override
    public Term let(TermVariable[] vars, Term[] values, Term body) throws SMTLIBException {
        if (vars.length != values.length) {
            throw new SMTLIBException("Need exactly one value for every variable");
        }
        return this.mTheory.let(vars, values, body);
    }

    @Override
    public Term annotate(Term t, Annotation ... annotations) throws SMTLIBException {
        if (annotations.length > 0) {
            for (Annotation a : annotations) {
                if (!a.getKey().equals(":named")) continue;
                if (!(a.getValue() instanceof String)) {
                    throw new SMTLIBException("Need a string value for :named");
                }
                if (t.getFreeVars().length != 0) {
                    throw new SMTLIBException("Cannot name open terms");
                }
                this.defineFunInternal((String)a.getValue(), EMPTY_TVAR_ARRAY, t.getSort(), t);
            }
            return this.mTheory.annotatedTerm(annotations, t);
        }
        return t;
    }

    @Override
    public Term numeral(String num) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getNumericSort() == null) {
            throw new SMTLIBException("Logic does not allow numerals");
        }
        try {
            return this.mTheory.numeral(num);
        }
        catch (NumberFormatException enfe) {
            throw new SMTLIBException("Not a numeral: " + num);
        }
    }

    @Override
    public Term numeral(BigInteger num) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getNumericSort() == null) {
            throw new SMTLIBException("Logic does not allow numerals");
        }
        return this.mTheory.numeral(num);
    }

    @Override
    public Term decimal(String decimal) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getRealSort() == null) {
            throw new SMTLIBException("Logic does not allow reals");
        }
        try {
            return this.mTheory.decimal(decimal);
        }
        catch (NumberFormatException enfe) {
            throw new SMTLIBException("Not a decimal: " + decimal);
        }
    }

    @Override
    public Term decimal(BigDecimal decimal) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getRealSort() == null) {
            throw new SMTLIBException("Logic does not allow reals");
        }
        return this.mTheory.decimal(decimal);
    }

    @Override
    public Term string(String str) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getStringSort() == null) {
            throw new SMTLIBException("Logic does not allow strings");
        }
        return this.mTheory.string(str);
    }

    @Override
    public Term hexadecimal(String hex) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Term res = this.mTheory.hexadecimal(hex);
        if (res == null) {
            throw new SMTLIBException("No bitvector logic");
        }
        return res;
    }

    @Override
    public Term binary(String bin) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Term res = this.mTheory.binary(bin);
        if (res == null) {
            throw new SMTLIBException("No bitvector logic");
        }
        return res;
    }

    @Override
    public Sort[] sortVariables(String ... names) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        return this.mTheory.createSortVariables(names);
    }

    @Override
    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Term[]> checkAllsat(Term[] predicates) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term[] findImpliedEquality(Term[] x, Term[] y) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public QuotedObject echo(QuotedObject msg) {
        return msg;
    }
}

