/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Logics {
    CORE(0),
    QF_BV(8),
    QF_IDL(144),
    QF_RDL(272),
    QF_LIA(160),
    QF_LRA(288),
    QF_NIA(192),
    QF_NRA(320),
    QF_UF(2),
    QF_UFBV(10),
    QF_UFIDL(146),
    QF_UFLIA(162),
    QF_UFLRA(290),
    QF_UFLIRA(418),
    QF_UFNIA(194),
    QF_UFNRA(322),
    QF_AX(4),
    QF_ABV(12),
    QF_AUFBV(14),
    QF_ALIA(164),
    QF_AUFLIA(166),
    QF_AUFLIRA(422),
    BV(9),
    LIA(161),
    LRA(289),
    NIA(193),
    NRA(321),
    UF(3),
    UFBV(11),
    UFIDL(147),
    UFLIA(163),
    UFLRA(289),
    UFNIA(193),
    ALIA(165),
    AUFLIA(167),
    AUFLIRA(423),
    AUFNIRA(455);

    private final int mFeatures;

    private Logics(int features) {
        this.mFeatures = features;
    }

    public boolean isIRA() {
        return (this.mFeatures & 0x180) == 384;
    }

    public boolean isUF() {
        return (this.mFeatures & 2) != 0;
    }

    public boolean isArray() {
        return (this.mFeatures & 4) != 0;
    }

    public boolean isBitVector() {
        return (this.mFeatures & 8) != 0;
    }

    public boolean isQuantified() {
        return (this.mFeatures & 1) != 0;
    }

    public boolean isArithmetic() {
        return (this.mFeatures & 0x70) != 0;
    }

    public boolean isDifferenceLogic() {
        return (this.mFeatures & 0x10) != 0;
    }

    public boolean isLinearArithmetic() {
        return (this.mFeatures & 0x20) != 0;
    }

    public boolean isNonLinearArithmetic() {
        return (this.mFeatures & 0x40) != 0;
    }

    public boolean hasIntegers() {
        return (this.mFeatures & 0x80) != 0;
    }

    public boolean hasReals() {
        return (this.mFeatures & 0x100) != 0;
    }

    static class Features {
        static final int QU = 1;
        static final int UF = 2;
        static final int AX = 4;
        static final int BV = 8;
        static final int DL = 16;
        static final int LA = 32;
        static final int NA = 64;
        static final int IA = 128;
        static final int RA = 256;

        Features() {
        }
    }
}

