//
//  This file will create a lookup table for
//  the area that a circle of area 1 would
//  overlap with the unit squares.
//
//
#include <stdio.h>
#include <math.h>

//   GRID is 1/STEPS
#define GRID 0.00390625
#define STEPS 256

double result[STEPS][STEPS][9];

main()
{
  FILE *f1;
  int i, j, k;
  double x, y;
  double x1, y1, ang1;
  double table[STEPS+1];
  double radius_2 = M_1_PI;
  double radius = M_2_SQRTPI / 2;
  void set_area(int, int, int, int, double, int);
  for (i = 0; i < STEPS; i ++)
    for (j = 0; j < STEPS; j ++)
      for (k = 0; k < 9; k ++)
        result[i][j][k] = 0;

//  Making a table which gives sqrt(radius * radius - t * t)
//  for a given t.   The radius is already predefined so
//  the area of the circle is 1.
  for (i = 0, x = 0 ; x <= 1; x += GRID, i++)
  {
    double t = x * x;
    if (radius_2 >= t)
      table[i] = sqrt(radius_2 - t);
    else
      table[i] = -1;
  }

//
//  Move the quarter of the circle through the
//  grid points
  for (i = 0, x = 0; i<= STEPS; x += GRID, i ++)
  {
    int mirror_i = STEPS - i;
    double y0;
    if (x + radius > 1)
      y0 = table[mirror_i];
    else
      y0 = -1;
    for (j = 0, y = 0; j <= i; y += GRID, j ++)
    {
      double area;
      double left = 0.25;
      int mirror_j = STEPS - j ;
      if (y + radius > 1)
        x1 = x + table[mirror_j];
      else
        x1 = 0;
      y1 = y + y0;
//
//  x1 is the x-coordinate of the intersection of the arc and the line y = 1
//  y1 is the y-coordinate of the intersection of the arc and the line x = 1
//
      if (x1 > 1 && y1 > 1)
      {
	ang1 = acos(table[mirror_j] / radius);
//
//  Get the angle by the inner product of
//    (1, 0)  and (x1 - x, 1 - y)
//
	area = (ang1 * radius_2 - (2. - x - x1) * (1. - y)) / 2;
//
//  the above line is the same as
//  area = ang1 * radius * radius / 2 + (1 - x) * (1 - y) / 2
//	    - (x1 - 1) * (1 - y) / 2
//
	left -= area;
	set_area(i, j, mirror_i, mirror_j, area, 5);
	ang1 = acos((table[mirror_j] * (1. - x) + table[mirror_i] * (1. - y))
			/ radius_2);
//
//  Inner product of (x1 - x, 1 - y) and (1 - x, y1 - y)
//
	area = (ang1 * radius_2 - (x1 - 1.) * (1. - y)
		- (y1 - 1.) * (1. - x)) / 2;
//
//  area = ang1 * radius * radius / 2 - (x1 - 1) * (1 - y) / 2
//	   - (y1 - 1) * (1 - x) / 2
//
	left -= area;
	set_area(i, j, mirror_i, mirror_j, area, 8);
	ang1 = acos(table[mirror_i] / radius);
//
//  Inner product of (1 - x, y1 - y) and (0, 1)
//
	area = (ang1 * radius_2 - (2. - y - y1) * (1. - x)) / 2;
//
//  area = ang1 * radius * radius / 2 + (1 - x) * (1 - y) / 2
//	    - (y1 - 1) * (1 - x) / 2
//
	left -= area;
	set_area(i, j, mirror_i, mirror_j, area, 7);
	set_area(i, j, mirror_i, mirror_j, left, 4);
      }
      else if (y1 > 0)
      {
	ang1 = acos((1. - x) / radius);
//
//  Inner product of (1 - x, y1 - y) and (1, 0)
//
	area = (ang1 * radius_2 - (1. - x) * (y1 - y)) / 2;
//
//  area = ang1 * radius * radius / 2 - (1 - x) * (y1 - y) / 2
//
	left -= area;
	set_area(i, j, mirror_i, mirror_j, area, 5);
	if (x1 > 0)
	{
	  ang1 = acos((1. - y) / radius);
//
//  Inner product of (x1 - x, 1 - y) and (0, 1)
//
	  area = (ang1 * radius_2 - (1. - y) * (x1 - x)) / 2;
//
//  area = (ang1 * radius * radius / 2 - (1 - y) * (x1 - x) / 2
//
	  left -= area;
	  set_area(i, j, mirror_i, mirror_j, area, 7);
	}
	set_area(i, j, mirror_i, mirror_j, left, 4);
      }
      else
	set_area(i, j, mirror_i, mirror_j, left, 4);
    }
  }
  for (i = 0; i < STEPS; i ++)
    for (j = 0; j < STEPS; j ++)
      for (k = 0; k < 9; k ++)
      {
//
//  Error check.   Should not happens except for float point
//  round off.
//
	if (result[i][j][k] > 1 || result[i][j][k] < 0)
	  printf("%d,%d,%d  out of range: %f\n", i,j,k, result[i][j][k]);
      }
  printf("Size of array: %d\n", sizeof(result));
  f1 = fopen("table.bin", "w");
  fwrite(result, sizeof(result), 1, f1);
  fclose(f1);
}
/*
  This will set the area into the destination part.
  It also consider all sorts of symmetric property and
  reduce redundant calculations.
*/
#define TOLERATE 1.e-5
void set_area(int i, int j, int mirror_i, int mirror_j, double area, int part)
{
  static int x_flip[] = {2, 1, 0, 5, 4, 3, 8, 7, 6};
  static int y_flip[] = {6, 7, 8, 3, 4, 5, 0, 1, 2};
  static int mirror[] = {0, 3, 6, 1, 4, 7, 2, 5, 8};
  if (area < -TOLERATE || area > 0.25+TOLERATE) 
  {
    printf("Area cannot be less than 0: %d %d %d %d %f %d\n", i,j,mirror_i,
		mirror_j,area, part);
    return;
  }
  if (area < 0) return;
  if (area > 0.25) area = 0.25;
  if (i < STEPS && j < STEPS)
  {
    result[i][j][part] += area;
  }
  if (mirror_i < STEPS && j < STEPS)
  {
    result[mirror_i][j][x_flip[part]] += area;
  }
  if (i < STEPS && mirror_j < STEPS)
  {
      result[i][mirror_j][y_flip[part]] += area;
  }
  if (mirror_i < STEPS && mirror_j < STEPS)
  {
    result[mirror_i][mirror_j][x_flip[y_flip[part]]] += area;
  }
//
//  The following part is for the symmetry along the line
//  x=y.  So if the point is on the line, we should skip
//  it.
  if (i != j)
  {
    if (i < STEPS && j < STEPS)
    {
      result[j][i][mirror[part]] += area;
    }
    if (mirror_i < STEPS && j < STEPS)
    {
      result[j][mirror_i][mirror[x_flip[part]]] += area;
    }
    if (mirror_j < STEPS && i < STEPS)
    {
      result[mirror_j][i][mirror[y_flip[part]]] += area;
    }
    if (mirror_i < STEPS && mirror_j < STEPS)
    {
      result[mirror_j][mirror_i][mirror[x_flip[y_flip[part]]]] += area;
    }
  }
}
