#include <stdio.h>
#include <stdlib.h>
#include <tiffio.h>
#include <strings.h>
#define TABLE 256
#define TABLE_PWR 8

main(int argc, char **argv)
{
  TIFF *tif1, *tif2;
  FILE *f1;
  char *in_name, *out_name;
  double table[TABLE][TABLE][9];
  int h, w;
  int normalize = 0;
  if (argc < 4)
  {
    exit(-1);
  }

  if (argc > 4 && !strcmp(argv[1], "-n"))
  {
    argv ++;
    normalize = 1;
  }
  in_name = argv[1];
  out_name = argv[2];

  int pwr = atoi(argv[3]);
  if (pwr < 0 || pwr > TABLE_PWR)
  {
    exit(-1);
  }
  int scale = 1 << pwr;
  int skip = 1 << (TABLE_PWR - pwr);

  f1 = fopen("table.bin", "r");
  fread(table, sizeof(table), 1, f1);
  fclose(f1);
  tif1 = TIFFOpen(in_name, "r");
  TIFFGetField(tif1, TIFFTAG_IMAGELENGTH, &h);
  uint16 color;
  TIFFGetField(tif1, TIFFTAG_SAMPLESPERPIXEL, &color);

  int w0 = TIFFScanlineSize(tif1);
  w = w0 / color;

  printf("Input image with %dx%d size (%d byte(s) per pixel)\n", w, h, color);
  unsigned char **pixel = new (unsigned char *)[h];
  unsigned char *buffer2 = new unsigned char[w0 * scale];

  for (int i = 0; i < h; i++)
    pixel[i] = 0;
  tif2 = TIFFOpen(out_name, "w");
  TIFFSetField(tif2, TIFFTAG_IMAGEWIDTH, (normalize == 1) ? w : w*scale);
  TIFFSetField(tif2, TIFFTAG_COMPRESSION, COMPRESSION_PACKBITS);
  TIFFSetField(tif2, TIFFTAG_PHOTOMETRIC, PHOTOMETRIC_RGB);
  TIFFSetField(tif2, TIFFTAG_PLANARCONFIG, PLANARCONFIG_CONTIG);
  TIFFSetField(tif2, TIFFTAG_BITSPERSAMPLE,8);
  TIFFSetField(tif2, TIFFTAG_SAMPLESPERPIXEL, color);

  for (int i = 0 ; i < h ; i ++)
  {
    unsigned char *p[3];
    double buffer[w0];
    for (int j = 0; j < w0 ; j ++)
	  buffer[j] = 0;
//
//  Prepare 3 rows of pixels from source image.
//
    if (pixel[i] == 0)
    {
      pixel[i] = new unsigned char[w0 + color * 2];
      TIFFReadScanline(tif1, &(pixel[i][color]), i);
      for (int j = 0; j < color; j ++)
      {
        pixel[i][j] = pixel[i][j + color];
        pixel[i][w0 + j + color] = pixel[i][w0 + j];
      }
    }
    p[1] = &(pixel[i][color]);
    if (i != 0)
      p[0] = &(pixel[i-1][color]);
    else
      p[0] = &(pixel[i][color]);
    if (i == h - 1)
    {
      p[2] = &(pixel[i][color]);
    }
    else
    {
      if (pixel[i+1] == 0)
      {
        pixel[i+1] = new unsigned char[w0 + color * 2];
        TIFFReadScanline(tif1, &(pixel[i + 1][color]), i+1);
        for (int j = 0; j < color; j ++)
        {
          pixel[i+1][j] = pixel[i+1][j + color];
          pixel[i+1][w0 + j + color] = pixel[i+1][w0 + j];
        }
      }
      p[2] = &(pixel[i+1][color]);
    }
    if (i > 1)
      if (pixel[i-2] != 0)
      {
        delete [] pixel[i-2];
        pixel[i-2] = 0;
      }

//
//  Scaling for each row
//
    for (int i0 = 0 ; i0 < scale ; i0 ++)
    {
      int i1 = i*scale + i0;
      for (int j = 0; j < w * scale ; j ++)
      {
	double *tmp=new double[color];
	for (int k = 0 ; k < color; k ++)
          tmp[k] = 0;
	for (int k = 0; k < 9 ; k ++)
	{
	  int idx = j/scale + (k % 3) - 1;
	  double f = table[((j % scale) * skip)%TABLE][(i0 * skip) % TABLE][k];
	  for (int l = 0 ; l < color ; l ++)
	    tmp[l] += p[k/3][idx*3 + l] * f;
	}
	for (int k = 0; k < color; k ++)
	{
          if (tmp[k] > 255.) tmp[k] = 255;
	  buffer[(j/scale) * color +k] += tmp[k];
	  if (normalize == 0)
	    buffer2[j*color + k] = (unsigned char) tmp[k];
	}
	delete [] tmp;
      }
      if (normalize == 0)
	TIFFWriteScanline(tif2, buffer2, i1);
    }
    if (normalize == 1)
    {
      for (int j = 0; j < w0 ; j ++)
      {
	buffer[j] /= (scale * scale);
        if (buffer[j] > 255.) buffer[j] = 255;
        buffer2[j] = (unsigned char) buffer[j];
      }
      TIFFWriteScanline(tif2, buffer2, i);
    }
  }
  TIFFClose(tif1);
  TIFFClose(tif2);
  for (int i = 0 ; i < h; i ++)
    if (pixel[i] != 0)
      delete [] pixel[i];
  delete [] buffer2;
}
