#include <stdio.h>
#include <stdlib.h>
#include <tiffio.h>
#include <strings.h>

main(int argc, char **argv)
{
  TIFF *tif1, *tif2;
  char *in_name, *out_name;
  int h, w;
  int normalize = 0;
  double offset = 0.5;
  int shift;
  if (argc < 4)
  {
    exit(-1);
  }

  while (argc > 4 && argv[1][0] == '-')
  {
    char *flag= &(argv[1][1]);
    while (*flag)
    {
      switch (*flag)
      {
	case 'n':
		normalize = 1;
		break;
	case 's':  // shift
		offset = 0;
		break;
      }
      flag ++;
    }
    argv ++;
  }
  in_name = argv[1];
  out_name = argv[2];

  int scale = atoi(argv[3]);
  if (scale <= 0) scale = 10;
  double skip = 1. / scale;
  shift = - (int)(offset * scale);

  tif1 = TIFFOpen(in_name, "r");
  TIFFGetField(tif1, TIFFTAG_IMAGELENGTH, &h);
  uint16 color;
  TIFFGetField(tif1, TIFFTAG_SAMPLESPERPIXEL, &color);

  int w0 = TIFFScanlineSize(tif1);
  w = w0 / color;

  printf("Input image with %dx%d size (%d byte(s) per pixel)\n", w, h, color);
  unsigned char **pixel = new (unsigned char *)[h];
  unsigned char *buffer2 = new unsigned char[w0 * scale];

  for (int i = 0; i < h; i++)
    pixel[i] = 0;
  tif2 = TIFFOpen(out_name, "w");
  TIFFSetField(tif2, TIFFTAG_IMAGEWIDTH, (normalize == 1) ? w : w*scale);
  TIFFSetField(tif2, TIFFTAG_COMPRESSION, COMPRESSION_PACKBITS);
  TIFFSetField(tif2, TIFFTAG_PHOTOMETRIC, PHOTOMETRIC_RGB);
  TIFFSetField(tif2, TIFFTAG_PLANARCONFIG, PLANARCONFIG_CONTIG);
  TIFFSetField(tif2, TIFFTAG_BITSPERSAMPLE,8);
  TIFFSetField(tif2, TIFFTAG_SAMPLESPERPIXEL, color);

  int count = 0;
  double buffer[w0];
  for (int i = 0; i < w0 ; i ++)
    buffer[i] = 0;

  for (int i = 0 ; i < h ; i ++)
  {
    unsigned char *p[2];
//
//  Prepare 3 rows of pixels from source image.
//
    if (pixel[i] == 0)
    {
      pixel[i] = new unsigned char[w0 + color * 2];
      TIFFReadScanline(tif1, &(pixel[i][color]), i);
      for (int j = 0; j < color; j ++)
      {
        pixel[i][j] = pixel[i][j + color];
        pixel[i][w0 + j + color] = pixel[i][w0 + j];
      }
    }
    p[0] = &(pixel[i][color]);
    if (i == h - 1)
      p[1] = &(pixel[i][color]);
    else
    {
      if (pixel[i+1] == 0)
      {
        pixel[i+1] = new unsigned char[w0 + color * 2];
        TIFFReadScanline(tif1, &(pixel[i + 1][color]), i+1);
        for (int j = 0; j < color; j ++)
        {
          pixel[i+1][j] = pixel[i+1][j + color];
          pixel[i+1][w0 + j + color] = pixel[i+1][w0 + j];
        }
      }
      p[1] = &(pixel[i+1][color]);
    }
    if (i > 0)
      if (pixel[i-1] != 0)
      {
        delete [] pixel[i-1];
        pixel[i-1] = 0;
      }

//
//  Scaling for each row
//
    int row_limit = scale;
    if (i == h - 1) row_limit += shift;
    for (int i0 = (i == 0) ? shift:0; i0 < row_limit ; i0 ++)
    {
      int i1 = i*scale + i0;
      for (int j = shift; j < w * scale + shift ; j ++)
      {
	double *tmp=new double[color];
	for (int k = 0 ; k < color; k ++)
          tmp[k] = 0;

	int idx1 = (j/scale) * 3;
	double p0 = (double) (i0 % scale) * skip ;
	double p1 = (double) (j % scale) * skip;

	for (int k = 0; k < color; k ++)
	{
	  int idx2 = idx1 + k;
	  int idx3 = idx1 + color + k;
	  if (idx3 > w0) idx3 = idx2;
	  tmp[k] = p[0][idx2] * (1 - p0) * (1 - p1) +
		   p[0][idx3] * (1 - p0) * p1 +
		   p[1][idx2] * p0 * (1 - p1) +
		   p[1][idx3] * p0 * p1;
	
          if (tmp[k] > 255.) tmp[k] = 255;
	  buffer[((j-shift)/scale) * color +k] += tmp[k];
	  if (normalize == 0)
	  {
	    buffer2[(j-shift)*color + k] = (unsigned char) tmp[k];
	  }
	}
	delete [] tmp;
      }
      if (normalize == 0)
      {
        TIFFWriteScanline(tif2, buffer2, i1-shift);
        count = 0;
      }
      if (normalize == 1)
      {
	if (++count >= scale)
	{
          for (int j = 0; j < w0 ; j ++)
          {
	    buffer[j] /= (scale * scale);
            if (buffer[j] > 255.) buffer[j] = 255;
            buffer2[j] = (unsigned char) buffer[j];
	    buffer[j] = 0;
          }
          TIFFWriteScanline(tif2, buffer2, (i1-shift)/scale);
	  count = 0;
	}
      }
    }
  }
  TIFFClose(tif1);
  TIFFClose(tif2);
  for (int i = 0 ; i < h; i ++)
    if (pixel[i] != 0)
      delete [] pixel[i];
  delete [] buffer2;
}
