function v = nvec(A,blk,sp_blk)
% NVEC   transforms the block diagonal matrix A with block
%        structure blk into a vector of length
%              sum_i blk(i)^2
%        by stacking the columns of the blocks of A on top
%        of one another.
%
% v = nvec(A,blk)
%
% Note: v is a row vector
%
% input variables:
%     - A         a block diagonal symmetric matrix
%     - blk       block structure vector
%     - sp_blk    flag: if sp_blk = 1, svec returns a sparse vector and a full vector otherwise
%
% output variables:
%     - v         the vector representation of the block diagonal symmetric matrix

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97

 sparseblk = 0;
 if nargin == 3,
    if sp_blk == 1,
       sparseblk = 1;
    end;
 end;
 nblk = length(blk);
 sumsq = sum(blk .* blk);
 v = zeros(1,sumsq);
 fin = 0;
 bfin = 0;
 start = 1;
 bstart = 1;
 for blkidx = 1:nblk,
    bsize = blk(blkidx);
    bsize2 = bsize*bsize;
    fin = fin + bsize;
    bfin = bfin + bsize2;
    Ablk = A(start:fin,start:fin);
    v(bstart:bfin) = reshape(Ablk,1,bsize2);
    start = start + bsize;
    bstart = bstart + bsize2;
 end;
%
 if sparseblk,
    v = sparse(v);
 end;
%
% END function
