% Conversion routine from SDPPACK's format to that of SP.
%
% Notation: 
% SDPPACK              SP
%---------------------------------------
% C                    F(:,1) 
% A_{k} (k=1,...,m)    F(:,k+1)
% b                    b
% blk                  blk
%

if size(blk,1) > size(blk,2)
   sumblk2 = blk'*blk;
else
   sumblk2 = blk*blk';
end;

F = zeros(sumblk2, m+1);
F(:,1) = nvec(C, blk)';

for i=1:m
   F(:, i+1) = nvec(smat(A(i,:), blk), blk)';
end;

