#if !defined(MATMULT_H_)
	#define MATMULT_H_ 1

#if defined(__cplusplus)
	extern "C" {
#endif

#define UNROLL_DEPTH 8		// Depth of loop unrolling
#define PIPE_DEPTH 8		// Depth of software pipelining

	int get_block_dim_mmult( int ldim );

	void mmult_dot_product( int n, const double *A, const double *B, double *C );

	void mmult_saxpy( int n, const double *A, const double *B, double *C );

	void mmult_unroll( int n, const double *A, const double *B, double *C );

	void mmult_pipeline( int n, const double *A, const double *B, double *C );

	void mmult_block( int n, const double *A, const double *B, double *C );

	void mmult_contig_block( int n,
		const double *A, const double *B, double *C );
	
	void mmult_recur_block( int n, 
		const double *A, const double *B, double *C );

	void mmult_rect_recur_block( int n, 
		const double *A, const double *B, double *C );

	void mmult_blas( int n, const double *A, const double *B, double *C );

#if defined(__cplusplus)
	}
#endif

#endif
