#if !defined(MATCOM_H_)
	#define MATCOM_H_ 1

#if defined(__cplusplus)
	extern "C" {
#endif

// BDIM is the blocking parameter, i.e., block size = BDIM-by-BDIM. 
// Implementations of blocked algorithms typically use the blocking parameter
// chosen by LAPACK for their routines.  The BDIM parameter facilitates
// overriding the LAPACK chosen blocking parameter.  It is also used during
// testing of blocked algorithms that perform matrix computations.  
// For recursive contiguous block storage, matrix computation kernels act on 
// sub-blocks of size KDIM-by-KDIM.
#if defined(DEBUG)
	#define BDIM 32
	#define KDIM 8
#else
	#define BDIM 96
	#define KDIM 8
#endif

	void create_random_matrix( double alpha, int m, int n, double *E );

	void create_random_unit_lower( double alpha, int n, double *E );

	void create_random_lower( double alpha, int n, double *E );

	void create_random_upper( double alpha, int n, double *E );

	void create_random_nonsingular( double alpha, int n, double *E );

	void create_random_spd( double alpha, int n, double *E );

	void create_random_symmetric( double alpha, int n, double *E );

	void clear_matrix( int m, int n, double *E );

	void copy_matrix( int m, int n, const double *E, double *F );

	void transpose_matrix( int m, int n, const double *E, double *F );

	void form_contig_blocks( int m, int n, int ldimE, const double *E, 
		int mm, int nn, int bdim, int ldimF, double *F );

	void form_recur_blocks( int m, int n, int ldimE, const double *E, 
		int mm, int nn, int kdim, int bdim, int ldimF, double *F );

	void unpack_contig_blocks( int mm, int nn, int bdim, int ldimE,
		const double *E, int m, int n, int ldimF, double *F  );

	void unpack_recur_blocks( int mm, int nn, int kdim, int bdim, int ldimE, 
		const double *E, int m, int n, int ldimF, double *F );

	void error_matrix_comp_frob( double *eps, double *err, int m, int n, 
		const double *E, const double *F );

	void error_matrix_comp_l1( double *eps, double *err, int m, int n, 
		const double *E, const double *F );

	void multiply_matrix( int m, int n, int p, int ldimA, const double *A, 
		int ldimB, const double *B, int ldimC, double *C );

#if defined(__cplusplus)
	}
#endif

#endif
