#if !defined(LDLTFACT_H_)
	#define LDLTFACT_H_ 1

#if defined(__cplusplus)
	extern "C" {
#endif

	int count_pivot( int piv_ord, int n, const int *piv, const int *ord );

	int get_block_dim_ldlt( int lapack, int blas, int ldim );

	void eval_pivot_diag( int n, int d, const double *diag, int *piv, int *ord );

	void reduce_ldlt_vector_blas( int m, int n, int r, int *ord, int ldim, 
		const double *L, const double *M, double *vec );

	void reduce_ldlt_mat_blk( int blas, int m, int n, const int *ord, int bdim, 
		int ldim, const double *L, const double *D, const double *M, double *A );

	void pivot_sym( int n, int k, int r, int ldim, double *A );

	void ldlt_outer_product( char pivot, int n, int *piv, int *ord, double *A );

	void ldlt_saxpy( char pivot, int n, int *piv, int *ord, double *A );

	void ldlt_block( char pivot, int n, int *piv, int *ord, double *A );

	void ldlt_block_blas( char pivot, int n, int *piv, int *ord, double *A );

	void ldlt_lapack_unblocked( char pivot, int n, int *piv, int *ord, 
		double *A );

	void ldlt_lapack( char pivot, int n, int *piv, int *ord, double *A );

#if defined(__cplusplus)
	}
#endif

#endif
