/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import AceJet.Ace;
import AceJet.EDTtype;
import AceJet.Gazetteer;
import AceJet.WordNetInterface;
import Jet.Console;
import Jet.Control;
import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.Pat.Pat;
import Jet.Refres.CorefCompare;
import Jet.Refres.CorefScorer;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.CollectionView;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class CorefEval {
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String collection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training nwire sgm.txt";
    static final String keyCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training nwire coref.txt";
    static final String parseCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/parses/training nwire parses.txt";
    static final String baselineCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/jet temp/coref/coref baseline.txt";
    static final boolean writeBaseline = false;
    static final boolean compareToBaseline = false;
    static final boolean useParser = true;
    static final boolean useParseCollection = true;
    private static HashMap idToMention;
    private static HashMap mentionToEntity;

    public static void main(String[] stringArray) throws IOException {
        WordNetInterface.initialize();
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace use parses.properties");
        new Console();
        EDTtype.readTypeDict();
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load();
        Pat.trace = false;
        Resolve.trace = false;
        DocumentCollection documentCollection = new DocumentCollection(parseCollection);
        DocumentCollection documentCollection2 = new DocumentCollection(keyCollection);
        documentCollection.open();
        documentCollection2.open();
        CorefScorer corefScorer = new CorefScorer();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            Console.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            externalDocument.setAllTags(true);
            externalDocument.open();
            Ace.monocase = Ace.allLowerCase(externalDocument);
            Control.processDocument(externalDocument, null, i == -1, i);
            Ace.tagReciprocalRelations(externalDocument);
            ExternalDocument externalDocument2 = documentCollection2.get(i);
            externalDocument2.setAllTags(true);
            externalDocument2.open();
            CorefEval.buildEntitiesFromMentions(externalDocument2);
            corefScorer.score(externalDocument, externalDocument2);
            System.out.println("Recall = " + corefScorer.recall);
            System.out.println("Precision = " + corefScorer.precision);
            System.out.println(corefScorer.mappedMentionCount + " mapped mentions");
        }
        System.out.println("");
        System.out.println("Overall Recall = " + corefScorer.overallRecall);
        System.out.println("Overall Precision = " + corefScorer.overallPrecision);
        float f = 2.0f / (1.0f / corefScorer.overallRecall + 1.0f / corefScorer.overallPrecision);
        System.out.println("F = " + f);
        System.out.println(corefScorer.overallMappedMentionCount + " total mapped mentions");
        CorefCompare.compareCollections(documentCollection, documentCollection2);
        new CollectionView(documentCollection);
    }

    public static void task(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("CorefEval requires 2 arguments: jet -CorefEval <response collection> <key collection>");
            System.exit(1);
        }
        String string = stringArray[1];
        String string2 = stringArray[2];
        DocumentCollection documentCollection = new DocumentCollection(string);
        DocumentCollection documentCollection2 = new DocumentCollection(string2);
        documentCollection.open();
        documentCollection2.open();
        CorefScorer corefScorer = new CorefScorer();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            externalDocument.setAllTags(true);
            externalDocument.open();
            ExternalDocument externalDocument2 = documentCollection2.get(i);
            externalDocument2.setAllTags(true);
            externalDocument2.open();
            CorefEval.buildEntitiesFromMentions(externalDocument);
            CorefEval.buildEntitiesFromMentions(externalDocument2);
            corefScorer.score(externalDocument, externalDocument2);
            System.out.println("Recall = " + corefScorer.recall);
            System.out.println("Precision = " + corefScorer.precision);
            System.out.println(corefScorer.mappedMentionCount + " mapped mentions");
        }
        System.out.println("");
        System.out.println("Overall Recall = " + corefScorer.overallRecall);
        System.out.println("Overall Precision = " + corefScorer.overallPrecision);
        float f = 2.0f / (1.0f / corefScorer.overallRecall + 1.0f / corefScorer.overallPrecision);
        System.out.println("F = " + f);
        System.out.println(corefScorer.overallMappedMentionCount + " total mapped mentions");
    }

    public static void buildEntitiesFromMentions(Document document) {
        Vector<Object> vector;
        Object object;
        Object object2;
        HashMap<Object, Vector<Object>> hashMap = new HashMap<Object, Vector<Object>>();
        Vector vector2 = document.annotationsOfType("mention");
        for (int i = 0; i < vector2.size(); ++i) {
            object2 = (Annotation)vector2.get(i);
            object = ((Annotation)object2).get("entity");
            if (object == null) {
                System.out.println("CorefEval.buildEntities:  mention annotation without entity id");
                continue;
            }
            vector = (Vector<Object>)hashMap.get(object);
            if (vector == null) {
                vector = new Vector<Object>();
            }
            vector.add(object2);
            hashMap.put(object, vector);
        }
        Set set = hashMap.keySet();
        object2 = set.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            vector = (Vector)hashMap.get(object);
            Annotation annotation = (Annotation)vector.get(0);
            document.annotate("entity", annotation.span(), new FeatureSet("mentions", vector));
        }
    }

    public static void buildEntitiesFromLinkedMentions(Document document) {
        Annotation annotation;
        int n;
        Vector vector = document.annotationsOfType("coref");
        if (vector == null) {
            return;
        }
        idToMention = new HashMap();
        for (n = 0; n < vector.size(); ++n) {
            annotation = (Annotation)vector.get(n);
            Object object = annotation.get("id");
            if (object == null) {
                System.out.println("(buildEntitiesFromRefs) coref annotation without id");
                continue;
            }
            idToMention.put(object, annotation);
        }
        mentionToEntity = new HashMap();
        for (n = 0; n < vector.size(); ++n) {
            annotation = (Annotation)vector.get(n);
            CorefEval.mentionToEntity(annotation, document, 0);
        }
    }

    private static Annotation mentionToEntity(Annotation annotation, Document document, int n) {
        if (n > 100) {
            System.out.println("(mentionToEntity) loop of REF pointers");
            return null;
        }
        Annotation annotation2 = (Annotation)mentionToEntity.get(annotation);
        if (annotation2 != null) {
            return annotation2;
        }
        String string = (String)annotation.get("ref");
        if (string == null) {
            Vector<Annotation> vector = new Vector<Annotation>();
            vector.add(annotation);
            annotation2 = new Annotation("entity", annotation.span(), new FeatureSet("mentions", vector));
            document.addAnnotation(annotation2);
        } else {
            Annotation annotation3 = (Annotation)idToMention.get(string);
            if (annotation3 == null) {
                System.out.println("(mentionToEntity) undefined REF pointer");
            }
            annotation2 = CorefEval.mentionToEntity(annotation3, document, n + 1);
            Vector vector = (Vector)annotation2.get("mentions");
            vector.add(annotation);
        }
        mentionToEntity.put(annotation, annotation2);
        return annotation2;
    }

    public static void buildMentionsFromEntities(Document document) {
        Vector vector = document.annotationsOfType("entity");
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Integer n = new Integer(i);
            Vector vector2 = (Vector)annotation.get("mentions");
            for (int j = 0; j < vector2.size(); ++j) {
                Annotation annotation2 = (Annotation)vector2.get(j);
                Annotation annotation3 = Resolve.getHeadC(annotation2);
                if (annotation3.type() != "mention") {
                    annotation3 = new Annotation("mention", annotation3.span(), null);
                    document.addAnnotation(annotation3);
                }
                annotation3.put("entity", n);
            }
        }
    }
}

