/*
 * Decompiled with CFR 0.152.
 */
package Jet.Parser;

import Jet.Lisp.FeatureSet;
import Jet.Parser.StatParser;
import Jet.Parser.SynFun;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.util.Vector;

public class AddSyntacticRelations {
    public static final String[] comlexDeterminers = new String[]{"such", "several", "most", "more", "many", "less", "few", "enough", "both", "all", "those", "this", "these", "the", "that", "some", "no", "neither", "every", "either", "each", "any", "another", "an", "a"};
    public static final String[] possessivePronouns = new String[]{"my", "your", "his", "her", "its", "our", "their"};
    static final String[] predCompVerbs = new String[]{"be", "become"};

    public static void annotate(Document document, Span span) {
        Object object;
        Annotation annotation;
        Vector vector = document.annotationsAt(span.start(), "sentence");
        if (vector != null & vector.size() > 0 && (annotation = (Annotation)((Annotation)(object = (Annotation)vector.get(0))).get("parse")) != null) {
            AddSyntacticRelations.annotateParseTree(document, annotation);
            return;
        }
        object = document.annotationsOfType("constit");
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Annotation annotation2 = (Annotation)((Vector)object).get(i);
            if (!annotation2.span().within(span)) continue;
            AddSyntacticRelations.annotateConstit(document, annotation2);
        }
    }

    private static void annotateParseTree(Document document, Annotation annotation) {
        if (annotation == null) {
            return;
        }
        AddSyntacticRelations.annotateConstit(document, annotation);
        Annotation[] annotationArray = StatParser.children(annotation);
        if (annotationArray != null) {
            for (int i = 0; i < annotationArray.length; ++i) {
                AddSyntacticRelations.annotateParseTree(document, annotationArray[i]);
            }
        }
    }

    private static void annotateConstit(Document document, Annotation annotation) {
        AddSyntacticRelations.restructurePoss(document, annotation);
        AddSyntacticRelations.restructureConj(document, annotation);
        AddSyntacticRelations.processS(annotation, null);
        AddSyntacticRelations.processNP(annotation);
        AddSyntacticRelations.addOfRelation(document, annotation);
        AddSyntacticRelations.addPObjRelation(document, annotation);
        AddSyntacticRelations.addDetRelation(document, annotation);
        AddSyntacticRelations.addPreNameRelation(document, annotation);
        AddSyntacticRelations.addAppositeRelation(document, annotation);
        AddSyntacticRelations.addPredCompRelation(document, annotation);
        AddSyntacticRelations.addConjRelation(document, annotation);
    }

    private static void restructurePoss(Document document, Annotation annotation) {
        if (annotation.get("cat") != "np") {
            return;
        }
        Annotation[] annotationArray = StatParser.children(annotation);
        Annotation annotation2 = annotationArray[annotationArray.length - 1];
        if (annotation2.get("cat") == "pos") {
            Annotation[] annotationArray2 = new Annotation[annotationArray.length - 1];
            for (int i = 0; i < annotationArray2.length; ++i) {
                annotationArray2[i] = annotationArray[i];
            }
            Annotation annotation3 = annotationArray2[annotationArray2.length - 1];
            int n = annotationArray2[annotationArray2.length - 1].end();
            Annotation annotation4 = new Annotation("constit", new Span(annotation.start(), n), new FeatureSet("cat", "np", "children", annotationArray2, "headC", annotation3));
            document.addAnnotation(annotation4);
            annotationArray = new Annotation[]{annotation4, annotation2};
            annotation.put("cat", "np$");
            annotation.put("children", annotationArray);
        }
    }

    private static void restructureConj(Document document, Annotation annotation) {
        if (annotation.get("cat") != "np") {
            return;
        }
        Annotation annotation2 = (Annotation)annotation.get("headC");
        if (annotation2 != null && annotation2.get("cat") == "np") {
            return;
        }
        Annotation[] annotationArray = StatParser.children(annotation);
        if (annotationArray.length < 3) {
            return;
        }
        int n = 0;
        for (int i = 1; i < annotationArray.length - 1; ++i) {
            Annotation annotation3 = annotationArray[i];
            if (annotation3 == null || annotation3.get("cat") != "cconj") continue;
            n = i;
            break;
        }
        if (n == 0) {
            return;
        }
        Annotation[] annotationArray2 = new Annotation[n];
        for (int i = 0; i < n; ++i) {
            annotationArray2[i] = annotationArray[i];
        }
        Annotation[] annotationArray3 = new Annotation[annotationArray.length - n - 1];
        for (int i = n + 1; i < annotationArray.length; ++i) {
            annotationArray3[i - n - 1] = annotationArray[i];
        }
        Annotation annotation4 = annotationArray[n];
        Annotation annotation5 = new Annotation("constit", new Span(annotation.start(), annotation4.start()), new FeatureSet("cat", "np", "children", annotationArray2, "headC", annotationArray2[annotationArray2.length - 1]));
        document.addAnnotation(annotation5);
        Annotation annotation6 = new Annotation("constit", new Span(annotation4.end(), annotation.end()), new FeatureSet("cat", "np", "children", annotationArray3, "headC", annotationArray3[annotationArray3.length - 1]));
        document.addAnnotation(annotation6);
        annotationArray = new Annotation[]{annotation5, annotation4, annotation6};
        annotation.put("children", annotationArray);
        annotation.put("headC", annotation6);
    }

    private static void processS(Annotation annotation, Annotation annotation2) {
        Annotation annotation3;
        Object object;
        String string = (String)annotation.get("cat");
        if (string != "s") {
            return;
        }
        FeatureSet featureSet = (FeatureSet)annotation.get("pa");
        if (featureSet != null) {
            return;
        }
        Annotation annotation4 = AddSyntacticRelations.assignVerbPa(annotation, annotation);
        featureSet = (FeatureSet)annotation.get("pa");
        if (annotation4 == null || featureSet == null) {
            return;
        }
        Annotation annotation5 = AddSyntacticRelations.childWithCat(annotation4, "prt");
        if (annotation5 != null && (annotation5 = Resolve.getHeadC(annotation5)).get("cat") == "dp" && (object = annotation5.get("pa")) instanceof String) {
            featureSet.put("part", object);
        }
        if ((object = AddSyntacticRelations.nonTimeNP(annotation)) == null && annotation2 != null) {
            object = annotation2;
        }
        Annotation annotation6 = AddSyntacticRelations.nonTimeNP(annotation4);
        if (featureSet.get("voice") != "passive") {
            if (object != null) {
                annotation.put("subject", object);
            }
            if (annotation6 != null) {
                annotation.put("object", annotation6);
            }
        } else if (object != null) {
            annotation.put("object", object);
        }
        if ((annotation3 = AddSyntacticRelations.childWithCat(annotation4, "pp")) != null) {
            annotation.put("pp", annotation3);
        }
    }

    private static void processNP(Annotation annotation) {
        if (annotation.get("cat") != "np") {
            return;
        }
        Annotation annotation2 = AddSyntacticRelations.childWithCat(annotation, "np");
        Annotation annotation3 = AddSyntacticRelations.childWithCat(annotation, "vp");
        Annotation annotation4 = AddSyntacticRelations.childWithCat(annotation, "sbar");
        if (annotation2 != null && annotation3 != null) {
            Annotation annotation5 = AddSyntacticRelations.processBeComplement(annotation3, annotation3);
            FeatureSet featureSet = (FeatureSet)annotation3.get("pa");
            if (annotation5 == null || featureSet == null) {
                return;
            }
            Annotation annotation6 = AddSyntacticRelations.nonTimeNP(annotation5);
            if (featureSet.get("voice") != "passive") {
                annotation3.put("subject", annotation2);
                if (annotation6 != null) {
                    annotation3.put("object", annotation6);
                }
            } else {
                annotation3.put("object", annotation2);
            }
            return;
        }
        if (annotation2 != null && annotation4 != null) {
            Annotation annotation7;
            Annotation annotation8 = AddSyntacticRelations.childWithCat(annotation4, "whnp");
            if (annotation8 != null) {
                annotation8.put("host", annotation);
            }
            if ((annotation7 = AddSyntacticRelations.childWithCat(annotation4, "s")) != null) {
                AddSyntacticRelations.processS(annotation7, annotation2);
                return;
            }
        }
    }

    private static Annotation assignVerbPa(Annotation annotation, Annotation annotation2) {
        Annotation annotation3;
        Object object;
        Annotation annotation4;
        Annotation annotation5 = AddSyntacticRelations.childWithCat(annotation, "vp");
        if (annotation5 == null) {
            return null;
        }
        Annotation annotation6 = AddSyntacticRelations.childWithCat(annotation5, "p");
        if (annotation6 != null) {
            return AddSyntacticRelations.assignVerbPa(annotation5, annotation2);
        }
        Annotation annotation7 = AddSyntacticRelations.childWithCat(annotation5, "tv");
        if (annotation7 == null) {
            annotation7 = AddSyntacticRelations.childWithCat(annotation5, "ving");
        }
        if (annotation7 == null) {
            annotation7 = AddSyntacticRelations.childWithCat(annotation5, "v");
        }
        if (annotation7 != null && SynFun.getImmediateHead(annotation7) == "be" && (annotation4 = AddSyntacticRelations.childWithCat(annotation5, "vp")) != null && (object = AddSyntacticRelations.processBeComplement(annotation, annotation4)) != null) {
            return object;
        }
        if (annotation7 != null && SynFun.getImmediateHead(annotation7) == "have" && (annotation4 = AddSyntacticRelations.childWithCat(annotation5, "vp")) != null && (object = AddSyntacticRelations.childWithCat(annotation4, "ven")) != null) {
            Object object2;
            if (SynFun.getImmediateHead((Annotation)object) == "be" && (object2 = AddSyntacticRelations.childWithCat(annotation4, "vp")) != null) {
                Annotation annotation8 = AddSyntacticRelations.childWithCat((Annotation)object2, "ving");
                if (annotation8 != null) {
                    FeatureSet featureSet = AddSyntacticRelations.paCopy(annotation8);
                    annotation2.put("pa", featureSet);
                    return object2;
                }
                Annotation annotation9 = AddSyntacticRelations.childWithCat((Annotation)object2, "ven");
                if (annotation9 != null) {
                    FeatureSet featureSet = AddSyntacticRelations.paCopy(annotation9);
                    annotation2.put("pa", featureSet);
                    if (featureSet != null) {
                        featureSet.put("voice", "passive");
                    }
                    return object2;
                }
            }
            object2 = AddSyntacticRelations.paCopy((Annotation)object);
            annotation2.put("pa", object2);
            return annotation4;
        }
        annotation4 = AddSyntacticRelations.childWithCat(annotation5, "w");
        if (annotation4 != null && (object = AddSyntacticRelations.childWithCat(annotation5, "vp")) != null && (annotation3 = AddSyntacticRelations.childWithCat((Annotation)object, "v")) != null) {
            FeatureSet featureSet = AddSyntacticRelations.paCopy(annotation3);
            annotation2.put("pa", featureSet);
            return object;
        }
        if (annotation7 != null) {
            object = AddSyntacticRelations.paCopy(annotation7);
            annotation2.put("pa", object);
            return annotation5;
        }
        return null;
    }

    private static Annotation processBeComplement(Annotation annotation, Annotation annotation2) {
        Annotation annotation3 = AddSyntacticRelations.childWithCat(annotation2, "ving");
        if (annotation3 != null) {
            FeatureSet featureSet = AddSyntacticRelations.paCopy(annotation3);
            annotation.put("pa", featureSet);
            return annotation2;
        }
        Annotation annotation4 = AddSyntacticRelations.childWithCat(annotation2, "ven");
        if (annotation4 != null) {
            FeatureSet featureSet = AddSyntacticRelations.paCopy(annotation4);
            if (featureSet != null) {
                featureSet.put("voice", "passive");
            }
            annotation.put("pa", featureSet);
            return annotation2;
        }
        return null;
    }

    private static Annotation childWithCat(Annotation annotation, String string) {
        Annotation[] annotationArray = StatParser.children(annotation);
        if (annotationArray == null) {
            return null;
        }
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation annotation2 = annotationArray[i];
            if (annotation2 == null || annotation2.get("cat") != string) continue;
            return annotation2;
        }
        return null;
    }

    private static Annotation nonTimeNP(Annotation annotation) {
        Annotation[] annotationArray = StatParser.children(annotation);
        if (annotationArray == null) {
            return null;
        }
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation annotation2;
            Annotation annotation3 = annotationArray[i];
            if (annotation3.get("cat") != "np" || (annotation2 = Resolve.getHeadC(annotation3)) != null && (annotation2.get("ntime") != null || annotation2.get("cat") == "timex")) continue;
            return annotation3;
        }
        return null;
    }

    private static FeatureSet paCopy(Annotation annotation) {
        Object object = annotation.get("pa");
        if (object == null) {
            return null;
        }
        if (!(object instanceof FeatureSet)) {
            return null;
        }
        FeatureSet featureSet = (FeatureSet)object;
        return new FeatureSet(featureSet);
    }

    private static void addOfRelation(Document document, Annotation annotation) {
        String string = (String)annotation.get("cat");
        Annotation[] annotationArray = StatParser.children(annotation);
        if (string == "np" && annotationArray != null && annotationArray.length >= 2) {
            Annotation[] annotationArray2;
            Annotation annotation2 = annotationArray[0];
            Annotation annotation3 = annotationArray[1];
            if (annotation2.get("cat") == "np" && annotation3.get("cat") == "pp" && (annotationArray2 = (Annotation[])annotation3.get("children")).length == 2) {
                String string2;
                Annotation annotation4 = annotationArray2[0];
                Annotation annotation5 = annotationArray2[1];
                if (annotation4.get("cat") == "p" && annotation5.get("cat") == "np" && (string2 = document.text(annotation4).trim()).equalsIgnoreCase("of")) {
                    annotation.put("of", annotation5);
                }
            }
        }
    }

    private static void addPObjRelation(Document document, Annotation annotation) {
        String string = (String)annotation.get("cat");
        Annotation[] annotationArray = StatParser.children(annotation);
        if (string == "pp" && annotationArray != null && annotationArray.length == 2) {
            Annotation annotation2 = annotationArray[0];
            Annotation annotation3 = annotationArray[1];
            if (annotation2.get("cat") == "p" && annotation3.get("cat") == "np") {
                String string2 = document.text(annotation2).trim();
                annotation.put("p-obj", annotation3);
                annotation3.put("p-obj-1", annotation);
            }
        }
    }

    private static void addDetRelation(Document document, Annotation annotation) {
        String string = (String)annotation.get("cat");
        if (string != "np") {
            return;
        }
        Annotation annotation2 = Resolve.getNgHead(annotation);
        Annotation[] annotationArray = StatParser.children(annotation2);
        if (annotationArray != null && annotationArray.length >= 2) {
            Annotation annotation3 = annotationArray[0];
            AddSyntacticRelations.restructurePoss(document, annotation3);
            String string2 = document.text(annotation3).trim().toLowerCase().intern();
            if (Resolve.in(string2, comlexDeterminers)) {
                annotation.put("det", string2);
            } else if (Resolve.in(string2, possessivePronouns)) {
                annotation.put("det", "poss");
                annotation.put("poss", annotation3);
            } else if (annotation3.get("cat") == "np$") {
                annotation.put("det", "poss");
                annotation.put("poss", StatParser.children(annotation3)[0]);
            } else if (annotation3.get("cat") == "q" || annotation3.get("cat") == "qp") {
                annotation.put("det", "q");
            }
        }
    }

    private static void addAppositeRelation(Document document, Annotation annotation) {
        String string = (String)annotation.get("cat");
        Annotation[] annotationArray = StatParser.children(annotation);
        if (!(string != "np" || annotationArray == null || annotationArray.length != 3 && annotationArray.length != 4 || annotationArray[0].get("cat") != "np" || annotationArray[1].get("cat") != "," || annotationArray[2].get("cat") != "np" || annotationArray.length != 3 && annotationArray[3].get("cat") != ",")) {
            boolean bl;
            Annotation annotation2 = Resolve.getHeadC(annotationArray[0]);
            Annotation annotation3 = Resolve.getHeadC(annotationArray[2]);
            boolean bl2 = annotation2.get("cat") == "name";
            boolean bl3 = bl = annotation3.get("cat") == "name";
            if (bl2 && !bl || bl && !bl2) {
                annotation.put("apposite", annotationArray[2]);
            }
        }
    }

    private static void addPreNameRelation(Document document, Annotation annotation) {
        String string = (String)annotation.get("cat");
        if (string != "np") {
            return;
        }
        Annotation annotation2 = Resolve.getHeadC(annotation);
        Annotation annotation3 = Resolve.getNgHead(annotation);
        Annotation[] annotationArray = StatParser.children(annotation3);
        if (annotationArray != null && annotationArray.length >= 2) {
            Annotation annotation4;
            if (annotation2.get("cat") == "name" && ((annotation4 = annotationArray[annotationArray.length - 2]).get("cat") == "title" || annotation4.get("cat") == "n")) {
                annotation.put("preName", annotation4);
                annotation4.put("preName-1", annotation);
            }
            for (int i = 0; i < annotationArray.length - 1; ++i) {
                Annotation annotation5 = annotationArray[i];
                if (annotation5.get("cat") != "name") continue;
                annotation.put("nameMod", annotation5);
                annotation5.put("nameMod-1", annotation);
            }
        }
    }

    private static void addPredCompRelation(Document document, Annotation annotation) {
        String string = (String)annotation.get("cat");
        Annotation[] annotationArray = StatParser.children(annotation);
        if (string == "s" && annotationArray != null && annotationArray.length >= 2 && annotationArray[0].get("cat") == "np" && annotationArray[1].get("cat") == "vp") {
            Annotation annotation2 = annotationArray[0];
            String string2 = SynFun.getHead(document, annotation2);
            if ("there".equalsIgnoreCase(string2)) {
                return;
            }
            if ("it".equalsIgnoreCase(string2)) {
                return;
            }
            Annotation annotation3 = annotationArray[1];
            Annotation[] annotationArray2 = (Annotation[])annotation3.get("children");
            if (annotationArray2 != null && annotationArray2.length >= 2 && annotationArray2[0].get("cat") == "tv" && Resolve.in(SynFun.getHead(document, annotationArray2[0]), predCompVerbs) && annotationArray2[1].get("cat") == "np") {
                annotation2.put("predComp", annotationArray2[1]);
            }
        }
    }

    private static void addConjRelation(Document document, Annotation annotation) {
        if (annotation.get("cat") != "np") {
            return;
        }
        Annotation[] annotationArray = StatParser.children(annotation);
        if (annotationArray.length == 3 && annotationArray[0].get("cat") == "np" && annotationArray[1].get("cat") == "cconj" && annotationArray[2].get("cat") == "np") {
            annotationArray[0].put("conj", annotationArray[2]);
        }
    }
}

