/*
 * Decompiled with CFR 0.152.
 */
package Jet;

import Jet.Chunk.Chunker;
import Jet.Concepts.ConceptHierarchy;
import Jet.Console;
import Jet.Control;
import Jet.HMM.BIOWriter;
import Jet.HMM.HMMNameTagger;
import Jet.HMM.HMMTagger;
import Jet.Lex.EnglishLex;
import Jet.Lex.Lexicon;
import Jet.Parser.Grammar;
import Jet.Parser.StatParser;
import Jet.Pat.PatternCollection;
import Jet.Refres.CorefEval;
import Jet.Refres.EntityView;
import Jet.Tipster.AnnotationColor;
import Jet.Tipster.CollectionAnnotationTool;
import Jet.Tipster.CollectionView;
import Jet.Tipster.Document;
import Jet.Tipster.View;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class JetTest {
    public static boolean batchFlag = false;
    protected static Properties defaultConfig = new Properties();
    protected static Properties config = null;
    private static File configFile;
    protected static String dataPath;
    public static PatternCollection pc;
    public static File patternFile;
    protected static Grammar gram;
    public static HMMTagger tagger;
    protected static HMMNameTagger nameTagger;
    protected static Vector views;
    public static ConceptHierarchy conceptHierarchy;
    public static File conceptHierarchyFile;
    public static String encoding;
    static /* synthetic */ Class class$Jet$HMM$WordFeatureHMMemitter;

    public static void initializeFromConfig(File file) {
        try {
            config.load(new FileInputStream(file));
            batchFlag = config.getProperty("Jet.batch") != null;
            dataPath = config.getProperty("Jet.dataPath", ".");
            new AnnotationColor(dataPath);
            JetTest.initialize();
            System.out.println("Jet Ver. 1.30.  Portions (c) 1999-2005 R. Grishman");
            System.out.println("License granted for use in education and research.");
        }
        catch (IOException iOException) {
            System.err.println("Error: could not open file " + file);
            System.err.println("USAGE: JetTest <configFile>");
            System.exit(1);
        }
    }

    public static void initializeFromConfig(String string) {
        JetTest.initializeFromConfig(new File(string));
    }

    public static String getConfig(String string) {
        return config.getProperty(string);
    }

    public static String getConfigFile(String string) {
        String string2 = config.getProperty(string);
        if (string2 == null || new File(string2).isAbsolute()) {
            return string2;
        }
        return dataPath + File.separatorChar + string2;
    }

    public static void initialize() {
        JetTest.readLexicons();
        JetTest.readTags();
        JetTest.readNameTags();
        JetTest.readPatterns();
        JetTest.readGrammar();
        JetTest.readChunkModel();
        if (config.getProperty("StatParser.grammar.fileName") != null) {
            StatParser.initialize(dataPath, config);
        }
        JetTest.readConcepts();
    }

    public static void readLexicons() {
        Lexicon.clear();
        Iterator<Object> iterator = config.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("EnglishLex.fileName")) continue;
            String string2 = config.getProperty(string);
            try {
                EnglishLex.readLexicon(new BufferedReader(new FileReader(dataPath + File.separatorChar + string2)));
            }
            catch (IOException iOException) {
                System.err.println("Error: reading lexicon file " + string2 + ", " + iOException.getMessage());
            }
        }
    }

    public static void readTags() {
        String string = config.getProperty("Tags.fileName");
        if (string != null) {
            try {
                tagger = new HMMTagger();
                tagger.load(dataPath + File.separatorChar + string);
            }
            catch (IOException iOException) {
                System.err.println("Error: reading tag file " + string + ", " + iOException.getMessage());
            }
        }
    }

    public static void readNameTags() {
        String string = config.getProperty("NameTags.fileName");
        if (string != null) {
            try {
                Class clazz;
                String string2 = config.getProperty("NameTags.emitter", "Jet.HMM.WordFeatureHMMemitter");
                try {
                    clazz = Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("Unknown HMM emitter class " + string2);
                    System.out.println("Using class WordFeatureHMMemitter");
                    clazz = class$Jet$HMM$WordFeatureHMMemitter == null ? (class$Jet$HMM$WordFeatureHMMemitter = JetTest.class$("Jet.HMM.WordFeatureHMMemitter")) : class$Jet$HMM$WordFeatureHMMemitter;
                }
                nameTagger = new HMMNameTagger(clazz);
                nameTagger.load(dataPath + File.separatorChar + string);
                if (config.getProperty("NameTags.trace") != null) {
                    JetTest.nameTagger.annotator.setTrace(true);
                }
                if (config.getProperty("NameTags.recordMargin") != null) {
                    JetTest.nameTagger.annotator.setRecordMargin(true);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error: reading name tag file " + string + ", " + iOException.getMessage());
            }
        }
    }

    public static void readPatterns() {
        pc = new PatternCollection();
        Iterator<Object> iterator = config.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("Pattern.fileName")) continue;
            String string2 = config.getProperty(string);
            try {
                patternFile = new File(dataPath + File.separatorChar + string2);
                pc.readPatternCollection(new BufferedReader(new FileReader(patternFile)));
            }
            catch (IOException iOException) {
                System.err.println("Error: reading pattern file " + string2 + ", " + iOException.getMessage());
            }
        }
        pc.makePatternGraph();
    }

    public static void readGrammar() {
        String string = config.getProperty("Grammar.fileName");
        if (string != null) {
            try {
                gram = new Grammar(new BufferedReader(new FileReader(dataPath + File.separatorChar + string)));
            }
            catch (IOException iOException) {
                System.err.println("Error: reading grammar file " + string + ", " + iOException.getMessage());
            }
        }
    }

    public static void readChunkModel() {
        String string = config.getProperty("Chunker.fileName");
        if (string != null) {
            Chunker.loadModel(dataPath + File.separatorChar + string);
        }
    }

    public static void readConcepts() {
        String string = config.getProperty("Concepts.fileName");
        if (batchFlag) {
            if (string != null) {
                System.out.println("Warning:  concept file not supported in batch mode.");
            }
            conceptHierarchyFile = null;
            conceptHierarchy = null;
        } else if (string == null) {
            conceptHierarchyFile = null;
            conceptHierarchy = new ConceptHierarchy();
        } else {
            conceptHierarchyFile = new File(dataPath + File.separatorChar + string);
            conceptHierarchy = new ConceptHierarchy(conceptHierarchyFile);
        }
    }

    public static void processFile(String string, boolean bl) throws IOException {
        Object object;
        long l = System.currentTimeMillis();
        File file = new File(string).isAbsolute() ? new File(string) : new File(dataPath, string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        OutputStreamWriter outputStreamWriter = null;
        if (config.getProperty("WriteSGML.type") != null) {
            object = dataPath + File.separatorChar + "response-" + string;
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), encoding);
        }
        int n = 0;
        while ((object = JetTest.readDocument(bufferedReader)) != null) {
            Control.processDocument((Document)object, outputStreamWriter, bl, ++n);
        }
        if (outputStreamWriter != null) {
            outputStreamWriter.close();
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.println("Processing of file " + string + " took " + l3 + " ms");
    }

    public static void processFiles(boolean bl) {
        Iterator<Object> iterator = config.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("JetTest.fileName")) continue;
            String string2 = config.getProperty(string);
            try {
                JetTest.processFile(string2, bl);
            }
            catch (IOException iOException) {
                System.err.println("Error: could not process document file " + string2 + ", " + iOException.getMessage());
            }
        }
    }

    public static void closeAllViews() {
        for (int i = 0; i < views.size(); ++i) {
            ((View)views.get(i)).dispose();
        }
        views.clear();
    }

    public static Document readDocument(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            if ((string = bufferedReader.readLine()) != null) continue;
            return null;
        } while (!string.trim().equalsIgnoreCase("<DOC>"));
        Document document = new Document();
        document.append(string);
        document.append("\n");
        do {
            if ((string = bufferedReader.readLine()) == null) {
                System.err.println("no </DOC>");
                return null;
            }
            document.append(string);
            document.append("\n");
        } while (!string.trim().equalsIgnoreCase("</DOC>"));
        return document;
    }

    public static boolean setEncoding(String string) {
        try {
            if (Charset.isSupported(string)) {
                encoding = string;
                return true;
            }
            System.out.println("Character set " + string + " is not supported.");
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            System.out.println(string + " is an illegal character set name.");
        }
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Iterator<String> iterator = sortedMap.keySet().iterator();
        System.out.println("Supported character sets are:");
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            Charset charset = (Charset)sortedMap.get(string2);
            System.out.println("  " + string2 + " " + charset.aliases());
        }
        System.out.println(" ");
        return false;
    }

    static boolean hasDisplay() {
        try {
            new JFrame();
            return true;
        }
        catch (InternalError internalError) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0 && ((String)(object = stringArray[0])).length() > 0 && ((String)object).charAt(0) == '-') {
            if (((String)object).equals("-AnnotateCollection")) {
                CollectionAnnotationTool.task(stringArray);
                return;
            }
            if (((String)object).equals("-CorefEval")) {
                CorefEval.task(stringArray);
                System.exit(0);
            } else if (((String)object).equals("-BIOWriter")) {
                BIOWriter.task(stringArray);
                System.exit(0);
            } else {
                if (((String)object).equals("-CorefView")) {
                    EntityView.task(stringArray);
                    return;
                }
                if (((String)object).equals("-CollectionView")) {
                    CollectionView.task(stringArray);
                    return;
                }
                System.out.println("Unknown Jet task: " + (String)object);
                System.exit(1);
            }
        }
        if (stringArray.length == 0) {
            if (!JetTest.hasDisplay()) {
                System.out.println("Error:  no configuration file selected.");
                System.err.println("USAGE: JetTest <configFile>");
                System.exit(1);
            }
            object = new JFileChooser();
            ((JFileChooser)object).setDialogTitle("Select Jet configuration file");
            File file = new File(System.getProperty("user.dir"), "props");
            ((JFileChooser)object).setCurrentDirectory(file);
            int n = ((JFileChooser)object).showOpenDialog(null);
            if (n == 0) {
                configFile = ((JFileChooser)object).getSelectedFile();
            } else {
                System.out.println("Error:  no configuration file selected.");
                System.exit(1);
            }
        } else {
            configFile = new File(stringArray[0]);
            if (stringArray.length > 1) {
                System.out.println("Warning:  extra command line arguments ignored.");
            }
        }
        JetTest.initializeFromConfig(configFile);
        if (batchFlag) {
            JetTest.processFiles(false);
        } else {
            new Console();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        views = new Vector();
        encoding = "ISO-8859-1";
        defaultConfig.put("processDocument", "tag(TEXT), TEXT:processTextZone");
        defaultConfig.put("processTextZone", "sentenceSplit, sentence:processSentence");
        config = new Properties(defaultConfig);
    }
}

