/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.Console;
import Jet.HMM.HMMTagger;
import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Retagger {
    private static HashMap map = new HashMap();

    public static FeatureSet[] ptbToJetFS(String string, String string2) {
        String string3 = string.toLowerCase().intern();
        if (string3 == "do" || string3 == "does" || string3 == "did" || string3 == "done") {
            return new FeatureSet[]{new FeatureSet("cat", "w")};
        }
        if (string2 == "IN") {
            return new FeatureSet[]{new FeatureSet("cat", "p"), new FeatureSet("cat", "sconj")};
        }
        FeatureSet featureSet = (FeatureSet)map.get(string2);
        if (featureSet != null) {
            return new FeatureSet[]{featureSet};
        }
        return new FeatureSet[0];
    }

    public static String jetToPtbPos(FeatureSet featureSet) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FeatureSet featureSet2 = (FeatureSet)map.get(string);
            if (!featureSet2.subsetOf(featureSet)) continue;
            return string;
        }
        return null;
    }

    static void mapConstit(Document document, Span span) {
        Vector vector = document.annotationsOfType("tagger", span);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            String string = document.text(annotation).trim();
            String string2 = (String)annotation.get("cat");
            FeatureSet[] featureSetArray = Retagger.ptbToJetFS(string, string2);
            for (int j = 0; j < featureSetArray.length; ++j) {
                document.annotate("constit", annotation.span(), new FeatureSet(featureSetArray[j]));
                if (!HMMTagger.trace) continue;
                Console.println("Annotating " + document.text(annotation.span()) + " as <constit" + featureSetArray[j].toSGMLString() + ">");
            }
        }
    }

    public static void pruneConstit(Document document, Span span) {
        Vector vector;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = span.start();
        int n2 = span.end();
        while (document.annotationsAt(n, "tagger") == null) {
            if (++n < n2) continue;
            return;
        }
        while (n < n2 && (vector = document.annotationsAt(n, "tagger")) != null) {
            Object object;
            Object object2;
            int n3;
            Annotation annotation = (Annotation)vector.get(0);
            boolean bl = annotation.get("cat").equals("POS");
            Span span2 = annotation.span();
            String string = document.text(span2).trim();
            String string2 = (String)annotation.get("cat");
            FeatureSet[] featureSetArray = Retagger.ptbToJetFS(string, string2);
            Vector vector2 = document.annotationsAt(n, "constit");
            if (vector2 == null) {
                for (n3 = 0; n3 < featureSetArray.length; ++n3) {
                    object2 = new FeatureSet(featureSetArray[n3]);
                    object = (String)((FeatureSet)object2).get("cat");
                    if (object == "n") {
                        ((FeatureSet)object2).put("pa", new FeatureSet("head", string));
                    }
                    document.annotate("constit", span2, (FeatureSet)object2);
                }
            } else {
                arrayList.clear();
                for (n3 = 0; n3 < vector2.size(); ++n3) {
                    object2 = (Annotation)vector2.get(n3);
                    object = ((Annotation)object2).attributes();
                    for (int i = 0; i < featureSetArray.length; ++i) {
                        if (FeatureSet.unify(featureSetArray[i], (FeatureSet)object) == null) continue;
                        arrayList.add(object2);
                    }
                }
                if (!arrayList.isEmpty() || bl) {
                    for (n3 = 0; n3 < vector2.size(); ++n3) {
                        object2 = (Annotation)vector2.get(n3);
                        if (arrayList.contains(object2)) continue;
                        document.removeAnnotation((Annotation)object2);
                        if (!HMMTagger.trace) continue;
                        Console.println("Removing " + object2 + " on " + document.text(((Annotation)object2).span()));
                    }
                }
            }
            n = span2.end();
        }
    }

    public static boolean compatible(String string, String string2, Annotation annotation) {
        FeatureSet[] featureSetArray = Retagger.ptbToJetFS(string.toLowerCase(), string2);
        FeatureSet featureSet = annotation.attributes();
        for (int i = 0; i < featureSetArray.length; ++i) {
            if (FeatureSet.unify(featureSetArray[i], featureSet) == null) continue;
            return true;
        }
        return false;
    }

    static {
        map.put("CC", new FeatureSet("cat", "cconj"));
        map.put("CD", new FeatureSet("cat", "q"));
        map.put("DT", new FeatureSet("cat", "det"));
        map.put("JJ", new FeatureSet("cat", "adj"));
        map.put("JJR", new FeatureSet("cat", "adj"));
        map.put("JJS", new FeatureSet("cat", "adj"));
        map.put("MD", new FeatureSet("cat", "w"));
        map.put("NN", new FeatureSet("cat", "n", "number", "singular"));
        map.put("NNS", new FeatureSet("cat", "n", "number", "plural"));
        map.put("PDT", new FeatureSet("cat", "adv"));
        map.put("PRP", new FeatureSet("cat", "pro"));
        map.put("PRP$", new FeatureSet("cat", "det"));
        map.put("RB", new FeatureSet("cat", "adv"));
        map.put("RBR", new FeatureSet("cat", "adv"));
        map.put("RBS", new FeatureSet("cat", "adv"));
        map.put("RP", new FeatureSet("cat", "dp"));
        map.put("TO", new FeatureSet("cat", "p"));
        map.put("VB", new FeatureSet("cat", "v"));
        map.put("VBD", new FeatureSet("cat", "tv"));
        map.put("VBG", new FeatureSet("cat", "ving"));
        map.put("VBN", new FeatureSet("cat", "ven"));
        map.put("VBP", new FeatureSet("cat", "tv", "number", "plural"));
        map.put("VBZ", new FeatureSet("cat", "tv", "number", "singular"));
    }
}

