package Jet.Sense;

import java.io.Serializable;
import java.util.*;

import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.Synset;

/**
 * CategorySorter represents a mapping from WordNet Synsets to a set of more general categories
 * (such as ACE entity types). Particular mappings must be implemented as subclasses.
 * 
 * @author M. David Westbrook
 * Jun 18, 2004
 *  */
public abstract class CategorySorter implements Serializable{
	protected Category[] categories;
	protected HashMap labelIndex = new HashMap();
	static final long serialVersionUID = 1; // Helps with serialization
	
    /**
     * Creates a set of bins (in the form of a HashMap of HashSets) that can be 
     * used to sort objects by Category.
     * @return A HashMap that associates an empty HashSet with each
     * Category in categories.
     */
    public HashMap getCategoryBins() {
		HashMap bins = new HashMap();
		for (int i=0; i < categories.length; i++)
			bins.put(categories[i], new HashSet());
		return bins;
    }
    
    /**
     * 
     * @param label The name of a Category
     * @return The Category associated with label
     */
    public Category getCategoryForLabel(String label) {
    	return (Category) labelIndex.get(label.toLowerCase().trim());
    }
    
    /**
     * Builds a HashMap from String labels to associated categories, and stores it
     * in labelIndex.
     */
    protected void buildLabelIndex() {
    	labelIndex = new HashMap();
    	for (int c=0; c < categories.length; c++)
    		labelIndex.put(categories[c].getLabel(), categories[c]);
    }
    
    public String toString() {
    	StringBuffer result = new StringBuffer();
    	for (int c=0; c < categories.length; c++) result.append(categories[c] + "\n");
    	return result.toString();
    }
    
    /**
     * Given a Synset, return the Category associated with this synset
     * @param synset The word sense to be categorized
     * @return The Category into which this CategorySorter places synset
     * @throws JWNLException Indicates a problem with the Java-WordNet interface
     */
    public abstract Category categorize(Synset synset) throws JWNLException;
}
