/*
 * Decompiled with CFR 0.152.
 */
package pnuts.security;

import pnuts.lang.Context;
import pnuts.lang.Package;
import pnuts.security.PackagePermission;

public class SecurePackage
extends Package {
    public SecurePackage(String name, Package parent) {
        super(name, parent);
    }

    protected void addPackage(Package pkg, Context context) {
        this.checkPackageAccess(pkg, "add");
        super.addPackage(pkg, context);
    }

    public void set(String symbol, Object obj, Context context) {
        this.checkPackageAccess(this, "write");
        super.set(symbol, obj, context);
    }

    public void clear(String symbol, Context context) {
        this.checkPackageAccess(this, "write");
        super.clear(symbol, context);
    }

    protected void removePackage(Package pkg, Context context) {
        this.checkPackageAccess(pkg, "remove");
        super.removePackage(pkg, context);
    }

    void checkPackageAccess(Package pkg, String action) {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return;
        }
        String name = pkg.getName();
        if (name == null) {
            return;
        }
        if ("".equals(name)) {
            name = "::";
        }
        security.checkPermission(new PackagePermission(name, action));
    }
}

