/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import org.pnuts.lang.ConstraintsTransformer;
import org.pnuts.lang.Signature;
import org.pnuts.lang.SubtypeGenerator;
import pnuts.lang.BinaryOperator;
import pnuts.lang.Binding;
import pnuts.lang.Context;
import pnuts.lang.Escape;
import pnuts.lang.Function;
import pnuts.lang.Generator;
import pnuts.lang.ImportEnv;
import pnuts.lang.Jump;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.lang.StackFrame;
import pnuts.lang.Visitor;

public class PnutsInterpreter
extends Runtime
implements Visitor {
    private static final Integer one = new Integer(1);
    private static final Object[] NO_PARAM = PnutsException.NO_PARAM;
    private static final Object GENERATOR = new Object();
    private static final Object FUNCTION = new Object();
    static PnutsInterpreter instance = new PnutsInterpreter();
    static final int CODE = 0;
    static final int VALUE = 1;
    static final int BROKEN = 0;
    static final int CONT = 1;
    static final int PASSED = 2;
    static /* synthetic */ Class class$java$lang$Object;

    static PnutsInterpreter getInstance() {
        return instance;
    }

    public Object start(SimpleNode node, Context context) {
        if (node.jjtGetNumChildren() > 0) {
            if (context.stackFrame == null) {
                context.stackFrame = new StackFrame();
            }
            try {
                return this.accept(node, 0, context);
            }
            catch (Throwable t) {
                Runtime.checkException(context, t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object startSet(SimpleNode node, Context context) {
        if (context.stackFrame == null) {
            context.stackFrame = new StackFrame();
        }
        int n = node.jjtGetNumChildren();
        Object ret = null;
        try {
            for (int i = 0; i < n; ++i) {
                ret = this.accept(node, i, context);
            }
        }
        catch (Throwable t) {
            Runtime.checkException(context, t);
        }
        finally {
            PrintWriter pw = context.getWriter();
            if (pw != null) {
                pw.flush();
            }
        }
        return ret;
    }

    public Object expressionList(SimpleNode node, Context context) {
        Object ret = null;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            ret = this.accept(node, i, context);
        }
        return ret;
    }

    public Object global(SimpleNode node, Context context) {
        NamedValue val;
        String symbol = node.str;
        Package pkg = Package.find("", context);
        if (pkg != null && (val = pkg.lookup(symbol, context)) != null) {
            return val.get();
        }
        return context.undefined(symbol);
    }

    public Object idNode(SimpleNode node, Context context) {
        return context.getValue(node.str);
    }

    public Object className(SimpleNode node, Context context) {
        return PnutsInterpreter.resolveClassNameNode(node, context);
    }

    public Object arrayType(SimpleNode node, Context context) {
        SimpleNode n;
        int count = 0;
        for (n = node; n != null && n.id == 14; n = n.jjtGetChild(0)) {
            ++count;
        }
        if (n != null && n.id == 15) {
            Object[] idx = PnutsInterpreter.parseIndex(n);
            SimpleNode idx0 = (SimpleNode)idx[0];
            Object tgt = idx0.accept(this, context);
            if (!(tgt instanceof Class)) {
                throw new PnutsException("classOrArray.expected", new Object[]{Pnuts.format(tgt)}, context);
            }
            Class type = Runtime.arrayType((Class)tgt, count);
            Object[] dim = (Object[])idx[1];
            int[] idim = new int[dim.length];
            for (int i = 0; i < dim.length; ++i) {
                Object o = ((SimpleNode)dim[i]).accept(this, context);
                if (!(o instanceof Number)) {
                    throw new PnutsException("number.expected", new Object[]{Pnuts.format(o)}, context);
                }
                idim[i] = ((Number)o).intValue();
            }
            return Array.newInstance(type, idim);
        }
        if (node.jjtGetParent().id != 10) {
            Object tgt = n.accept(this, context);
            if (tgt instanceof Class) {
                return Runtime.arrayType((Class)tgt, count);
            }
            throw new PnutsException("classOrArray.expected", new Object[]{Pnuts.format(tgt)}, context);
        }
        throw new IllegalArgumentException();
    }

    public Object[] _listElements(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        Object[] array = new Object[n];
        for (int i = 0; i < n; ++i) {
            array[i] = this.accept(node, i, context);
        }
        return array;
    }

    public Object listElements(SimpleNode node, Context context) {
        return context.config.makeArray(this._listElements(node, context), context);
    }

    public Object mapNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        Map map = context.config.createMap(n, context);
        for (int i = 0; i < n; ++i) {
            SimpleNode c = node.jjtGetChild(i);
            map.put(this.accept(c, 0, context), this.accept(c, 1, context));
        }
        return map;
    }

    public Object castExpression(SimpleNode node, Context context) {
        SimpleNode typeNode = node.jjtGetChild(0);
        Class type = null;
        if (typeNode.id == 14) {
            SimpleNode n;
            int count = 0;
            for (n = typeNode; n != null && n.id == 14; n = n.jjtGetChild(0)) {
                ++count;
            }
            if (n != null && n.id == 16) {
                type = Runtime.arrayType(PnutsInterpreter.resolveClassNameNode(n, context), count);
            }
        } else if (typeNode.id == 16) {
            type = PnutsInterpreter.resolveClassNameNode(typeNode, context);
        } else {
            throw new RuntimeException();
        }
        Object obj = this.accept(node, 1, context);
        return Runtime.cast(context, type, obj, true);
    }

    public Object classNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            return PnutsFunction.CLASS;
        }
        SimpleNode c = node.jjtGetChild(0);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(c.children[0].str);
        n = c.jjtGetNumChildren();
        for (int i = 1; i < n; ++i) {
            SimpleNode ch = c.children[i];
            sbuf.append('.');
            sbuf.append(ch.str);
        }
        try {
            return Pnuts.loadClass(sbuf.toString(), context);
        }
        catch (ClassNotFoundException e) {
            throw new PnutsException(e, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        SimpleNode n0 = node.jjtGetChild(0);
        if (n == 3 && node.jjtGetChild((int)2).id == 12) {
            Package pkg = context.getCurrentPackage();
            Package fmap = new Package(null, null);
            SimpleNode classDef = node.jjtGetChild(2);
            ArrayList<Signature> signatures = new ArrayList<Signature>();
            for (int i = 0; i < classDef.jjtGetNumChildren(); ++i) {
                SimpleNode blk;
                SimpleNode param;
                SimpleNode methodDef = classDef.jjtGetChild(i);
                SimpleNode n1 = methodDef.jjtGetChild(0);
                Class returnType = null;
                if (n1.id == 16) {
                    returnType = PnutsInterpreter.resolveClassNameNode(n1, context);
                    param = methodDef.jjtGetChild(1);
                    blk = methodDef.jjtGetChild(2);
                } else {
                    param = methodDef.jjtGetChild(0);
                    blk = methodDef.jjtGetChild(1);
                }
                SimpleNode simpleNode = methodDef;
                synchronized (simpleNode) {
                    if (methodDef.getAttribute("type") == null) {
                        if (Runtime.isGenerator(methodDef)) {
                            methodDef.setAttribute("type", GENERATOR);
                        } else {
                            methodDef.setAttribute("type", FUNCTION);
                        }
                    }
                }
                int nargs = param.jjtGetNumChildren();
                String[] locals = new String[nargs + 2];
                Class[] paramTypes = new Class[nargs];
                for (int j = 0; j < nargs; ++j) {
                    SimpleNode p = param.jjtGetChild(j);
                    if (p.jjtGetNumChildren() > 1) {
                        locals[j + 2] = p.jjtGetChild((int)1).str;
                        paramTypes[j] = PnutsInterpreter.resolveClassNameNode(p.jjtGetChild(0), context);
                        continue;
                    }
                    locals[j + 2] = p.jjtGetChild((int)0).str;
                    paramTypes[j] = null;
                }
                locals[0] = "this".intern();
                locals[1] = "super".intern();
                String symbol = methodDef.str;
                Function f = methodDef.getAttribute("type") == GENERATOR ? new Generator.GeneratorFunction(symbol, locals, nargs + 2, blk, pkg, context) : new Function(symbol, locals, nargs + 2, blk, pkg, context);
                PnutsFunction ph = (PnutsFunction)fmap.get(symbol);
                signatures.add(new Signature(symbol, returnType, paramTypes, null));
                fmap.set(symbol, f.register(ph));
            }
            SimpleNode nameNode = node.jjtGetChild(0);
            Class cls = PnutsInterpreter.resolveClassNameNode(nameNode, context);
            Signature[] s = new Signature[signatures.size()];
            signatures.toArray(s);
            Class cls2 = PnutsInterpreter.define(cls, s, fmap, context);
            Object[] arg = this._listElements(node.jjtGetChild(1), context);
            return Runtime.callConstructor(context, cls2, arg, null);
        }
        if (n0.id == 15) {
            Object[] idx = PnutsInterpreter.parseIndex(n0);
            SimpleNode c = (SimpleNode)idx[0];
            Object[] dim = (Object[])idx[1];
            Class cls = PnutsInterpreter.resolveClassNameNode(c, context);
            return this.newArray(cls, dim, context);
        }
        if (n0.id == 14) {
            return this.arrayType(n0, context);
        }
        if (n0.id == 11) {
            Class type = (Class)this.accept(n0, 0, context);
            Object[] obj = this._listElements(n0.jjtGetChild(1), context);
            return Runtime.cast(context, type, obj, true);
        }
        SimpleNode nameNode = node.jjtGetChild(0);
        Class cls = PnutsInterpreter.resolveClassNameNode(nameNode, context);
        Object[] arg = this._listElements(node.jjtGetChild(1), context);
        return Runtime.callConstructor(context, cls, arg, null);
    }

    static Class define(Class type, Signature[] sigs, Package pkg, Context context) {
        Class superclass;
        Class[] itf;
        String className = type.getName().replace('.', '_') + "__adapter";
        if (type.isInterface()) {
            itf = new Class[]{type};
            superclass = class$java$lang$Object == null ? (class$java$lang$Object = PnutsInterpreter.class$("java.lang.Object")) : class$java$lang$Object;
        } else {
            itf = null;
            superclass = type;
        }
        return SubtypeGenerator.generateSubclass(className, superclass, itf, sigs, pkg, context, 3);
    }

    public Object classDef(SimpleNode node, Context context) {
        return null;
    }

    public Object methodDef(SimpleNode node, Context context) {
        return null;
    }

    public Object importNode(SimpleNode node, Context context) {
        String t2 = node.str;
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            if ("*".equals(t2)) {
                context.addPackageToImport("");
            } else {
                if ("(".equals(t2)) {
                    return context.importEnv.list();
                }
                return PnutsFunction.IMPORT;
            }
        }
        if (n == 1 && node.children[0].id != 17) {
            String s = (String)node.children[0].accept(this, context);
            if (s == null) {
                context.importEnv = new ImportEnv();
            } else if (!s.endsWith("*")) {
                context.addClassToImport(s);
            } else {
                int idx = s.lastIndexOf(46);
                if (idx > 0) {
                    context.addPackageToImport(s.substring(0, idx));
                } else {
                    context.addPackageToImport("");
                }
            }
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(node.children[0].str);
        for (int i = 1; i < n; ++i) {
            sbuf.append('.');
            sbuf.append(node.children[i].str);
        }
        String arg = sbuf.toString();
        if (node.info != null) {
            context.addStaticMembers(arg, t2 != null);
        } else if (t2 == null) {
            context.addClassToImport(arg);
        } else {
            context.addPackageToImport(arg);
        }
        return null;
    }

    public Object rangeNode(SimpleNode node, Context context) {
        Object target = this.accept(node, 0, context);
        Object idx1 = this.accept(node, 1, context);
        Object idx2 = null;
        if (node.jjtGetNumChildren() >= 3) {
            idx2 = this.accept(node, 2, context);
        }
        return Runtime.getRange(target, idx1, idx2, context);
    }

    static Object[] parseIndex(SimpleNode node) {
        SimpleNode c0 = node.jjtGetChild(0);
        SimpleNode c1 = node.jjtGetChild(1);
        if (c0.id != 15) {
            return new Object[]{c0, new Object[]{c1}};
        }
        Object[] r = PnutsInterpreter.parseIndex(c0);
        Object[] d = (Object[])r[1];
        Object[] a = new Object[d.length + 1];
        System.arraycopy(d, 0, a, 0, d.length);
        a[d.length] = c1;
        return new Object[]{r[0], a};
    }

    static void convertIndexNode(SimpleNode node) {
        SimpleNode n0 = node.jjtGetChild(0);
        SimpleNode n1 = node.jjtGetChild(1);
        if (ConstraintsTransformer.isPredicate(n1)) {
            SimpleNode n = ConstraintsTransformer.buildFunc(n1);
            node.jjtAddChild(n, 1);
            n.jjtSetParent(node);
        }
        if (n0.id == 15) {
            PnutsInterpreter.convertIndexNode(n0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object indexNode(SimpleNode node, Context context) {
        SimpleNode simpleNode = node;
        synchronized (simpleNode) {
            if (node.getAttribute("index") == null) {
                node.setAttribute("index", Boolean.TRUE);
                PnutsInterpreter.convertIndexNode(node);
            }
        }
        Object[] idx = PnutsInterpreter.parseIndex(node);
        SimpleNode c = (SimpleNode)idx[0];
        Object[] dim = (Object[])idx[1];
        Object target = c.accept(this, context);
        if (target instanceof Class) {
            return this.newArray((Class)target, dim, context);
        }
        for (int i = 0; i < dim.length; ++i) {
            target = Runtime.getElement(target, ((SimpleNode)dim[i]).accept(this, context), context);
        }
        return target;
    }

    Object newArray(Class cls, Object[] dim, Context context) {
        int[] sizes = new int[dim.length];
        for (int i = 0; i < dim.length; ++i) {
            sizes[i] = ((Number)((SimpleNode)dim[i]).accept(this, context)).intValue();
        }
        return Array.newInstance(cls, sizes);
    }

    public Object methodNode(SimpleNode node, Context context) {
        Object target = this.accept(node, 0, context);
        Object[] arg = this._listElements(node.jjtGetChild(1), context);
        SimpleNode argNode = node.children[1];
        Class[] types = null;
        for (int i = 0; i < arg.length; ++i) {
            SimpleNode n = argNode.children[i];
            if (n.id != 69) continue;
            if (types == null) {
                types = new Class[arg.length];
            }
            types[i] = this.resolveType(n.jjtGetChild(0), context);
        }
        if (target == null) {
            PnutsException pe = new PnutsException(new NullPointerException(), context);
            pe.line = node.beginLine;
            throw pe;
        }
        return Runtime.callMethod(context, target.getClass(), node.str, arg, types, target);
    }

    public Object staticMethodNode(SimpleNode node, Context context) {
        SimpleNode c1 = node.children[0];
        String pkgName = PnutsInterpreter.getPackageName(c1);
        SimpleNode argNode = node.children[1];
        Class[] types = null;
        Object[] arg = null;
        Package pkg = Package.find(pkgName, context);
        if (pkg != null) {
            Object fun = pkg.get(node.str, context);
            if (fun instanceof PnutsFunction) {
                arg = this._listElements(node.jjtGetChild(1), context);
                PnutsFunction ft = (PnutsFunction)fun;
                return ft.exec(arg, context);
            }
            if (fun instanceof Class) {
                arg = this._listElements(node.jjtGetChild(1), context);
                for (int i = 0; i < arg.length; ++i) {
                    SimpleNode n = argNode.children[i];
                    if (n.id != 69) continue;
                    if (types == null) {
                        types = new Class[arg.length];
                    }
                    types[i] = this.resolveType(n.jjtGetChild(0), context);
                }
                return Runtime.callConstructor(context, (Class)fun, arg, types);
            }
            throw new PnutsException("illegal.staticCall", new Object[]{pkgName, node.str, new Integer(argNode.jjtGetNumChildren())}, context);
        }
        Object target = this.accept(node, 0, context);
        arg = this._listElements(node.jjtGetChild(1), context);
        if (target instanceof Class) {
            for (int i = 0; i < arg.length; ++i) {
                SimpleNode n = argNode.children[i];
                if (n.id != 69) continue;
                if (types == null) {
                    types = new Class[arg.length];
                }
                types[i] = this.resolveType(n.jjtGetChild(0), context);
            }
            return Runtime.callMethod(context, (Class)target, node.str, arg, types, null);
        }
        throw new PnutsException("illegal.staticCall", new Object[]{pkgName, node.str, new Integer(arg.length)}, context);
    }

    public Object memberNode(SimpleNode node, Context context) {
        Object target = this.accept(node, 0, context);
        if (target == null) {
            throw new PnutsException(new NullPointerException(), context);
        }
        if (Runtime.isArray(target) && node.str.equals("length")) {
            return new Integer(Runtime.getArrayLength(target));
        }
        return Runtime.getField(context, target, node.str);
    }

    static String getPackageName(SimpleNode node) {
        if (node.jjtGetNumChildren() > 0) {
            SimpleNode c1 = node.children[0];
            return PnutsInterpreter.getPackageName(c1) + "::" + node.str;
        }
        return node.str;
    }

    public Object staticMemberNode(SimpleNode node, Context context) {
        SimpleNode c1 = node.children[0];
        String pkgName = PnutsInterpreter.getPackageName(c1);
        Package pkg = Package.find(pkgName, context);
        if (pkg != null) {
            NamedValue v = pkg.lookup(node.str, context);
            if (v != null) {
                return v.get();
            }
            return context.undefined(node.str);
        }
        Object target = c1.accept(this, context);
        if (target instanceof Class) {
            return Runtime.getStaticField(context, (Class)target, node.str);
        }
        throw new PnutsException("packageOrClass.expected", new Object[]{Pnuts.format(target)}, context);
    }

    public Object applicationNode(SimpleNode node, Context context) {
        Object target = this.accept(node, 0, context);
        Object[] arg = this._listElements(node.jjtGetChild(1), context);
        SimpleNode argNode = node.children[1];
        Class[] types = null;
        for (int i = 0; i < arg.length; ++i) {
            SimpleNode n = argNode.children[i];
            if (n.id != 69) continue;
            if (types == null) {
                types = new Class[arg.length];
            }
            types[i] = this.resolveType(n.jjtGetChild(0), context);
        }
        return Runtime.call(context, target, arg, types, node.beginLine, node.beginColumn);
    }

    public Object integerNode(SimpleNode node, Context context) {
        if (node.value != null) {
            return node.value;
        }
        String str = node.str;
        Object[] a = (Object[])node.info;
        int[] off = (int[])a[1];
        Number n = (Number)a[0];
        if (off != null) {
            int offset = off[0];
            return Runtime.quantity(n, str.substring(0, offset), str.substring(offset), context);
        }
        node.value = n;
        return n;
    }

    public Object floatingNode(SimpleNode node, Context context) {
        if (node.value != null) {
            return node.value;
        }
        String str = node.str;
        Object[] p = (Object[])node.info;
        Number n = (Number)p[0];
        if (p[1] != null) {
            int offset = ((int[])p[1])[0];
            return Runtime.quantity(n, str.substring(0, offset), str.substring(offset), context);
        }
        node.value = n;
        return n;
    }

    public Object characterNode(SimpleNode node, Context context) {
        return node.info;
    }

    public Object stringNode(SimpleNode node, Context context) {
        return node.str;
    }

    public Object trueNode(SimpleNode node, Context context) {
        return Boolean.TRUE;
    }

    public Object falseNode(SimpleNode node, Context context) {
        return Boolean.FALSE;
    }

    public Object nullNode(SimpleNode node, Context context) {
        return null;
    }

    private Object doAssign(SimpleNode node, Object expr, Context context, BinaryOperator op) {
        if (node.id == 5) {
            if (op != null) {
                expr = op.operateOn(context.getValue(node.str), expr);
            }
            if (context.inGeneratorClosure) {
                if (context.frame.outer != null) {
                    context.setValue(node.str, expr);
                } else {
                    context.getCurrentPackage().set(node.str, expr);
                }
            } else {
                context.setValue(node.str, expr);
            }
            return expr;
        }
        if (node.id == 4) {
            Package pkg = Package.getPackage("", context);
            if (op != null) {
                expr = op.operateOn(pkg.get(node.str, context), expr);
            }
            pkg.set(node.str, expr, context);
            return expr;
        }
        if (node.id == 15) {
            Object o = this.accept(node, 0, context);
            Object idx = this.accept(node, 1, context);
            if (o instanceof String) {
                if (op != null || !(expr instanceof Character)) {
                    throw new PnutsException("illegal.assign", NO_PARAM, context);
                }
                expr = Runtime.setRange(o, idx, idx, expr, context);
                context.setValue(node.jjtGetChild((int)0).str, expr);
                return expr;
            }
            if (op != null) {
                expr = op.operateOn(Runtime.getElement(o, idx, context), expr);
            }
            Runtime.setElement(o, idx, expr, context);
            return expr;
        }
        if (node.id == 21) {
            SimpleNode c1 = node.children[0];
            String pkgName = PnutsInterpreter.getPackageName(c1);
            Package pkg = Package.find(pkgName, context);
            if (pkg != null) {
                if (op != null) {
                    Object f = pkg.get(node.str, context);
                    expr = op.operateOn(f, expr);
                }
                pkg.set(node.str, expr, context);
                return expr;
            }
            Object target = c1.accept(this, context);
            if (target instanceof Class) {
                Class clazz = (Class)target;
                if (op != null) {
                    expr = op.operateOn(Runtime.getStaticField(context, clazz, node.str), expr);
                }
                Runtime.putStaticField(context, clazz, node.str, expr);
                return expr;
            }
            throw new PnutsException("package.notFound", NO_PARAM, context);
        }
        if (node.id == 20) {
            Object target = this.accept(node, 0, context);
            if (op != null) {
                expr = op.operateOn(Runtime.getField(context, target, node.str), expr);
            }
            Runtime.putField(context, target, node.str, expr);
            return expr;
        }
        if (node.id == 23) {
            if (op != null) {
                throw new PnutsException("illegal.assign", NO_PARAM, context);
            }
            Object target = this.accept(node, 0, context);
            Object idx1 = this.accept(node, 1, context);
            Object idx2 = null;
            if (node.jjtGetNumChildren() >= 3) {
                idx2 = this.accept(node, 2, context);
            }
            Object value = Runtime.setRange(target, idx1, idx2, expr, context);
            if (target instanceof String) {
                SimpleNode cld = node.children[0];
                if (cld.id == 5 || cld.id == 4 || cld.id == 15 || cld.id == 21 || cld.id == 20) {
                    return this.doAssign(cld, value, context, null);
                }
                return value;
            }
            return value;
        }
        throw new PnutsException("illegal.assign", NO_PARAM, context);
    }

    private Object assign(SimpleNode node, Context context, BinaryOperator op) {
        Object expr = this.accept(node, 1, context);
        try {
            return this.doAssign(node.children[0], expr, context, op);
        }
        catch (PnutsException p) {
            throw p;
        }
        catch (Throwable t) {
            throw new PnutsException(t, context);
        }
    }

    public Object assignment(SimpleNode node, Context context) {
        return this.assign(node, context, null);
    }

    public Object assignmentTA(SimpleNode node, Context context) {
        return this.assign(node, context, context._multiply);
    }

    public Object assignmentMA(SimpleNode node, Context context) {
        return this.assign(node, context, context._mod);
    }

    public Object assignmentDA(SimpleNode node, Context context) {
        return this.assign(node, context, context._divide);
    }

    public Object assignmentPA(SimpleNode node, Context context) {
        return this.assign(node, context, context._add);
    }

    public Object assignmentSA(SimpleNode node, Context context) {
        return this.assign(node, context, context._subtract);
    }

    public Object assignmentLA(SimpleNode node, Context context) {
        return this.assign(node, context, context._shiftLeft);
    }

    public Object assignmentRA(SimpleNode node, Context context) {
        return this.assign(node, context, context._shiftRight);
    }

    public Object assignmentRAA(SimpleNode node, Context context) {
        return this.assign(node, context, context._shiftArithmetic);
    }

    public Object assignmentAA(SimpleNode node, Context context) {
        return this.assign(node, context, context._and);
    }

    public Object assignmentEA(SimpleNode node, Context context) {
        return this.assign(node, context, context._xor);
    }

    public Object assignmentOA(SimpleNode node, Context context) {
        return this.assign(node, context, context._or);
    }

    public Object logOrNode(SimpleNode node, Context context) {
        Object o1 = this.accept(node, 0, context);
        if (!(o1 instanceof Boolean)) {
            o1 = Runtime.toBoolean(o1);
        }
        if (((Boolean)o1).booleanValue()) {
            return Boolean.TRUE;
        }
        Object o2 = this.accept(node, 1, context);
        if (!(o2 instanceof Boolean)) {
            o2 = Runtime.toBoolean(o2);
        }
        return o2;
    }

    public Object logAndNode(SimpleNode node, Context context) {
        Object o1 = this.accept(node, 0, context);
        if (!(o1 instanceof Boolean)) {
            o1 = Runtime.toBoolean(o1);
        }
        if (((Boolean)o1).booleanValue()) {
            Object o2 = this.accept(node, 1, context);
            if (!(o2 instanceof Boolean)) {
                o2 = Runtime.toBoolean(o2);
            }
            return o2;
        }
        return Boolean.FALSE;
    }

    public Object orNode(SimpleNode node, Context context) {
        return context._or.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object xorNode(SimpleNode node, Context context) {
        return context._xor.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object andNode(SimpleNode node, Context context) {
        return context._and.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object equalNode(SimpleNode node, Context context) {
        return Runtime.eq(this.accept(node, 0, context), this.accept(node, 1, context), context) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object notEqNode(SimpleNode node, Context context) {
        return Runtime.eq(this.accept(node, 0, context), this.accept(node, 1, context), context) ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object instanceofExpression(SimpleNode node, Context context) {
        Object o1 = this.accept(node, 0, context);
        Class type = this.resolveType(node.jjtGetChild(1), context);
        return type.isInstance(o1) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object ltNode(SimpleNode node, Context context) {
        if (context._lt.operateOn(this.accept(node, 0, context), this.accept(node, 1, context))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object gtNode(SimpleNode node, Context context) {
        if (context._gt.operateOn(this.accept(node, 0, context), this.accept(node, 1, context))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object leNode(SimpleNode node, Context context) {
        if (context._le.operateOn(this.accept(node, 0, context), this.accept(node, 1, context))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object geNode(SimpleNode node, Context context) {
        if (context._ge.operateOn(this.accept(node, 0, context), this.accept(node, 1, context))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object shiftLeftNode(SimpleNode node, Context context) {
        try {
            return context._shiftLeft.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object shiftRightNode(SimpleNode node, Context context) {
        try {
            return context._shiftRight.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object shiftArithmeticNode(SimpleNode node, Context context) {
        try {
            return context._shiftArithmetic.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object addNode(SimpleNode node, Context context) {
        try {
            return context._add.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object subtractNode(SimpleNode node, Context context) {
        try {
            return context._subtract.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object multNode(SimpleNode node, Context context) {
        try {
            return context._multiply.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object divideNode(SimpleNode node, Context context) {
        try {
            return context._divide.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object modNode(SimpleNode node, Context context) {
        try {
            return context._mod.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object negativeNode(SimpleNode node, Context context) {
        try {
            return context._negate.operateOn(this.accept(node, 0, context));
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object preIncrNode(SimpleNode node, Context context) {
        return this.doAssign(node.children[0], one, context, context._add);
    }

    public Object preDecrNode(SimpleNode node, Context context) {
        return this.doAssign(node.children[0], one, context, context._subtract);
    }

    public Object postIncrNode(SimpleNode node, Context context) {
        SimpleNode n = node.children[0];
        Object ret = n.accept(this, context);
        this.doAssign(n, one, context, context._add);
        return ret;
    }

    public Object postDecrNode(SimpleNode node, Context context) {
        SimpleNode n = node.children[0];
        Object ret = n.accept(this, context);
        this.doAssign(n, one, context, context._subtract);
        return ret;
    }

    public Object notNode(SimpleNode node, Context context) {
        return context._not.operateOn(this.accept(node, 0, context));
    }

    public Object logNotNode(SimpleNode node, Context context) {
        Object o = this.accept(node, 0, context);
        if (o instanceof Boolean) {
            return (Boolean)o != false ? Boolean.FALSE : Boolean.TRUE;
        }
        return Runtime.toBoolean(o) != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object continueNode(SimpleNode node, Context context) {
        throw new Runtime.Continue();
    }

    public Object breakNode(SimpleNode node, Context context) {
        Object o = null;
        if (node.jjtGetNumChildren() > 0) {
            o = this.accept(node, 0, context);
        }
        if (context.inGeneratorClosure) {
            throw new Generator.Break(o);
        }
        throw new Runtime.Break(o);
    }

    public Object returnNode(SimpleNode node, Context context) {
        Object o = null;
        if (node.jjtGetNumChildren() > 0) {
            o = this.accept(node, 0, context);
        }
        throw new Jump(o);
    }

    public Object yieldNode(SimpleNode node, Context context) {
        throw new PnutsException("yield must be used in a generator function", context);
    }

    public Object catchNode(SimpleNode node, Context context) {
        int nargs = node.jjtGetNumChildren();
        if (nargs == 0) {
            return PnutsFunction.CATCH;
        }
        if (nargs == 1) {
            Class cls = (Class)this.accept(node, 0, context);
            PnutsFunction func = (PnutsFunction)this.accept(node, 1, context);
            context.catchException(cls, func);
        }
        return null;
    }

    public Object throwNode(SimpleNode node, Context context) {
        int nargs = node.jjtGetNumChildren();
        if (nargs == 0) {
            return PnutsFunction.THROW;
        }
        if (nargs == 1) {
            Object arg = this.accept(node, 0, context);
            if (arg instanceof PnutsException) {
                throw (PnutsException)arg;
            }
            if (arg instanceof Throwable) {
                throw new PnutsException((Throwable)arg, context);
            }
            throw new PnutsException(String.valueOf(arg), context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object finallyNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 1) {
            PnutsFunction f = (PnutsFunction)this.accept(node, 0, context);
            context.setFinallyFunction(f);
            return f;
        }
        if (n == 2) {
            PnutsFunction f0 = (PnutsFunction)this.accept(node, 0, context);
            PnutsFunction f1 = (PnutsFunction)this.accept(node, 1, context);
            try {
                Object object = f0.exec(NO_PARAM, context);
                return object;
            }
            finally {
                f1.exec(NO_PARAM, context);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object tryStatement(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        SimpleNode lastNode = node.jjtGetChild(n - 1);
        PnutsException pe = null;
        Object value = null;
        boolean handled = false;
        SimpleNode finallyBlock = null;
        if (lastNode.id == 87) {
            finallyBlock = lastNode;
        }
        try {
            value = this.accept(node, 0, context);
        }
        catch (Escape esc) {
            throw esc;
        }
        catch (Runtime.Break brk) {
            throw brk;
        }
        catch (Runtime.Continue cont) {
            throw cont;
        }
        catch (Throwable t) {
            if (t instanceof PnutsException) {
                pe = (PnutsException)t;
                t = ((PnutsException)t).getThrowable();
            }
            for (int i = 1; i < n; ++i) {
                SimpleNode c = node.jjtGetChild(i);
                if (c.id != 83) continue;
                String var = c.str;
                StringBuffer sbuf = new StringBuffer();
                SimpleNode classNode = c.jjtGetChild(0);
                sbuf.append(classNode.jjtGetChild((int)0).str);
                for (int j = 1; j < classNode.jjtGetNumChildren(); ++j) {
                    sbuf.append('.');
                    sbuf.append(classNode.jjtGetChild((int)j).str);
                }
                Class cls = context.resolveClass(sbuf.toString());
                if (cls == null || !cls.isInstance(t)) continue;
                try {
                    context.openLocal(new String[0]);
                    context.bind(var, t);
                    Object object = this.accept(c, 1, context);
                    return object;
                }
                finally {
                    context.closeLocal();
                }
            }
            if (pe != null) {
                throw pe;
            }
            throw new PnutsException(t, context);
        }
        finally {
            if (finallyBlock != null) {
                this.accept(finallyBlock, 0, context);
            }
        }
        return value;
    }

    public Object catchBlock(SimpleNode node, Context context) {
        return null;
    }

    public Object blockNode(SimpleNode node, Context context) {
        Object last = null;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            last = this.accept(node, i, context);
        }
        return last;
    }

    public Object ifStatement(SimpleNode node, Context context) {
        Object con = this.accept(node, 0, context);
        if (PnutsInterpreter.condition(con, context)) {
            return this.accept(node, 1, context);
        }
        int n = node.jjtGetNumChildren();
        for (int i = 2; i < n; ++i) {
            SimpleNode _node = node.children[i];
            if (_node.id == 79) {
                if (!PnutsInterpreter.condition(this.accept(_node, 0, context), context)) continue;
                return this.accept(_node, 1, context);
            }
            if (_node.id != 80) continue;
            return this.accept(_node, 0, context);
        }
        return null;
    }

    static boolean condition(Object cond, Context context) {
        if (cond instanceof Boolean) {
            return (Boolean)cond;
        }
        return Runtime.toBoolean(cond);
    }

    public Object doStatement(SimpleNode node, Context context) {
        Object last = null;
        try {
            while (true) {
                try {
                    Object cond;
                    boolean b;
                    do {
                        last = this.accept(node, 0, context);
                        cond = this.accept(node, 1, context);
                        if (cond instanceof Boolean) continue;
                        cond = Runtime.toBoolean(cond);
                    } while (b = ((Boolean)cond).booleanValue());
                    return last;
                }
                catch (Runtime.Continue cont) {
                    continue;
                }
                break;
            }
        }
        catch (Runtime.Break brk) {
            return brk.getValue();
        }
    }

    /*
     * Loose catch block
     */
    public Object whileStatement(SimpleNode node, Context context) {
        Object last = null;
        block4: while (true) {
            while (true) {
                Object cond;
                if (!((cond = this.accept(node, 0, context)) instanceof Boolean)) {
                    cond = Runtime.toBoolean(cond);
                }
                try {
                    boolean b = (Boolean)cond;
                    if (b) {
                        last = this.accept(node, 1, context);
                        continue block4;
                    }
                    return last;
                }
                catch (Runtime.Continue cont) {
                    continue;
                }
                break;
            }
            break;
        }
        catch (Runtime.Break brk) {
            return brk.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object forStatement(SimpleNode node, Context context) {
        SimpleNode initNode = null;
        SimpleNode condNode = null;
        SimpleNode updateNode = null;
        SimpleNode blockNode = null;
        int j = 0;
        SimpleNode n = node.children[j];
        String var = n.str;
        if (n.id == 90) {
            int nc = n.jjtGetNumChildren();
            Object n0 = n.children[0].accept(this, context);
            blockNode = node.children[1];
            if (nc == 1) {
                return this.doForeach(n.str, n0, blockNode, context);
            }
            if (nc == 2) {
                Object n1 = n.children[1].accept(this, context);
                int start = ((Number)n0).intValue();
                int end = ((Number)n1).intValue();
                return this.doForeach(n.str, start, end, blockNode, context);
            }
            throw new IllegalArgumentException();
        }
        if (n.id == 91) {
            initNode = n;
            ++j;
        }
        n = node.children[j];
        if (n.id != 92 && n.id != 77) {
            condNode = n;
            ++j;
        }
        n = node.children[j];
        if (n.id == 92) {
            updateNode = n;
            ++j;
        }
        blockNode = node.children[j];
        Object last = null;
        if (initNode != null) {
            SimpleNode sn;
            int i;
            int num = initNode.jjtGetNumChildren();
            String[] env = new String[num];
            for (i = 0; i < env.length; ++i) {
                sn = initNode.children[i];
                env[i] = sn.str;
            }
            context.openLocal(env);
            for (i = 0; i < env.length; ++i) {
                sn = initNode.children[i];
                context.bind(env[i], this.accept(sn, 0, context));
            }
        } else {
            context.openLocal(new String[0]);
        }
        Object c = null;
        c = condNode != null ? condNode.accept(this, context) : Boolean.TRUE;
        try {
            while (true) {
                if (!(c instanceof Boolean)) {
                    c = Runtime.toBoolean(c);
                }
                if (!((Boolean)c).booleanValue()) {
                    break;
                }
                try {
                    last = blockNode.accept(this, context);
                }
                catch (Runtime.Continue cont) {
                    // empty catch block
                }
                if (updateNode != null) {
                    this.expressionList(updateNode, context);
                }
                if (condNode == null) continue;
                c = condNode.accept(this, context);
            }
        }
        catch (Runtime.Break brk) {
            last = brk.getValue();
        }
        finally {
            context.closeLocal();
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doForeach(String var, int start, int end, SimpleNode blockNode, Context context) {
        Object last = null;
        context.openLocal(new String[]{var});
        try {
            if (start < end) {
                for (int i = start; i <= end; ++i) {
                    try {
                        context.bind(var, new Integer(i));
                        last = blockNode.accept(this, context);
                        continue;
                    }
                    catch (Runtime.Continue cont) {
                        // empty catch block
                    }
                }
            } else {
                for (int i = start; i >= end; --i) {
                    try {
                        context.bind(var, new Integer(i));
                        last = blockNode.accept(this, context);
                        continue;
                    }
                    catch (Runtime.Continue cont) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Runtime.Break brk) {
            last = brk.getValue();
        }
        finally {
            context.closeLocal();
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doForeach(String var, Object array, SimpleNode blockNode, Context context) {
        if (array == null) {
            return null;
        }
        if (array instanceof Generator) {
            Function f = new Function(null, new String[]{var}, 1, blockNode, context.getCurrentPackage(), context){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object exec(Object[] args, Context context) {
                    boolean inGeneratorClosure = context.inGeneratorClosure;
                    try {
                        context.inGeneratorClosure = true;
                        Object object = super.exec(args, context);
                        return object;
                    }
                    finally {
                        context.inGeneratorClosure = inGeneratorClosure;
                    }
                }
            };
            return Runtime.applyGenerator((Generator)array, f.register(null), context);
        }
        Enumeration e = Runtime.toEnumeration(array, context);
        if (e == null) {
            throw new PnutsException("illegal.type.foreach", new Object[]{Pnuts.format(array)}, context);
        }
        Object last = null;
        context.openLocal(new String[]{var});
        try {
            while (e.hasMoreElements()) {
                try {
                    context.bind(var, e.nextElement());
                    last = blockNode.accept(this, context);
                }
                catch (Runtime.Continue cont) {}
            }
        }
        catch (Runtime.Break brk) {
            last = brk.getValue();
        }
        finally {
            context.closeLocal();
        }
        return last;
    }

    public Object foreachStatement(SimpleNode node, Context context) {
        SimpleNode n1 = node.children[0];
        SimpleNode n2 = node.children[1];
        String var = node.str;
        return this.doForeach(var, n1.accept(this, context), n2, context);
    }

    public Object switchStatement(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        Object target = this.accept(node, 0, context);
        Object last = null;
        boolean matched = false;
        try {
            for (int i = 1; i < n; ++i) {
                SimpleNode _node = node.children[i];
                if (_node.jjtGetNumChildren() == 1) {
                    Object o = this.accept(_node, 0, context);
                    ++i;
                    if (!matched && !Runtime.eq(target, o, context)) continue;
                    last = this.accept(node, i, context);
                    matched = true;
                    continue;
                }
                matched = true;
                last = this.accept(node, ++i, context);
            }
        }
        catch (Runtime.Break brk) {
            last = brk.getValue();
        }
        return last;
    }

    public Object switchBlock(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        Object last = null;
        for (int i = 0; i < n; ++i) {
            last = this.accept(node, i, context);
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object functionStatement(SimpleNode node, Context context) {
        param = node.jjtGetChild(0);
        nargs = param.jjtGetNumChildren();
        locals = new String[nargs];
        n0 = null;
        block = node.jjtGetChild(1);
        var8_8 = node;
        synchronized (var8_8) {
            if (node.getAttribute("type") == null) {
                if (Runtime.isGenerator(block)) {
                    node.setAttribute("type", PnutsInterpreter.GENERATOR);
                } else {
                    node.setAttribute("type", PnutsInterpreter.FUNCTION);
                }
            }
        }
        if (nargs != 1) ** GOTO lbl-1000
        n0 = param.children[0];
        if (n0.id == 15) {
            nargs = -1;
            locals[0] = n0.children[0].str;
        } else lbl-1000:
        // 3 sources

        {
            for (j = 0; j < nargs; ++j) {
                locals[j] = param.children[j].str;
            }
        }
        symbol = node.str;
        stackFrame = context.stackFrame;
        pkg = context.getCurrentPackage();
        f = node.getAttribute("type") == PnutsInterpreter.GENERATOR ? new Generator.GeneratorFunction(symbol, locals, nargs, block, pkg, context) : new Function(symbol, locals, nargs, block, pkg, context);
        ht = null;
        if (symbol != null) {
            if (stackFrame.parent != null) {
                o = null;
                b = (Binding)stackFrame.lookup(symbol);
                found = false;
                if (b != null) {
                    o = b.value;
                    ht = o instanceof PnutsFunction != false ? f.register((PnutsFunction)o) : Runtime.defineUnboundFunction(f, symbol, pkg);
                    found = true;
                } else {
                    ff = context.frame;
                    while (ff != null) {
                        ls = ff.lexicalScope;
                        if (ls != null && (bb = ls.lookup0(symbol)) != null) {
                            o = ((Binding)bb.value).value;
                            ht = o instanceof PnutsFunction != false ? f.register((PnutsFunction)o, true) : Runtime.defineUnboundFunction(f, symbol, pkg);
                            found = true;
                            break;
                        }
                        ff = ff.outer;
                    }
                }
                if (!found) {
                    ht = Runtime.defineUnboundFunction(f, symbol, pkg);
                }
                if (b != null) {
                    b.set(ht);
                } else {
                    stackFrame.assign(symbol, ht);
                }
            } else {
                ht = Runtime.defineTopLevelFunction(f, symbol, pkg, context);
            }
        } else {
            ht = f.register(null);
        }
        return ht;
    }

    public Object ternary(SimpleNode node, Context context) {
        if (PnutsInterpreter.condition(this.accept(node, 0, context), context)) {
            return this.accept(node, 1, context);
        }
        return this.accept(node, 2, context);
    }

    protected Object accept(SimpleNode node, int idx, Context context) {
        return node.children[idx].accept(this, context);
    }

    static Class resolveClassNameNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 1) {
            String sym = node.children[0].str;
            if (sym == Runtime.INT_SYMBOL) {
                return Integer.TYPE;
            }
            if (sym == Runtime.SHORT_SYMBOL) {
                return Short.TYPE;
            }
            if (sym == Runtime.CHAR_SYMBOL) {
                return Character.TYPE;
            }
            if (sym == Runtime.BYTE_SYMBOL) {
                return Byte.TYPE;
            }
            if (sym == Runtime.LONG_SYMBOL) {
                return Long.TYPE;
            }
            if (sym == Runtime.FLOAT_SYMBOL) {
                return Float.TYPE;
            }
            if (sym == Runtime.DOUBLE_SYMBOL) {
                return Double.TYPE;
            }
            if (sym == Runtime.BOOLEAN_SYMBOL) {
                return Boolean.TYPE;
            }
            if (sym == Runtime.VOID_SYMBOL) {
                return Void.TYPE;
            }
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(node.children[0].str);
        for (int i = 1; i < n; ++i) {
            sbuf.append('.');
            sbuf.append(node.children[i].str);
        }
        String name = sbuf.toString();
        Class cls = context.resolveClass(name);
        if (cls == null) {
            throw new PnutsException("class.notFound", new Object[]{name}, context);
        }
        return cls;
    }

    Class resolveType(SimpleNode typeNode, Context context) {
        Object type = null;
        if (typeNode.id == 14) {
            SimpleNode n;
            int count = 0;
            for (n = typeNode; n != null && n.id == 14; n = n.jjtGetChild(0)) {
                ++count;
            }
            if (n != null && n.id != 16) {
                throw new RuntimeException();
            }
            return Runtime.arrayType(PnutsInterpreter.resolveClassNameNode(n, context), count);
        }
        if (typeNode.id == 16) {
            return PnutsInterpreter.resolveClassNameNode(typeNode, context);
        }
        throw new PnutsException("class.expected", NO_PARAM, context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

