/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.util.logging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.util.logging.Level;
import net.didion.jwnl.util.logging.LogListener;
import net.didion.jwnl.util.logging.LogRecord;

public final class LogPublishingService {
    private static final LogPublishingService INSTANCE = new LogPublishingService();
    private List _logListeners = new ArrayList();

    public static LogPublishingService getInstance() {
        return INSTANCE;
    }

    private LogPublishingService() {
    }

    public void addLogListener(LogListener logListener) {
        this._logListeners.add(logListener);
    }

    public void removeLogListener(LogListener logListener) {
        this._logListeners.remove(logListener);
    }

    public void log(Level level, String string) {
        this.log(new LogRecord(level, JWNL.resolveMessage(string)));
    }

    public void log(Level level, String string, Object object) {
        this.log(new LogRecord(level, JWNL.resolveMessage(string, object)));
    }

    public void log(Level level, String string, Object[] objectArray) {
        this.log(new LogRecord(level, JWNL.resolveMessage(string, objectArray)));
    }

    public void log(Level level, String string, Throwable throwable) {
        this.log(new LogRecord(level, JWNL.resolveMessage(string), throwable));
    }

    public void log(Level level, String string, Object object, Throwable throwable) {
        this.log(new LogRecord(level, JWNL.resolveMessage(string, object), throwable));
    }

    public void log(Level level, String string, Object[] objectArray, Throwable throwable) {
        this.log(new LogRecord(level, JWNL.resolveMessage(string, objectArray), throwable));
    }

    private void log(LogRecord logRecord) {
        Iterator iterator = this._logListeners.iterator();
        while (iterator.hasNext()) {
            ((LogListener)iterator.next()).publish(logRecord);
        }
    }
}

