/*
 * Decompiled with CFR 0.152.
 */
package tratz.types;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChecksumMap<K>
implements Externalizable {
    public static final long serialVersionUID = 1L;
    public static final int DEFAULT_NOT_FOUND_VALUE = Integer.MIN_VALUE;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    public static final int DEFAULT_START_SIZE = 32;
    protected int mNotFoundValue = Integer.MIN_VALUE;
    protected Node[] mRows = new Node[32];
    protected HashFunction mHashFunction;
    protected HashFunction mChecksumFunction;
    protected int mNumEntries;
    protected int mGrowThreshold = 24;
    protected double mLoadFactor = 0.75;

    public ChecksumMap() {
        this(new PassthroughHashFunction(), new DefaultChecksumFunction());
    }

    public ChecksumMap(HashFunction hashFunction, HashFunction checksumFunction) {
        this.mHashFunction = hashFunction;
        this.mChecksumFunction = checksumFunction;
    }

    public int put(K key, int value) {
        int retValue = this.mNotFoundValue;
        int hash = this.mHashFunction.hash(key);
        int checksum = this.mChecksumFunction.hash(key);
        int row = hash & this.mRows.length - 1;
        Node node = this.mRows[row];
        while (node != null) {
            if (node.hash == hash && node.checksum == checksum) {
                int oldValue = node.val;
                node.val = value;
                retValue = oldValue;
                break;
            }
            node = node.next;
        }
        if (retValue == this.mNotFoundValue) {
            this.addToRow(hash, checksum, value, row);
        }
        return retValue;
    }

    public int put(int hash, int checksum, int value) {
        int retValue = this.mNotFoundValue;
        int row = hash & this.mRows.length - 1;
        Node node = this.mRows[row];
        while (node != null) {
            if (node.hash == hash && node.checksum == checksum) {
                int oldValue = node.val;
                node.val = value;
                retValue = oldValue;
                break;
            }
            node = node.next;
        }
        if (retValue == this.mNotFoundValue) {
            this.addToRow(hash, checksum, value, row);
        }
        return retValue;
    }

    public Map<TwoPartKey, Integer> getKeyToIndexMap() {
        HashMap<TwoPartKey, Integer> map = new HashMap<TwoPartKey, Integer>();
        for (Node node : this.mRows) {
            while (node != null) {
                map.put(new TwoPartKey(node.hash, node.checksum), node.val);
                node = node.next;
            }
        }
        return map;
    }

    private void addToRow(int hash, int checksum, int value, int row) {
        ++this.mNumEntries;
        Node currentNode = this.mRows[row];
        if (currentNode == null) {
            this.mRows[row] = new Node(hash, checksum, value, null);
        } else {
            while (currentNode.next != null) {
                currentNode = currentNode.next;
            }
            currentNode.next = new Node(hash, checksum, value, null);
        }
        if (this.mNumEntries >= this.mGrowThreshold) {
            this.doubleTableSize();
        }
    }

    public int remove(Object key) {
        Node prev;
        int hash = this.mHashFunction.hash(key);
        int checksum = this.mChecksumFunction.hash(key);
        int row = hash & this.mRows.length - 1;
        Node node = prev = this.mRows[row];
        while (node != null) {
            if (node.hash == hash && node.checksum == checksum) {
                if (prev == node) {
                    this.mRows[row] = node.next;
                } else {
                    prev.next = node.next;
                }
                --this.mNumEntries;
                break;
            }
            prev = node;
            node = node.next;
        }
        return node == null ? this.mNotFoundValue : node.val;
    }

    public int get(K key) {
        int retValue = this.mNotFoundValue;
        int hash = this.mHashFunction.hash(key);
        int checksum = this.mChecksumFunction.hash(key);
        Node node = this.mRows[hash & this.mRows.length - 1];
        while (node != null) {
            if (node.hash == hash && node.checksum == checksum) {
                retValue = node.val;
                break;
            }
            node = node.next;
        }
        return retValue;
    }

    public int get(int hash, int checksum) {
        int retValue = this.mNotFoundValue;
        Node node = this.mRows[hash & this.mRows.length - 1];
        while (node != null) {
            if (node.hash == hash && node.checksum == checksum) {
                retValue = node.val;
                break;
            }
            node = node.next;
        }
        return retValue;
    }

    public boolean containsKey(K key) {
        return this.get(key) != this.mNotFoundValue;
    }

    public int size() {
        return this.mNumEntries;
    }

    public int getTableSize() {
        return this.mRows.length;
    }

    private void doubleTableSize() {
        int newSize = this.mRows.length * 2;
        Node[] newTable = new Node[newSize];
        Node[] oldTable = this.mRows;
        int newSizeMinusOne = newSize - 1;
        for (Node node : oldTable) {
            while (node != null) {
                Node nextEntry = node.next;
                int row = node.hash & newSizeMinusOne;
                node.next = newTable[row];
                newTable[row] = node;
                node = nextEntry;
            }
        }
        this.mRows = newTable;
        this.mGrowThreshold = (int)((double)newSize * this.mLoadFactor);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.mNumEntries = oi.readInt();
        this.mRows = new Node[this.mNumEntries];
        HashFunction hashFunction = (HashFunction)oi.readObject();
        HashFunction checksumFunction = (HashFunction)oi.readObject();
        this.mHashFunction = hashFunction;
        this.mChecksumFunction = checksumFunction;
        this.mNotFoundValue = oi.readInt();
        this.mLoadFactor = oi.readDouble();
        this.mGrowThreshold = oi.readInt();
        this.mRows = (Node[])oi.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeInt(this.mNumEntries);
        oo.writeObject(this.mHashFunction);
        oo.writeObject(this.mChecksumFunction);
        oo.writeInt(this.mNotFoundValue);
        oo.writeDouble(this.mLoadFactor);
        oo.writeInt(this.mGrowThreshold);
        oo.writeObject(this.mRows);
    }

    public static class TwoPartKey {
        public int hash;
        public int checksum;

        public TwoPartKey(int hash, int checksum) {
            this.hash = hash;
            this.checksum = checksum;
        }

        public int hash() {
            return this.hash;
        }
    }

    public static class DefaultChecksumFunction
    implements HashFunction,
    Serializable {
        public static final long serialVersionUID = 1L;

        public int hash(Object key) {
            String s = (String)key;
            int h = 0;
            int len = s.length();
            for (int i = len - 1; i >= 0; --i) {
                h = 31 * h + s.charAt(i);
            }
            return h;
        }
    }

    public static class PassthroughHashFunction
    implements HashFunction,
    Serializable {
        public static final long serialVersionUID = 1L;

        public int hash(Object key) {
            return key.hashCode();
        }
    }

    public static interface HashFunction {
        public int hash(Object var1);
    }

    private static class Node
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public int checksum;
        public int val;
        public Node next;
        public int hash;

        public Node(int hash, int checksum, int value, Node next) {
            this.hash = hash;
            this.checksum = checksum;
            this.val = value;
            this.next = next;
        }
    }
}

