/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.Lex.Tokenizer;
import Jet.NE.Dictionary;
import Jet.NE.DictionaryTagger;
import Jet.NE.NamedEntityUtil;
import Jet.Tipster.Document;
import Jet.Util.Cdb;
import Jet.Util.CdbBuilder;
import Jet.Util.DoubleArrayTrie;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieDictionary
extends Dictionary {
    private DoubleArrayTrie trie = new DoubleArrayTrie();
    private Cdb cdb;
    private StringBuilder text;
    private int[] indexes;

    public TrieDictionary(File file, File file2) throws IOException {
        this.trie.load(file);
        this.cdb = new Cdb(file2);
    }

    public TrieDictionary(String string, String string2) throws IOException {
        this(new File(string), new File(string2));
    }

    @Override
    public void lookupStart(String[] stringArray) {
        this.text = new StringBuilder();
        this.indexes = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.indexes[i] = this.text.length();
            this.text.append(stringArray[i]);
            this.text.append(' ');
        }
    }

    @Override
    public Dictionary.Entry lookup(int n) {
        DoubleArrayTrie.Result result = this.trie.getLongestCommonPrefix(this.text, this.indexes[n]);
        if (result != null) {
            try {
                byte[] byArray;
                byte[] byArray2 = ((Object)this.text.subSequence(this.indexes[n], this.indexes[n] + result.getLength() - 1)).toString().getBytes("UTF-8");
                HashSet<String> hashSet = new HashSet<String>();
                this.cdb.findstart();
                while ((byArray = this.cdb.findNext(byArray2)) != null) {
                    hashSet.add(new String(byArray, "UTF-8"));
                }
                int n2 = 0;
                while (n + n2 < this.indexes.length && this.indexes[n + n2] - this.indexes[n] < result.getLength()) {
                    ++n2;
                }
                return new Dictionary.Entry(n2, hashSet);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return null;
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TrieDictionary.readText("sample.txt", "ISO-8859-1");
        TrieDictionary.testDict(string, "data/wsj.ned.da", "data/wsj.ned.cdb");
    }

    private static SortedMap<String, Set<String>> loadDict(String string, String string2) throws IOException {
        String string3;
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
        Pattern pattern = Pattern.compile("\\s+/\\s+");
        while ((string3 = bufferedReader.readLine()) != null) {
            String[] stringArray = pattern.split(string3, 2);
            String string4 = stringArray[0].replaceAll("\\\\/", "/").replaceAll("\\s+", " ").trim() + " ";
            String string5 = stringArray[1].trim();
            TreeSet<String> treeSet = (TreeSet<String>)treeMap.get(string4);
            if (treeSet == null) {
                treeSet = new TreeSet<String>();
                treeMap.put(string4, treeSet);
            }
            treeSet.add(string5);
        }
        return treeMap;
    }

    private static DoubleArrayTrie buildTrie(SortedMap<String, Set<String>> sortedMap) {
        char[][] cArrayArray = new char[sortedMap.size()][];
        int n = 0;
        for (String string : sortedMap.keySet()) {
            cArrayArray[n] = string.toCharArray();
            ++n;
        }
        DoubleArrayTrie doubleArrayTrie = new DoubleArrayTrie();
        doubleArrayTrie.build(cArrayArray, null);
        return doubleArrayTrie;
    }

    private static void buildCdb(SortedMap<String, Set<String>> sortedMap, String string) throws IOException {
        CdbBuilder cdbBuilder = new CdbBuilder(string, string + ".tmp");
        for (Map.Entry<String, Set<String>> entry : sortedMap.entrySet()) {
            byte[] byArray = entry.getKey().getBytes("UTF-8");
            for (String string2 : entry.getValue()) {
                byte[] byArray2 = string2.getBytes("UTF-8");
                cdbBuilder.add(byArray, byArray2);
            }
        }
        cdbBuilder.finish();
    }

    public static String readText(String string, String string2) throws IOException {
        String string3;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string3 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string3);
            stringBuilder.append("\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static void prepare(String string, String string2, String string3, String string4) throws IOException {
        SortedMap<String, Set<String>> sortedMap = TrieDictionary.loadDict(string, string2);
        DoubleArrayTrie doubleArrayTrie = TrieDictionary.buildTrie(sortedMap);
        doubleArrayTrie.save(string3);
        TrieDictionary.buildCdb(sortedMap, string4);
    }

    public static void testDict(String string, String string2, String string3) throws IOException {
        Document document = new Document(string);
        Tokenizer.tokenize(document, document.fullSpan());
        TrieDictionary trieDictionary = new TrieDictionary(string2, string3);
        DictionaryTagger dictionaryTagger = new DictionaryTagger();
        dictionaryTagger.setDictionary(trieDictionary);
        dictionaryTagger.annotate(document);
        NamedEntityUtil.packNamedEntity(document, null);
        System.out.println(document.writeSGML("ENAMEX"));
    }
}

