/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.NE.Dictionary;
import Jet.NE.DictionaryFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OnMemoryDictionary
extends Dictionary {
    private Map<List<String>, Set<String>> dict = new HashMap<List<String>, Set<String>>();
    private String[] tokens;
    private int maxWordCount = 0;

    public void load(File file) throws IOException, DictionaryFormatException {
        FileReader fileReader = new FileReader(file);
        this.load(fileReader);
    }

    public void load(Reader reader) throws IOException, DictionaryFormatException {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        String string = null;
        int n = 1;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("\\s+/\\s+", 2);
            if (stringArray.length != 2) {
                throw new DictionaryFormatException("format error at " + n);
            }
            String string2 = stringArray[0].replaceAll("\\\\/", "/");
            List<String> list = Arrays.asList(string2.split("\\s+"));
            String string3 = stringArray[1].intern();
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, list.get(i).intern());
            }
            Set<String> set = this.dict.get(list);
            if (set == null) {
                set = new HashSet<String>();
                set.add(string3);
                this.dict.put(list, set);
            } else {
                set.add(string3);
            }
            if (list.size() > this.maxWordCount) {
                this.maxWordCount = list.size();
            }
            ++n;
        }
    }

    public void lookupStart(String[] stringArray) {
        this.tokens = stringArray;
    }

    public Dictionary.Entry lookup(int n) {
        int n2;
        int n3 = Math.min(this.maxWordCount, this.tokens.length - n);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        Set<String> set = null;
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(this.tokens[n + n2]);
            Set<String> set2 = this.dict.get(arrayList);
            if (set2 == null) continue;
            set = set2;
            n4 = n2 + 1;
        }
        if (set != null) {
            for (n2 = arrayList.size() - 1; n2 >= n4; --n2) {
                arrayList.remove(n2);
            }
            return new Dictionary.Entry(arrayList.size(), set);
        }
        return null;
    }
}

