/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.NE.BioType;
import Jet.NE.NamedEntityAttribute;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ClassAnnotator {
    private Map<String, Collection<NamedEntityAttribute>> dictionary;

    public ClassAnnotator(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        IdentityHashMap<String, NamedEntityAttribute> identityHashMap = new IdentityHashMap<String, NamedEntityAttribute>();
        this.dictionary = new HashMap<String, Collection<NamedEntityAttribute>>();
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("\t");
            String string2 = stringArray[0];
            ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length - 1);
            for (int i = 1; i < stringArray.length; ++i) {
                String string3 = stringArray[i].intern();
                if (identityHashMap.containsKey(string3)) {
                    arrayList.add(identityHashMap.get(string3));
                    continue;
                }
                NamedEntityAttribute namedEntityAttribute = new NamedEntityAttribute(string3, BioType.N);
                arrayList.add(namedEntityAttribute);
                identityHashMap.put(string3, namedEntityAttribute);
            }
            this.dictionary.put(string2, arrayList);
        }
    }

    public ClassAnnotator(File file) throws IOException {
        this(new FileReader(file));
    }

    public void annotate(Document document, Span span) {
        Vector<Annotation> vector = document.annotationsOfType("NE_INTERNAL", span);
        for (Annotation annotation : vector) {
            String string = document.normalizedText(annotation);
            Collection<NamedEntityAttribute> collection = this.dictionary.get(string);
            if (collection == null) continue;
            Set set = (Set)annotation.get("categories");
            set.addAll(collection);
        }
    }
}

