/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import opennlp.model.ComparableEvent;
import opennlp.model.Event;
import opennlp.model.EventStream;
import opennlp.model.OnePassDataIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnePassRealValueDataIndexer
extends OnePassDataIndexer {
    float[][] values;

    public OnePassRealValueDataIndexer(EventStream eventStream, int n, boolean bl) throws IOException {
        super(eventStream, n, bl);
    }

    public OnePassRealValueDataIndexer(EventStream eventStream, int n) throws IOException {
        super(eventStream, n);
    }

    @Override
    public float[][] getValues() {
        return this.values;
    }

    @Override
    protected int sortAndMerge(List list, boolean bl) {
        int n = super.sortAndMerge(list, bl);
        this.values = new float[n][];
        int n2 = list.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ComparableEvent comparableEvent = (ComparableEvent)list.get(i);
            if (null == comparableEvent) continue;
            this.values[n3++] = comparableEvent.values;
        }
        return n;
    }

    @Override
    protected List index(LinkedList<Event> linkedList, Map<String, Integer> map) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = linkedList.size();
        int n2 = 0;
        ArrayList<ComparableEvent> arrayList = new ArrayList<ComparableEvent>(n);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            int n3;
            Event event = linkedList.removeFirst();
            String[] stringArray = event.getContext();
            String string = event.getOutcome();
            if (hashMap.containsKey(string)) {
                n3 = (Integer)hashMap.get(string);
            } else {
                n3 = n2++;
                hashMap.put(string, n3);
            }
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                if (!map.containsKey(string2)) continue;
                arrayList2.add(map.get(string2));
            }
            if (arrayList2.size() > 0) {
                int[] nArray = new int[arrayList2.size()];
                for (int j = 0; j < nArray.length; ++j) {
                    nArray[j] = (Integer)arrayList2.get(j);
                }
                ComparableEvent comparableEvent = new ComparableEvent(n3, nArray, event.getValues());
                arrayList.add(comparableEvent);
            } else {
                System.err.println("Dropped event " + event.getOutcome() + ":" + Arrays.asList(event.getContext()));
            }
            arrayList2.clear();
        }
        this.outcomeLabels = OnePassRealValueDataIndexer.toIndexedStringArray(hashMap);
        this.predLabels = OnePassRealValueDataIndexer.toIndexedStringArray(map);
        return arrayList;
    }
}

