/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.ml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tratz.parse.ml.ParseModel;
import tratz.parse.types.Arc;
import tratz.parse.types.Token;
import tratz.types.IntArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParseModel
implements ParseModel {
    public static final long serialVersionUID = 1L;
    protected List<String> mActions;
    protected Map<String, Map<String, List<String>>> mPosPosActs = new HashMap<String, Map<String, List<String>>>();
    protected Map<String, Integer> mActionToIndex;
    private List<String> EMPTY_LIST = new ArrayList<String>();

    @Override
    public List<String> getActions() {
        return this.mActions;
    }

    @Override
    public void incrementCount() {
        throw new UnsupportedOperationException("Not implemented for this model: " + this.getClass().getCanonicalName());
    }

    @Override
    public void update(String s, IntArrayList ilist, double change) {
        throw new UnsupportedOperationException("Not implemented for this model: " + this.getClass().getCanonicalName());
    }

    @Override
    public void updateFeature(int actionIndex, int feat, double change) {
        throw new UnsupportedOperationException("Not implemented for this model: " + this.getClass().getCanonicalName());
    }

    @Override
    public int getActionIndex(String action, boolean addIfNecessary) {
        Integer actionIndex = this.mActionToIndex.get(action);
        if (actionIndex == null && addIfNecessary) {
            actionIndex = this.mActionToIndex.size() + 1;
            this.mActionToIndex.put(action, actionIndex);
        }
        return actionIndex;
    }

    @Override
    public List<String> getActions(Token tc, Token tr, Arc[] goldTokenToHead) {
        List<String> actions;
        if (this.EMPTY_LIST == null) {
            this.EMPTY_LIST = new ArrayList<String>();
        }
        if (this.mPosPosActs != null) {
            Map<String, List<String>> acts = this.mPosPosActs.get(tc.getPos());
            if (acts == null) {
                acts = new HashMap<String, List<String>>();
                this.mPosPosActs.put(tc.getPos(), acts);
            }
            List<String> list = actions = tr != null ? acts.get(tr.getPos()) : this.EMPTY_LIST;
            if (actions == null) {
                actions = new ArrayList<String>();
                acts.put(tr.getPos(), actions);
                actions.add("SWAPRIGHT");
                actions.add("SWAPLEFT");
                actions.add("depr");
                actions.add("depl");
            }
            if (goldTokenToHead != null) {
                String depend;
                Arc rightHead;
                Arc leftHead = goldTokenToHead[tc.getIndex()];
                Arc arc = rightHead = tr == null ? null : goldTokenToHead[tr.getIndex()];
                if (leftHead != null && leftHead.getHead() == tr) {
                    String depend2 = leftHead.getDependency() + "l";
                    if (!actions.contains(depend2)) {
                        actions.add(depend2);
                    }
                } else if (rightHead != null && rightHead.getHead() == tc && !actions.contains(depend = rightHead.getDependency() + "r")) {
                    actions.add(depend);
                }
            }
        } else {
            System.err.println("Returning full action set");
            actions = this.mActions;
        }
        return actions;
    }
}

