/*
 * Decompiled with CFR 0.152.
 */
package Jet.Concepts;

import Jet.Concepts.Concept;
import Jet.Concepts.ConceptHierarchy;
import Jet.Concepts.ConcreteFileFilter;
import Jet.Concepts.Word;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ConceptHierarchyWindow
extends JFrame
implements ActionListener {
    public static ConceptHierarchy conceptHierarchy;
    private JScrollPane jScrollPane = new JScrollPane();
    private final JFileChooser fcOpen = new JFileChooser(".");
    private final JFileChooser fcSave = new JFileChooser(".");
    private final JFileChooser fcSaveAs = new JFileChooser(".");
    private File currentFile = null;
    private FindDialog[] findDialog = new FindDialog[2];
    boolean dirty = false;

    public ConceptHierarchyWindow(ConceptHierarchy conceptHierarchy, File file) {
        try {
            ConceptHierarchyWindow.conceptHierarchy = conceptHierarchy;
            this.currentFile = file;
            ConceptHierarchyWindow.conceptHierarchy.setOwner(this);
            ConceptHierarchyWindow.conceptHierarchy.getModel().addTreeModelListener(new TreeModelListener(){

                public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                    Object object = conceptHierarchy.getSelectionPath().getLastPathComponent();
                    if (object instanceof Concept) {
                        Concept concept = (Concept)object;
                        if (concept.getName().length() == 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(ConceptHierarchyWindow.this, "You must type a concept name.", "Error Renaming Concept", 0);
                                }
                            });
                            conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                        }
                        String string = (String)ConceptHierarchyWindow.conceptHierarchy.conceptsInv.get(object);
                        if (!concept.getName().equals(string) && conceptHierarchy.isDuplicateConcept(concept)) {
                            conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                        } else {
                            ConceptHierarchyWindow.conceptHierarchy.concepts.remove(string);
                            ConceptHierarchyWindow.conceptHierarchy.concepts.put(concept.getName(), concept);
                            ConceptHierarchyWindow.conceptHierarchy.conceptsInv.remove(object);
                            ConceptHierarchyWindow.conceptHierarchy.conceptsInv.put(concept, concept.getName());
                        }
                    } else {
                        Word word = (Word)object;
                        if (word.getName().length() == 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(ConceptHierarchyWindow.this, "You must type a word.", "Error Renaming Word", 0);
                                }
                            });
                            conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                        }
                        String string = (String)ConceptHierarchyWindow.conceptHierarchy.wordsInv.get(object);
                        if (!word.getName().equals(string) && conceptHierarchy.isDuplicateWord(word)) {
                            conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                        } else {
                            ConceptHierarchyWindow.conceptHierarchy.words.remove(string);
                            ConceptHierarchyWindow.conceptHierarchy.words.put(word.getName(), word);
                            ConceptHierarchyWindow.conceptHierarchy.wordsInv.remove(object);
                            ConceptHierarchyWindow.conceptHierarchy.wordsInv.put(word, word.getName());
                        }
                    }
                    ConceptHierarchyWindow.this.dirty = true;
                    ConceptHierarchyWindow.this.updateCaption();
                    conceptHierarchy.getClass();
                }

                public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                    ConceptHierarchyWindow.this.dirty = true;
                    ConceptHierarchyWindow.this.updateCaption();
                }

                public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                    ConceptHierarchyWindow.this.dirty = true;
                    ConceptHierarchyWindow.this.updateCaption();
                }

                public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                    ConceptHierarchyWindow.this.dirty = true;
                    ConceptHierarchyWindow.this.updateCaption();
                }
            });
            this.jbInit();
            ConcreteFileFilter concreteFileFilter = new ConcreteFileFilter("hrc", "Concept Hierarchy Files (*.hrc)");
            this.fcOpen.setFileFilter(concreteFileFilter);
            this.fcSave.setFileFilter(concreteFileFilter);
            this.fcSaveAs.setFileFilter(concreteFileFilter);
            this.findDialog[0] = new FindDialog(this, 0);
            this.findDialog[1] = new FindDialog(this, 1);
            this.findDialog[0].pack();
            this.findDialog[1].pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Open ...");
        jMenuItem.setMnemonic(79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Save");
        jMenuItem.setMnemonic(83);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Save As ...");
        jMenuItem.setMnemonic(65);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Clear");
        jMenuItem.setMnemonic(67);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic(88);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic(69);
        JMenu jMenu3 = new JMenu("New");
        jMenu3.setMnemonic(78);
        jMenu2.add(jMenu3);
        jMenuItem = new JMenuItem("Concept");
        jMenuItem.setMnemonic(67);
        jMenu3.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Word");
        jMenuItem.setMnemonic(87);
        jMenu3.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.setMnemonic(68);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Rename");
        jMenuItem.setMnemonic(82);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu2.addSeparator();
        JMenu jMenu4 = new JMenu("Find ...");
        jMenu4.setMnemonic(70);
        jMenu2.add(jMenu4);
        jMenuItem = new JMenuItem("Concept ");
        jMenuItem.setMnemonic(67);
        jMenu4.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Word ");
        jMenuItem.setMnemonic(87);
        jMenu4.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.fcOpen.setDialogTitle("Open");
        this.fcOpen.setApproveButtonText("Open");
        this.fcOpen.setApproveButtonMnemonic(79);
        this.fcOpen.setApproveButtonToolTipText("Open Hierarchy");
        this.fcSave.setDialogTitle("Save");
        this.fcSave.setApproveButtonText("Save");
        this.fcSave.setApproveButtonMnemonic(83);
        this.fcSave.setApproveButtonToolTipText("Save Hierarchy");
        this.fcSaveAs.setDialogTitle("Save As");
        this.fcSaveAs.setApproveButtonText("Save");
        this.fcSaveAs.setApproveButtonMnemonic(83);
        this.fcSaveAs.setApproveButtonToolTipText("Save Hierarchy");
        conceptHierarchy.getSelectionModel().setSelectionMode(1);
        this.jScrollPane.getViewport().add((Component)conceptHierarchy, null);
        this.updateCaption();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (ConceptHierarchyWindow.this.okToAbandon()) {
                    ConceptHierarchyWindow.this.dispose();
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.setSize(400, 600);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Open ...")) {
            int n;
            if (this.okToAbandon() && (n = this.fcOpen.showOpenDialog(this)) == 0) {
                this.currentFile = this.fcOpen.getSelectedFile();
                conceptHierarchy.readHierarchy(this.currentFile);
                this.dirty = false;
                this.updateCaption();
            }
        } else if (actionEvent.getActionCommand().equals("Save")) {
            if (!conceptHierarchy.isEditing()) {
                this.saveFile();
            }
        } else if (actionEvent.getActionCommand().equals("Save As ...")) {
            if (!conceptHierarchy.isEditing()) {
                int n;
                if (this.currentFile == null) {
                    File file = new File("Untitled Hierarchy.hrc");
                    this.fcSaveAs.setSelectedFile(file);
                }
                if ((n = this.fcSaveAs.showDialog(this, null)) == 0) {
                    this.currentFile = this.fcSaveAs.getSelectedFile();
                    conceptHierarchy.writeHierarchy(this.currentFile);
                    this.dirty = false;
                    this.updateCaption();
                }
            }
        } else if (actionEvent.getActionCommand().equals("Clear")) {
            conceptHierarchy.clear();
            this.dirty = true;
            this.updateCaption();
        } else if (actionEvent.getActionCommand().equals("Concept")) {
            if (!conceptHierarchy.isEditing()) {
                TreePath treePath = conceptHierarchy.getSelectionPath();
                if (treePath != null) {
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof Concept) {
                        conceptHierarchy.newConcept((Concept)object);
                    }
                } else {
                    conceptHierarchy.newConcept((Concept)conceptHierarchy.getModel().getRoot());
                }
                this.dirty = true;
                this.updateCaption();
            }
        } else if (actionEvent.getActionCommand().equals("Word")) {
            if (!conceptHierarchy.isEditing()) {
                TreePath treePath = conceptHierarchy.getSelectionPath();
                if (treePath != null) {
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof Concept) {
                        conceptHierarchy.newWord((Concept)object);
                    }
                } else {
                    conceptHierarchy.newWord((Concept)conceptHierarchy.getModel().getRoot());
                }
                this.dirty = true;
                this.updateCaption();
            }
        } else if (actionEvent.getActionCommand().equals("Delete")) {
            if (!conceptHierarchy.isEditing()) {
                TreePath treePath = conceptHierarchy.getSelectionPath();
                if (treePath != null) {
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof Concept) {
                        conceptHierarchy.removeConcept((Concept)object);
                    } else {
                        conceptHierarchy.removeWord((Word)object);
                    }
                }
                this.dirty = true;
                this.updateCaption();
            }
        } else if (actionEvent.getActionCommand().equals("Rename")) {
            if (!conceptHierarchy.isEditing()) {
                conceptHierarchy.startEditingAtPath(conceptHierarchy.getSelectionPath());
                this.dirty = true;
                this.updateCaption();
            }
        } else if (actionEvent.getActionCommand().equals("Concept ")) {
            if (!conceptHierarchy.isEditing()) {
                this.find(0);
            }
        } else if (actionEvent.getActionCommand().equals("Word ")) {
            if (!conceptHierarchy.isEditing()) {
                this.find(1);
            }
        } else if (this.okToAbandon()) {
            this.dispose();
        }
    }

    private void find(int n) {
        this.findDialog[n].setLocationRelativeTo(this);
        this.findDialog[n].setVisible(true);
        String string = this.findDialog[n].getQuery();
        boolean bl = this.findDialog[n].getCaseSensitivity();
        if (string == null) {
            return;
        }
        if (n == 0) {
            Concept concept = bl ? conceptHierarchy.getConceptByName(string) : conceptHierarchy.getConceptByNameIgnoreCase(string);
            if (concept != null) {
                TreePath treePath = new TreePath(concept.getPath());
                conceptHierarchy.setSelectionPath(treePath);
                conceptHierarchy.scrollPathToVisible(treePath);
            } else {
                JOptionPane.showMessageDialog(this.findDialog[0], "Concept '" + string + "' not found.", "Search Failed", 0);
            }
        } else {
            Word word = bl ? conceptHierarchy.getWordByName(string) : conceptHierarchy.getWordByNameIgnoreCase(string);
            if (word != null) {
                TreePath treePath = new TreePath(word.getPath());
                conceptHierarchy.setSelectionPath(treePath);
                conceptHierarchy.scrollPathToVisible(treePath);
            } else {
                JOptionPane.showMessageDialog(this.findDialog[1], "Word '" + string + "' not found.", "Search Failed", 0);
            }
        }
    }

    void updateCaption() {
        String string = this.currentFile == null ? "Untitled Hierarchy.hrc" : this.currentFile.getAbsolutePath();
        if (this.dirty) {
            string = string + "*";
        }
        string = "Concept Hierarchy - " + string;
        this.setTitle(string);
    }

    private boolean okToAbandon() {
        if (!this.dirty) {
            return true;
        }
        String string = this.currentFile != null ? this.currentFile.getName() : "Untitled Hierarchy.hrc";
        int n = JOptionPane.showConfirmDialog(this, "File modified: \"" + string + "\". Do you wish to save changes?", "Save Modified File?", 1);
        switch (n) {
            case 0: {
                this.saveFile();
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private void saveFile() {
        if (this.currentFile != null) {
            conceptHierarchy.writeHierarchy(this.currentFile);
            this.dirty = false;
            this.updateCaption();
        } else {
            File file = new File("Untitled Hierarchy.hrc");
            this.fcSave.setSelectedFile(file);
            int n = this.fcSave.showSaveDialog(this);
            if (n == 0) {
                this.currentFile = this.fcSave.getSelectedFile();
                conceptHierarchy.writeHierarchy(this.currentFile);
                this.dirty = false;
                this.updateCaption();
            }
        }
    }

    class FindDialog
    extends JDialog {
        private String query;
        private boolean caseSensitivity;
        private JOptionPane optionPane;
        private final int mode;

        public String getQuery() {
            return this.query;
        }

        public boolean getCaseSensitivity() {
            return this.caseSensitivity;
        }

        public FindDialog(Frame frame, int n) {
            super(frame, "Find", true);
            this.query = null;
            this.mode = n;
            String[] stringArray = new String[]{"Enter a concept name to find.", "Enter a word to find"};
            JRadioButton[] jRadioButtonArray = new JRadioButton[2];
            final ButtonGroup buttonGroup = new ButtonGroup();
            jRadioButtonArray[0] = new JRadioButton("Case Insensitive");
            jRadioButtonArray[0].setActionCommand("insensitive");
            jRadioButtonArray[1] = new JRadioButton("Case Sensitive");
            jRadioButtonArray[1].setActionCommand("sensitive");
            buttonGroup.add(jRadioButtonArray[0]);
            buttonGroup.add(jRadioButtonArray[1]);
            jRadioButtonArray[0].setSelected(true);
            final JTextField jTextField = new JTextField(10);
            Object[] objectArray = new Object[]{stringArray[this.mode], jRadioButtonArray[0], jRadioButtonArray[1], jTextField};
            Object[] objectArray2 = new Object[]{"Find", "Cancel"};
            this.optionPane = new JOptionPane(objectArray, 3, 0, null, objectArray2, objectArray2[0]);
            this.setContentPane(this.optionPane);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    FindDialog.this.optionPane.setValue(new Integer(-1));
                }
            });
            jTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FindDialog.this.optionPane.setValue("Find");
                }
            });
            this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if (FindDialog.this.isVisible() && propertyChangeEvent.getSource() == FindDialog.this.optionPane && (string.equals("value") || string.equals("inputValue"))) {
                        Object object = FindDialog.this.optionPane.getValue();
                        if (object == JOptionPane.UNINITIALIZED_VALUE) {
                            return;
                        }
                        FindDialog.this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        if (object.equals("Find")) {
                            FindDialog.this.query = jTextField.getText();
                            FindDialog.this.caseSensitivity = buttonGroup.getSelection().getActionCommand().equals("sensitive");
                            if (FindDialog.this.query != null && !FindDialog.this.query.equals("")) {
                                jTextField.selectAll();
                                FindDialog.this.setVisible(false);
                            } else {
                                FindDialog.this.query = null;
                                String string2 = FindDialog.this.mode == 0 ? "concept name" : "word";
                                JOptionPane.showMessageDialog(FindDialog.this, "Nothing entered.\nPlease enter a " + string2 + ".", "Try again", 0);
                            }
                        } else {
                            FindDialog.this.query = null;
                            FindDialog.this.setVisible(false);
                        }
                    }
                }
            });
        }
    }
}

