/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import pnuts.lang.Runtime;
import pnuts.lang.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    int errorLine = -1;
    int errorColumn = -1;
    String errorName;
    String errorWord = null;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.init();
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public int getErrorLine() {
        return this.errorLine;
    }

    public int getErrorColumn() {
        return this.errorColumn;
    }

    void init() {
        Token tok;
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize >= this.expectedTokenSequences[i].length) continue;
            maxSize = this.expectedTokenSequences[i].length;
        }
        StringBuffer retval = new StringBuffer("");
        Token tok2 = tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (tok.kind == 0) {
                retval.append(this.tokenImage[0]);
                break;
            }
            if (tok.kind == 6) {
                tok2 = tok = tok.next;
                retval = new StringBuffer("");
                continue;
            }
            if (i > 0) {
                retval.append(" ");
            }
            retval.append(this.add_escapes(tok.image));
            tok = tok.next;
        }
        if (tok2 == null) {
            tok2 = this.currentToken;
        }
        this.errorName = "parse.error";
        this.errorLine = tok2.beginLine;
        this.errorColumn = tok2.beginColumn;
        this.errorWord = retval.toString();
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        return Runtime.getMessage("pnuts.lang.pnuts", this.errorName, new Object[]{this.errorWord, new Integer(this.errorLine), new Integer(this.errorColumn)});
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block8: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block8;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block8;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block8;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block8;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block8;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block8;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block8;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

