/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.dictionary.Dictionary;

public class Pointer
implements Serializable {
    static final long serialVersionUID = -1275571290466732179L;
    private int _index;
    private PointerType _pointerType;
    private PointerTarget _source = null;
    private TargetIndex _targetIndex;
    private transient PointerTarget _target = null;
    private transient String _cachedToString = null;

    public Pointer(PointerTarget pointerTarget, int n, PointerType pointerType, POS pOS, long l, int n2) {
        this._source = pointerTarget;
        this._index = n;
        this._pointerType = pointerType;
        this._targetIndex = new TargetIndex(pOS, l, n2);
    }

    public boolean equals(Object object) {
        return object instanceof Pointer && ((Pointer)object).getSource().equals(this.getSource()) && ((Pointer)object).getSourceIndex() == this.getSourceIndex();
    }

    public int hashCode() {
        return this.getSource().hashCode() ^ this.getSourceIndex();
    }

    public String toString() {
        if (this._cachedToString == null) {
            String string = this._target == null ? this._targetIndex.toString() : this._target.toString();
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_012", new Object[]{new Integer(this.getSourceIndex()), this.getSource(), string});
        }
        return this._cachedToString;
    }

    public int getSourceIndex() {
        return this._index;
    }

    public PointerType getType() {
        return this._pointerType;
    }

    public boolean isLexical() {
        return this.getSource() instanceof Word;
    }

    public PointerTarget getSource() {
        return this._source;
    }

    public PointerTarget getTarget() throws JWNLException {
        if (this._target == null) {
            Dictionary dictionary = Dictionary.getInstance();
            Synset synset = dictionary.getSynsetAt(this._targetIndex._pos, this._targetIndex._offset);
            this._target = this._targetIndex._index == 0 ? synset : synset.getWord(this._targetIndex._index - 1);
        }
        return this._target;
    }

    public Synset getTargetSynset() throws JWNLException {
        PointerTarget pointerTarget = this.getTarget();
        if (pointerTarget instanceof Word) {
            return ((Word)pointerTarget).getSynset();
        }
        return (Synset)pointerTarget;
    }

    public long getTargetOffset() {
        return this._targetIndex._offset;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._pointerType = PointerType.getPointerTypeForKey(this._pointerType.getKey());
    }

    private static class TargetIndex
    implements Serializable {
        POS _pos;
        long _offset;
        int _index;
        private transient String _cachedToString = null;

        TargetIndex(POS pOS, long l, int n) {
            this._pos = pOS;
            this._offset = l;
            this._index = n;
        }

        public String toString() {
            if (this._cachedToString == null) {
                this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_013", new Object[]{this._pos, new Long(this._offset), new Integer(this._index)});
            }
            return this._cachedToString;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this._pos = POS.getPOSForKey(this._pos.getKey());
        }
    }
}

