/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.wfr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tratz.featgen.wfr.AbstractWordFindingRule;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetSiblingsCrossed
extends AbstractWordFindingRule {
    private static final long serialVersionUID = 1L;

    @Override
    public void init(Map<String, String> params) {
    }

    @Override
    public Set<Token> getProductions(List<Token> tokenList, Parse parse, int tokenIndex) {
        HashSet<String> siblingRelationSet = new HashSet<String>();
        Token childOfArc = tokenList.get(tokenIndex);
        Arc toHead = parse.getHeadArcs()[childOfArc.getIndex()];
        if (toHead != null && toHead.getHead() != null) {
            List children = parse.getDependentArcLists()[toHead.getHead().getIndex()];
            for (Arc childArc : children) {
                String dep = childArc.getDependency();
                if (dep.equals("prep")) {
                    dep = "prep_" + childArc.getChild().getText().toLowerCase();
                }
                siblingRelationSet.add(dep);
            }
        }
        ArrayList siblingTypeList = new ArrayList(siblingRelationSet);
        Collections.sort(siblingTypeList);
        int numSiblings = siblingTypeList.size();
        HashSet<Token> results = new HashSet<Token>();
        for (int i = 0; i < numSiblings; ++i) {
            String sibling1 = (String)siblingTypeList.get(i);
            for (int j = i + 1; j < numSiblings; ++j) {
                String sibling2 = (String)siblingTypeList.get(j);
                results.add(new Token(sibling1 + "*" + sibling2, -1));
            }
        }
        return results;
    }
}

