/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.impl;

import java.io.Serializable;
import tratz.runpipe.Annotation;
import tratz.runpipe.TextDocument;

public abstract class AnnotationImpl
implements Annotation,
Serializable {
    public static final long serialVersionUID = 1L;
    protected int mStart = -1;
    protected int mEnd = -1;
    protected TextDocument mDocument;

    public AnnotationImpl(TextDocument document) {
        this.mDocument = document;
    }

    public AnnotationImpl(TextDocument document, int start, int end) {
        this.mDocument = document;
        this.mStart = start;
        this.mEnd = end;
    }

    public TextDocument getDocument() {
        return this.mDocument;
    }

    public void setStart(int start) {
        this.mStart = start;
    }

    public void setEnd(int end) {
        this.mEnd = end;
    }

    public int getStart() {
        return this.mStart;
    }

    public int getEnd() {
        return this.mEnd;
    }

    public String getAnnotText() {
        return this.mDocument.getText().substring(this.mStart, this.mEnd);
    }

    public int compareTo(Annotation o) {
        Annotation annot = o;
        int startDiff = this.mStart - annot.getStart();
        if (startDiff != 0) {
            return startDiff;
        }
        int endDiff = annot.getEnd() - this.mEnd;
        if (endDiff != 0) {
            return endDiff;
        }
        return this.hashCode() - annot.hashCode();
    }
}

