/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import AceJet.EDTtype;
import Jet.Control;
import Jet.JetTest;
import Jet.Refres.CorefFilter;
import Jet.Refres.CorefScorer;
import Jet.Refres.DocumentScorer;
import Jet.Refres.EntityView;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.View;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PronounScorer
extends DocumentScorer {
    private static HashSet<String> pronounSet = new HashSet();
    private Document responseDoc;
    private Document keyDoc;
    private Vector responseMentions;
    private HashMap<Annotation, Annotation> responseToKeyMentionMap;
    private HashMap<Annotation, Annotation> responseAntecedent;
    private HashMap<Annotation, Annotation> keyAntecedent;
    public float accuracy;
    public float overallAccuracy;
    private int correct = 0;
    private int pronouns = 0;
    private int totalCorrect = 0;
    private int totalPronouns = 0;

    @Override
    public void score(Document document, Document document2) {
        this.responseDoc = document;
        this.keyDoc = document2;
        Vector<Annotation> vector = document.annotationsOfType("entity");
        if (vector == null) {
            System.err.println("CorefScorer.score:  no entity annotations in response");
            return;
        }
        Vector<Annotation> vector2 = document2.annotationsOfType("entity");
        if (vector2 == null) {
            System.err.println("CorefScorer.score:  no entity annotations in key");
            return;
        }
        this.alignMentions();
        this.responseAntecedent = this.buildAntecedentMap(document);
        this.keyAntecedent = this.buildAntecedentMap(document2);
        this.accuracy = this.scoreMentions(this.responseMentions);
        this.totalCorrect += this.correct;
        this.totalPronouns += this.pronouns;
        this.overallAccuracy = (float)this.totalCorrect / (float)this.totalPronouns;
    }

    private void alignMentions() {
        HashMap hashMap = CorefScorer.buildEndOfMentionMap(this.keyDoc);
        this.responseToKeyMentionMap = new HashMap();
        this.responseMentions = CorefScorer.findMentions(this.responseDoc);
        if (this.responseMentions != null) {
            for (int i = 0; i < this.responseMentions.size(); ++i) {
                Annotation annotation = (Annotation)this.responseMentions.elementAt(i);
                Annotation annotation2 = Resolve.getHeadC(annotation);
                int n = annotation2.span().end();
                Annotation annotation3 = (Annotation)hashMap.get(new Integer(n));
                if (annotation3 == null) continue;
                this.responseToKeyMentionMap.put(annotation2, annotation3);
            }
        }
    }

    private HashMap<Annotation, Annotation> buildAntecedentMap(Document document) {
        HashMap<Annotation, Annotation> hashMap = new HashMap<Annotation, Annotation>();
        Vector<Annotation> vector = document.annotationsOfType("entity");
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            Vector vector2 = (Vector)annotation.get("mentions");
            Annotation annotation2 = null;
            for (int j = 0; j < vector2.size(); ++j) {
                Annotation annotation3 = (Annotation)vector2.get(j);
                Annotation annotation4 = Resolve.getHeadC(annotation3);
                hashMap.put(annotation4, annotation2);
                annotation2 = annotation4;
            }
        }
        return hashMap;
    }

    private float scoreMentions(Vector vector) {
        this.correct = 0;
        this.pronouns = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Annotation annotation2 = Resolve.getHeadC(annotation);
            this.scoreMention(annotation2);
        }
        return (float)this.correct / (float)this.pronouns;
    }

    private void scoreMention(Annotation annotation) {
        String string = this.responseDoc.text(annotation).trim().toLowerCase();
        if (!pronounSet.contains(string)) {
            return;
        }
        Annotation annotation2 = this.responseToKeyMentionMap.get(annotation);
        if (annotation2 == null) {
            return;
        }
        ++this.pronouns;
        Annotation annotation3 = this.responseAntecedent.get(annotation);
        Annotation annotation4 = this.keyAntecedent.get(annotation2);
        if (annotation3 == null && annotation4 == null || this.responseToKeyMentionMap.get(annotation3) == annotation4) {
            ++this.correct;
        }
        while ((annotation4 = this.keyAntecedent.get(annotation4)) != null) {
            if (this.responseToKeyMentionMap.get(annotation3) != annotation4) continue;
            ++this.correct;
            return;
        }
    }

    @Override
    public void report() {
        System.out.println("Pronoun accuracy = " + this.accuracy);
        System.out.println("( " + this.correct + " correct pronoun antecedents " + "out of " + this.pronouns + " pronouns)");
    }

    @Override
    public void summary() {
        System.out.println("Overall pronoun accuracy = " + this.overallAccuracy);
        System.out.println("( " + this.totalCorrect + " correct pronoun antecedents " + "out of " + this.totalPronouns + " pronouns)");
    }

    public static void main(String[] stringArray) throws IOException {
        String string = System.getProperty("user.home") + "/";
        String string2 = string + "My Documents/jet/data/coref.txt";
        String[] stringArray2 = new String[]{"coref"};
        ExternalDocument externalDocument = new ExternalDocument("sgml", string2);
        externalDocument.setSGMLtags(stringArray2);
        externalDocument.open();
        CorefFilter.buildEntitiesFromLinkedMentions(externalDocument);
        new View(externalDocument, 0);
        new EntityView(externalDocument, 0);
        JetTest.initializeFromConfig("props/chunk3.properties");
        EDTtype.readTypeDict();
        String string3 = string + "My Documents\\Jet\\Data\\article.txt";
        Document document = JetTest.readDocument(new BufferedReader(new FileReader(string3)));
        Control.processDocument(document, null, true, 1);
        PronounScorer pronounScorer = new PronounScorer();
        pronounScorer.score(document, externalDocument);
        pronounScorer.report();
        pronounScorer.summary();
    }

    static {
        pronounSet.add("he");
        pronounSet.add("she");
        pronounSet.add("it");
        pronounSet.add("him");
        pronounSet.add("her");
        pronounSet.add("they");
        pronounSet.add("them");
        pronounSet.add("his");
        pronounSet.add("its");
        pronounSet.add("their");
        pronounSet.add("himself");
        pronounSet.add("herself");
        pronounSet.add("itself");
        pronounSet.add("themselves");
    }
}

