/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.NE.ClassAnnotator;
import Jet.NE.ClassHierarchyResolver;
import Jet.NE.Dictionary;
import Jet.NE.DictionaryTagger;
import Jet.NE.NamedEntityUtil;
import Jet.NE.RuleFormatException;
import Jet.NE.SimpleClassHierarchyResolver;
import Jet.NE.TransformRules;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameAnnotator {
    private static final String systemName = "ENE";
    private DictionaryTagger dictTagger = new DictionaryTagger();
    private TransformRules rules;
    private ClassAnnotator classAnnotator;
    private ClassHierarchyResolver hierarchyResolver;
    private Map<String, String> aliasTable;

    public void setDictionary(Dictionary dictionary) {
        this.dictTagger.setDictionary(dictionary);
    }

    public void loadClassDictionary(Reader reader) throws IOException {
        this.classAnnotator = new ClassAnnotator(reader);
    }

    public void loadClassDictionary(File file) throws IOException {
        this.classAnnotator = new ClassAnnotator(file);
    }

    public void loadRules(Reader reader) throws IOException, RuleFormatException {
        this.rules = TransformRules.load(reader);
        if (this.hierarchyResolver != null) {
            this.rules.setClassHierarchyResolver(this.hierarchyResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRules(File file) throws IOException, RuleFormatException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            this.loadRules(fileReader);
        }
        finally {
            if (fileReader != null) {
                try {
                    ((Reader)fileReader).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void annotate(Document document, Span span) {
        NamedEntityUtil.splitToNamedEntity(document, span);
        this.dictTagger.annotate(document, span);
        if (this.classAnnotator != null) {
            this.classAnnotator.annotate(document, span);
        }
        this.rules.apply(document, span);
        NamedEntityUtil.packNamedEntity(document, span, systemName);
        if (this.aliasTable != null) {
            Vector<Annotation> vector = document.annotationsOfType("ENAMEX", span);
            for (Annotation annotation : vector) {
                String string = (String)annotation.get("TYPE");
                String string2 = this.aliasTable.get(string);
                if (string2 != null) {
                    annotation.put("TYPE", string2);
                    continue;
                }
                document.removeAnnotation(annotation);
            }
        }
    }

    public void annotate(Document document) {
        this.annotate(document, document.fullSpan());
    }

    public void setAliasMap(Map<String, String> map) {
        this.aliasTable = map;
    }

    public void loadClassHierarchy(File file) throws IOException {
        this.hierarchyResolver = SimpleClassHierarchyResolver.getInstance(file);
        if (this.rules != null) {
            this.rules.setClassHierarchyResolver(this.hierarchyResolver);
        }
    }
}

