/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.HMM.BigramHMMemitter;
import Jet.HMM.HMM;
import Jet.HMM.HMMNameTagger;
import Jet.HMM.HMMstate;
import Jet.HMM.WordFeatureHMMemitter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;

class HMMAugmentor {
    static String originalHMMfile;
    static String newHMMfile;
    static String nameListFile;
    static HashMap<String, TreeSet<String>> stateUnigramTables;
    static HashMap<String, HashSet<String[]>> stateBigramTables;
    static HMMNameTagger tagger;
    static HMM hmm;

    HMMAugmentor() {
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        String string;
        if (stringArray.length < 3 || stringArray.length > 4) {
            System.err.println("HMMAugmentor requires 3 or 4 arguments:");
            System.err.println("    base-hmm augmented-hmm name-list [bigram-flag]");
            System.exit(1);
        }
        originalHMMfile = stringArray[0];
        newHMMfile = stringArray[1];
        nameListFile = stringArray[2];
        boolean bl = stringArray.length > 3;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(nameListFile));
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            String[] stringArray2 = string.split(" \\| ");
            if (stringArray2.length < 2) continue;
            String string2 = stringArray2[0];
            object = stringArray2[1];
            String[] stringArray3 = string2.split(" ");
            if (((String)object).equals("PERSON") || ((String)object).equals("LASTNAME")) {
                if (stringArray3.length == 1) {
                    HMMAugmentor.addTokenToState(stringArray3[0], "i-person");
                    continue;
                }
                HMMAugmentor.addTokenToState(stringArray3[0], "b-person");
                for (n = 1; n < stringArray3.length - 1; ++n) {
                    HMMAugmentor.addBigramToState(stringArray3[n - 1], stringArray3[n], "m-person");
                }
                HMMAugmentor.addBigramToState(stringArray3[stringArray3.length - 2], stringArray3[stringArray3.length - 1], "e-person");
                continue;
            }
            if (((String)object).equals("COMPANY") || ((String)object).equals("ORGANIZATION")) {
                if (stringArray3.length == 1) {
                    HMMAugmentor.addTokenToState(stringArray3[0], "i-organization");
                    continue;
                }
                HMMAugmentor.addTokenToState(stringArray3[0], "b-organization");
                for (n = 1; n < stringArray3.length - 1; ++n) {
                    HMMAugmentor.addBigramToState(stringArray3[n - 1], stringArray3[n], "m-organization");
                }
                HMMAugmentor.addBigramToState(stringArray3[stringArray3.length - 2], stringArray3[stringArray3.length - 1], "e-organization");
                continue;
            }
            if (((String)object).equals("GPE") || ((String)object).equals("CITY")) {
                if (stringArray3.length == 1) {
                    HMMAugmentor.addTokenToState(stringArray3[0], "i-gpe");
                    continue;
                }
                HMMAugmentor.addTokenToState(stringArray3[0], "b-gpe");
                for (n = 1; n < stringArray3.length - 1; ++n) {
                    HMMAugmentor.addBigramToState(stringArray3[n - 1], stringArray3[n], "m-gpe");
                }
                HMMAugmentor.addBigramToState(stringArray3[stringArray3.length - 2], stringArray3[stringArray3.length - 1], "e-gpe");
                continue;
            }
            System.out.println("Unexpected type:  " + (String)object);
        }
        tagger = new HMMNameTagger(bl ? BigramHMMemitter.class : WordFeatureHMMemitter.class);
        tagger.load(originalHMMfile);
        hmm = HMMAugmentor.tagger.nameHMM;
        for (String string2 : stateUnigramTables.keySet()) {
            object = stateUnigramTables.get(string2);
            System.out.println("For state " + string2 + " no of tokens = " + ((TreeSet)object).size());
            HMMAugmentor.addUnigramEmitters(string2, (TreeSet)object);
        }
        tagger.store(newHMMfile);
    }

    static void addTokenToState(String string, String string2) {
        HMMAugmentor.addBigramToState("", string, string2);
    }

    static void addBigramToState(String string, String string2, String string3) {
        TreeSet<String> treeSet = stateUnigramTables.get(string3);
        if (treeSet == null) {
            treeSet = new TreeSet();
            stateUnigramTables.put(string3, treeSet);
        }
        treeSet.add(string2);
        HashSet<Object> hashSet = stateBigramTables.get(string3);
        if (hashSet == null) {
            hashSet = new HashSet();
            stateBigramTables.put(string3, hashSet);
        }
        String[] stringArray = new String[]{string, string2};
        hashSet.add(stringArray);
    }

    static void addUnigramEmitters(String string, TreeSet treeSet) {
        HMMstate hMMstate = hmm.getState(string);
        if (hMMstate == null) {
            System.out.println("Undefined state " + string);
            return;
        }
        for (String string2 : treeSet) {
            hMMstate.incrementEmitCount(string2, "", 1);
        }
    }

    static void addBigramEmitters(String string, HashSet hashSet) {
        HMMstate hMMstate = hmm.getState(string);
        for (String[] stringArray : hashSet) {
            hMMstate.incrementEmitCount(stringArray[1], stringArray[0], 1);
        }
    }

    static {
        stateUnigramTables = new HashMap();
        stateBigramTables = new HashMap();
    }
}

