/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEvent;
import AceJet.AceEventAnchor;
import AceJet.AceEventArgument;
import AceJet.AceEventArgumentValue;
import AceJet.AceEventMention;
import AceJet.AceEventMentionArgument;
import AceJet.AceMention;
import AceJet.ChunkPath;
import AceJet.Datum;
import AceJet.EventPattern;
import AceJet.EventSyntacticPattern;
import AceJet.Gazetteer;
import AceJet.LearnRelations;
import Jet.Control;
import Jet.JetTest;
import Jet.MaxEntModel;
import Jet.Parser.SyntacticRelation;
import Jet.Parser.SyntacticRelationSet;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewEventTagger {
    MaxEntModel eventModel;
    MaxEntModel argModel;
    MaxEntModel roleModel;
    MaxEntModel corefModel;
    Set<String> anchorSet;
    String eventDirectory;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ace = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/";
    static String triplesDir = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/011306-fast-tuples/";
    static String triplesSuffix = ".sent.txt.ns-2005-fast-ace-n-tuple92";
    static boolean usePA = true;
    static boolean useParser = true;
    static boolean train = false;
    static double MIN_ARG_PROBABILITY = 0.35;
    static double COREF_THRESHOLD = 0.1;
    static double COREF_CONFIDENCE = 0.35;
    static final String fileListTrain1 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/nw-tail.txt";
    static final String fileListTrain2 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/bn-tail.txt";
    static final String fileListTrain3 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/bc-tail.txt";
    static final String fileListTrain4 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/wl-tail.txt";
    static final String fileListTrain5 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/cts-tail.txt";
    static final String fileListTrain6 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/un-tail.txt";
    static final String fileListTest = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/head6.txt";
    private AceEventMention eventMentionAtAnchor;
    private ArrayList<AceEvent> priorEvents;

    NewEventTagger(String string) {
        this.eventDirectory = string;
        this.eventModel = new MaxEntModel(string + "eventFeatureFile.log", string + "eventModel.log");
        this.argModel = new MaxEntModel(string + "argFeatureFile.log", string + "argModel.log");
        this.roleModel = new MaxEntModel(string + "roleFeatureFile.log", string + "roleModel.log");
        this.corefModel = new MaxEntModel(string + "corefFeatureFile.log", string + "corefModel.log");
    }

    public static void main(String[] stringArray) throws IOException {
        if (useParser) {
            JetTest.initializeFromConfig("props/ace use parses.properties");
        } else {
            JetTest.initializeFromConfig("props/ME ace 05.properties");
        }
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("data/loc.dict");
        Pat.trace = false;
        Resolve.trace = false;
        AceDocument.ace2005 = true;
        NewEventTagger newEventTagger = new NewEventTagger("eventTemp/");
        if (train) {
            String[] stringArray2 = new String[]{fileListTrain1, fileListTrain2, fileListTrain3, fileListTrain4, fileListTrain5, fileListTrain6};
            newEventTagger.train(stringArray2);
        } else {
            newEventTagger.loadModels();
            newEventTagger.tag(fileListTest);
        }
    }

    public void train(String[] stringArray) throws IOException {
        this.anchorSet = new HashSet<String>();
        for (int i = 1; i <= 2; ++i) {
            for (String string : stringArray) {
                this.trainOnFilelist(string, i);
            }
        }
        this.saveAnchorSet();
        this.eventModel.setCutoff(1);
        this.eventModel.buildModel();
        this.eventModel.saveModel();
        this.argModel.setCutoff(2);
        this.argModel.buildModel();
        this.argModel.saveModel();
        this.roleModel.setCutoff(2);
        this.roleModel.buildModel();
        this.roleModel.saveModel();
        this.corefModel.buildModel();
        this.corefModel.saveModel();
    }

    private void saveAnchorSet() throws IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(this.eventDirectory + "anchors.log"));
        for (String string : this.anchorSet) {
            printStream.println(string);
        }
        printStream.close();
    }

    public void trainOnFilelist(String string, int n) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n2 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing file " + ++n2 + ": " + string2 + " (pass " + n + ")");
            String string3 = ace + (useParser ? "perfect-parses/" : "") + string2;
            String string4 = ace + string2.replaceFirst(".sgm", ".apf.xml");
            ExternalDocument externalDocument = new ExternalDocument("sgml", string3);
            externalDocument.setAllTags(true);
            externalDocument.open();
            externalDocument.stretchAll();
            Resolve.ACE = true;
            Control.processDocument(externalDocument, null, false, 0);
            AceDocument aceDocument = new AceDocument(string3, string4);
            if (n == 1) {
                this.collectAnchorsFromDocument(externalDocument, aceDocument, string2.replaceFirst(".sgm", ""));
                continue;
            }
            this.trainOnDocument(externalDocument, aceDocument, string2.replaceFirst(".sgm", ""));
        }
        bufferedReader.close();
    }

    public void collectAnchorsFromDocument(Document document, AceDocument aceDocument, String string) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        if (usePA) {
            syntacticRelationSet.readRelations(triplesDir + string + triplesSuffix);
        } else {
            syntacticRelationSet.addRelations(document);
        }
        ArrayList<AceEvent> arrayList = aceDocument.events;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEvent aceEvent = arrayList.get(i);
            ArrayList<AceEventMention> arrayList2 = aceEvent.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventMention aceEventMention = arrayList2.get(j);
                Span span = aceEventMention.anchorJetExtent;
                String string2 = EventPattern.normalizedAnchor(span, aceEventMention.anchorText, document, syntacticRelationSet);
                this.anchorSet.add(string2);
            }
        }
    }

    public void trainOnDocument(Document document, AceDocument aceDocument, String string) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        if (usePA) {
            syntacticRelationSet.readRelations(triplesDir + string + triplesSuffix);
        } else {
            syntacticRelationSet.addRelations(document);
        }
        this.trainCorefNewDocument();
        ArrayList<AceEvent> arrayList = aceDocument.events;
        Vector<Annotation> vector = document.annotationsOfType("constit");
        for (int i = 0; i < vector.size(); ++i) {
            String string2;
            Annotation annotation = vector.get(i);
            if (!NewEventTagger.anchorConstit(annotation) || !this.anchorSet.contains(string2 = EventPattern.normalizedAnchor(annotation, document, syntacticRelationSet))) continue;
            Span span = annotation.span();
            String string3 = document.text(span);
            Datum datum = this.eventFeatures(span, string2, string3, document, aceDocument, syntacticRelationSet);
            AceEvent aceEvent = this.findEventAt(span, arrayList);
            boolean bl = aceEvent != null;
            datum.setOutcome(bl ? aceEvent.type + ":" + aceEvent.subtype : "noEvent");
            this.eventModel.addEvent(datum);
            if (!bl) continue;
            this.trainArgClassifier(aceEvent, this.eventMentionAtAnchor, document, aceDocument, syntacticRelationSet);
            this.trainCoref(this.eventMentionAtAnchor, string2, aceEvent.id, aceEvent.type, aceEvent.subtype);
        }
    }

    private static boolean anchorConstit(Annotation annotation) {
        String string = (String)annotation.get("cat");
        return string == "n" || string == "v" || string == "tv" || string == "ven" || string == "ving" || string == "adj";
    }

    private AceEvent findEventAt(Span span, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEvent aceEvent = (AceEvent)arrayList.get(i);
            ArrayList<AceEventMention> arrayList2 = aceEvent.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventMention aceEventMention = arrayList2.get(j);
                Span span2 = aceEventMention.anchorJetExtent;
                if (!span.within(span2)) continue;
                this.eventMentionAtAnchor = aceEventMention;
                return aceEvent;
            }
        }
        return null;
    }

    private Datum eventFeatures(Span span, String string, String string2, Document document, AceDocument aceDocument, SyntacticRelationSet syntacticRelationSet) {
        Object object;
        Datum datum = new Datum();
        datum.addFV("anchor", string);
        int n = span.start();
        SyntacticRelation syntacticRelation = syntacticRelationSet.getRelation(n, "PRT");
        if (syntacticRelation != null) {
            object = syntacticRelation.targetWord;
            datum.addFV("anchorWithParticle", string + "_" + (String)object);
        }
        if ((object = this.findContainingSentence(document, span)) == null) {
            return datum;
        }
        for (AceMention aceMention : this.mentionsInSpan(aceDocument, ((Annotation)object).span())) {
            String string3 = EventSyntacticPattern.buildSyntacticPath(n, aceMention.getJetHead().start(), syntacticRelationSet);
            if (string3 == null || string3.indexOf(58) >= 0) continue;
            datum.addFV("arg", string + ":" + string3 + ":" + aceMention.getType());
        }
        return datum;
    }

    private void trainArgClassifier(AceEvent aceEvent, AceEventMention aceEventMention, Document document, AceDocument aceDocument, SyntacticRelationSet syntacticRelationSet) {
        Span span = aceEventMention.anchorJetExtent;
        String string = aceEventMention.anchorText;
        String string2 = EventPattern.normalizedAnchor(span, string, document, syntacticRelationSet);
        AceEventAnchor aceEventAnchor = new AceEventAnchor(span, span, string, document);
        Annotation annotation = this.findContainingSentence(document, span);
        if (annotation == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (AceMention aceMention : this.closestMentionsFirst(this.mentionsInSpan(aceDocument, annotation.span()), span.start())) {
            ArrayList<AceEventMentionArgument> arrayList = aceEventMention.arguments;
            String string3 = "noArg";
            for (int i = 0; i < arrayList.size(); ++i) {
                AceEventMentionArgument aceEventMentionArgument = arrayList.get(i);
                if (!aceEventMentionArgument.value.equals(aceMention)) continue;
                string3 = aceEventMentionArgument.role;
                break;
            }
            Datum datum = this.argumentFeatures(document, string2, aceEvent, aceMention, aceEventAnchor, hashSet, syntacticRelationSet);
            if (string3 == "noArg") {
                datum.setOutcome("noArg");
                this.argModel.addEvent(datum);
                continue;
            }
            datum.setOutcome("arg");
            this.argModel.addEvent(datum);
            datum.setOutcome(string3);
            this.roleModel.addEvent(datum);
            hashSet.add(string3);
        }
    }

    private ArrayList<AceMention> mentionsInSpan(AceDocument aceDocument, Span span) {
        ArrayList<AceMention> arrayList = new ArrayList<AceMention>();
        for (AceMention aceMention : aceDocument.getAllMentions()) {
            if (!aceMention.jetExtent.within(span)) continue;
            arrayList.add(aceMention);
        }
        return arrayList;
    }

    private ArrayList<AceMention> closestMentionsFirst(ArrayList<AceMention> arrayList, int n) {
        ArrayList<AceMention> arrayList2 = new ArrayList<AceMention>(arrayList);
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                int n2;
                int n3 = Math.abs(arrayList.get(i).getJetHead().start() - n);
                if (n3 <= (n2 = Math.abs(arrayList.get(j).getJetHead().start() - n))) continue;
                AceMention aceMention = arrayList.get(i);
                arrayList.set(i, arrayList.get(j));
                arrayList.set(j, aceMention);
            }
        }
        return arrayList;
    }

    private Datum argumentFeatures(Document document, String string, AceEvent aceEvent, AceMention aceMention, AceEventAnchor aceEventAnchor, Set<String> set, SyntacticRelationSet syntacticRelationSet) {
        ChunkPath chunkPath;
        String string2;
        if (aceEventAnchor.getJetHead().start() < aceMention.getJetHead().start()) {
            string2 = "follow";
            chunkPath = new ChunkPath(document, aceEventAnchor, aceMention);
        } else {
            string2 = "precede";
            chunkPath = new ChunkPath(document, aceMention, aceEventAnchor);
        }
        if (aceEventAnchor.passive) {
            string2 = string2 + "/passive";
        }
        String string3 = EventSyntacticPattern.buildSyntacticPath(aceEventAnchor.getJetHead().start(), aceMention.getJetHead().start(), syntacticRelationSet);
        Datum datum = new Datum();
        datum.addFV("anchor", string);
        datum.addFV("evType", aceEvent.type);
        datum.addFV("menType", aceMention.getType());
        String string4 = Resolve.normalizeName(aceMention.getHeadText()).replace(' ', '_');
        datum.addFV("arg", string4);
        datum.addFV("evTypeArg", aceEvent.subtype + ":" + string4);
        int n = aceMention.jetExtent.start();
        Annotation annotation = document.tokenEndingAt(n);
        if (annotation != null) {
            datum.addFV("prevToken", document.text(annotation).trim());
            datum.addFV("prevTokenAndType", aceEvent.type + "_" + document.text(annotation).trim());
        }
        if (chunkPath == null || chunkPath.toString() == null) {
            datum.addFV("noChunkPath", null);
        } else {
            String string5 = chunkPath.toString().replace(' ', '_');
            datum.addFV("chunkPath", string2 + "_" + (String)string5);
            datum.addFV("chunkPathAndType", aceEvent.type + "_" + string2 + "_" + (String)string5);
            datum.addFV("dist", Integer.toString(chunkPath.size()));
        }
        if (string3 == null) {
            datum.addF("noSynPath");
        } else {
            datum.addFV("synPath", string3);
            datum.addFV("synPathEvType", aceEvent.type + "_" + string3);
            datum.addFV("synPathTypes", aceEvent.type + "_" + aceMention.getType() + "_" + string3);
        }
        for (String string6 : set) {
            datum.addFV("filled", string6);
        }
        return datum;
    }

    private Annotation findContainingSentence(Document document, Span span) {
        Vector<Annotation> vector = document.annotationsOfType("sentence");
        if (vector == null) {
            System.err.println("findContainingSentence:  no sentences found");
            return null;
        }
        Annotation annotation = null;
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation2 = vector.get(i);
            if (!span.within(annotation2.span())) continue;
            annotation = annotation2;
            break;
        }
        if (annotation == null) {
            System.err.println("findContainingSentence:  can't find sentence with span");
            return null;
        }
        return annotation;
    }

    public void loadModels() {
        this.eventModel.loadModel();
        this.argModel.loadModel();
        this.roleModel.loadModel();
        this.corefModel.loadModel();
        this.loadAnchorSet();
    }

    public void loadAnchorSet() {
        try {
            String string;
            this.anchorSet = new HashSet<String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.eventDirectory + "anchors.log"));
            while ((string = bufferedReader.readLine()) != null) {
                this.anchorSet.add(string);
            }
        }
        catch (IOException iOException) {
            System.err.println("***** EventTagger:  cannot read anchors.log");
            System.err.println(iOException);
        }
    }

    public void tag(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        boolean bl = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing file " + string2);
            String string3 = ace + (useParser ? "perfect-parses/" : "") + string2;
            String string4 = ace + string2.replaceFirst(".sgm", ".apf.xml");
            String string5 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/output/" + string2.replaceFirst(".sgm", ".apf");
            ExternalDocument externalDocument = new ExternalDocument("sgml", string3);
            externalDocument.setAllTags(true);
            externalDocument.open();
            externalDocument.stretchAll();
            Control.processDocument(externalDocument, null, false, 0);
            AceDocument aceDocument = new AceDocument(string3, string4);
            aceDocument.events.clear();
            this.tag(externalDocument, aceDocument, string2.replaceFirst(".sgm", ""), aceDocument.docID);
            aceDocument.write(new PrintWriter(new FileWriter(string5)), externalDocument);
        }
    }

    public void tag(Document document, AceDocument aceDocument, String string, String string2) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        if (usePA) {
            syntacticRelationSet.readRelations(triplesDir + string + triplesSuffix);
        } else {
            syntacticRelationSet.addRelations(document);
        }
        LearnRelations.findEntityMentions(aceDocument);
        LearnRelations.findConjuncts(document);
        int n = 1;
        Vector<Annotation> vector = document.annotationsOfType("constit");
        HashSet<Span> hashSet = new HashSet<Span>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                AceEvent aceEvent;
                Span span;
                Annotation annotation = vector.get(i);
                if (!NewEventTagger.anchorConstit(annotation) || hashSet.contains(span = annotation.span()) || (aceEvent = this.eventAnchoredByConstituent(annotation, document, aceDocument, string2, syntacticRelationSet, n)) == null) continue;
                aceDocument.addEvent(aceEvent);
                ++n;
                hashSet.add(span);
            }
        }
        this.eventCoref(aceDocument, document, syntacticRelationSet);
    }

    AceEvent eventAnchoredByConstituent(Annotation annotation, Document document, AceDocument aceDocument, String string, SyntacticRelationSet syntacticRelationSet, int n) {
        String string2;
        String string3 = EventPattern.normalizedAnchor(annotation, document, syntacticRelationSet);
        if (!this.anchorSet.contains(string3)) {
            return null;
        }
        Span span = annotation.span();
        Datum datum = this.eventFeatures(span, string3, string2 = document.text(span), document, aceDocument, syntacticRelationSet);
        String string4 = this.eventModel.bestOutcome(datum);
        if (string4 == "noEvent") {
            return null;
        }
        System.out.println("Generating " + string4 + " event for " + string3);
        String[] stringArray = string4.split(":");
        if (stringArray.length != 2) {
            System.err.println("*** EventTagger: Invalid event type:subtype " + string4);
            return null;
        }
        String string5 = string + "-EV" + n;
        AceEventMention aceEventMention = new AceEventMention(string5 + "-1", span, span, document.text());
        AceEvent aceEvent = new AceEvent(string5, stringArray[0], stringArray[1]);
        aceEvent.addMention(aceEventMention);
        this.collectArguments(aceEvent, aceEventMention, document, aceDocument, syntacticRelationSet);
        return aceEvent;
    }

    private void collectArguments(AceEvent aceEvent, AceEventMention aceEventMention, Document document, AceDocument aceDocument, SyntacticRelationSet syntacticRelationSet) {
        Span span = aceEventMention.anchorJetExtent;
        String string = aceEventMention.anchorText;
        String string2 = EventPattern.normalizedAnchor(span, string, document, syntacticRelationSet);
        AceEventAnchor aceEventAnchor = new AceEventAnchor(span, aceEventMention.anchorJetExtent, string, document);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<AceEventArgumentValue> hashSet2 = new HashSet<AceEventArgumentValue>();
        Annotation annotation = this.findContainingSentence(document, span);
        if (annotation == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (AceMention aceMention : this.closestMentionsFirst(this.mentionsInSpan(aceDocument, annotation.span()), span.start())) {
            AceEventArgumentValue aceEventArgumentValue;
            if (aceMention.getJetHead().within(span)) continue;
            Datum datum = this.argumentFeatures(document, string2, aceEvent, aceMention, aceEventAnchor, hashSet, syntacticRelationSet);
            double d = this.argModel.prob(datum, "arg");
            String string3 = this.roleModel.bestOutcome(datum).intern();
            if (!AceEventArgument.isValid(aceEvent.subtype, string3, aceMention) || !(d > MIN_ARG_PROBABILITY) || hashSet2.contains(aceEventArgumentValue = aceMention.getParent())) continue;
            AceEventMentionArgument aceEventMentionArgument = new AceEventMentionArgument(aceMention, string3);
            aceEventMentionArgument.confidence = d;
            aceEventMention.arguments.add(aceEventMentionArgument);
            AceEventArgument aceEventArgument = new AceEventArgument(aceEventArgumentValue, string3);
            aceEventArgument.confidence = d;
            aceEvent.arguments.add(aceEventArgument);
            hashSet2.add(aceEventArgumentValue);
            hashSet.add(string3);
        }
    }

    private void trainCorefNewDocument() {
        this.priorEvents = new ArrayList();
    }

    private void trainCoref(AceEventMention aceEventMention, String string, String string2, String string3, String string4) {
        AceEvent aceEvent = this.buildEventFromMention(aceEventMention, string2, string3, string4);
        boolean bl = true;
        for (AceEvent aceEvent2 : this.priorEvents) {
            Datum datum = this.corefFeatures(aceEvent2, aceEvent, string);
            if (aceEvent2.id.equals(aceEvent.id)) {
                aceEvent2.arguments = this.mergeArguments(aceEvent.arguments, aceEvent2.arguments);
                aceEvent2.addMention(aceEventMention);
                datum.setOutcome("merge");
                bl = false;
            } else {
                datum.setOutcome("noMerge");
            }
            this.corefModel.addEvent(datum);
        }
        if (bl) {
            this.priorEvents.add(aceEvent);
        }
    }

    private AceEvent buildEventFromMention(AceEventMention aceEventMention, String string, String string2, String string3) {
        AceEvent aceEvent = new AceEvent(string, string2, string3);
        aceEvent.addMention(aceEventMention);
        for (AceEventMentionArgument aceEventMentionArgument : aceEventMention.arguments) {
            String string4 = aceEventMentionArgument.role;
            AceMention aceMention = aceEventMentionArgument.value;
            AceEventArgumentValue aceEventArgumentValue = aceMention.getParent();
            AceEventArgument aceEventArgument = new AceEventArgument(aceEventArgumentValue, string4);
            aceEventArgument.confidence = aceEventMentionArgument.confidence;
            aceEvent.arguments.add(aceEventArgument);
        }
        return aceEvent;
    }

    private Datum corefFeatures(AceEvent aceEvent, AceEvent aceEvent2, String string) {
        Datum datum = new Datum();
        datum.addFV("subtype", aceEvent2.subtype);
        datum.addFV("anchor", string);
        if (string.endsWith("/n")) {
            datum.addF("nomAnchor");
        }
        AceEventMention aceEventMention = aceEvent.mentions.get(aceEvent.mentions.size() - 1);
        int n = aceEventMention.anchorExtent.start();
        AceEventMention aceEventMention2 = aceEvent2.mentions.get(aceEvent2.mentions.size() - 1);
        int n2 = aceEventMention2.anchorExtent.start();
        int n3 = n2 - n;
        datum.addFV("distance", Integer.toString(Math.min(n3 / 100, 9)));
        if (aceEventMention2.anchorText.equals(aceEventMention.anchorText)) {
            datum.addF("anchorMatch");
        }
        ArrayList<AceEventArgument> arrayList = aceEvent.arguments;
        ArrayList<AceEventArgument> arrayList2 = aceEvent2.arguments;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventArgument aceEventArgument = arrayList.get(i);
            if (aceEventArgument.confidence < COREF_CONFIDENCE) continue;
            String string2 = aceEventArgument.role;
            String string3 = aceEventArgument.value.id;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventArgument aceEventArgument2 = arrayList2.get(j);
                if (aceEventArgument2.confidence < COREF_CONFIDENCE) continue;
                String string4 = aceEventArgument2.role;
                String string5 = aceEventArgument2.value.id;
                if (!string2.equals(string4)) continue;
                if (string3.equals(string5)) {
                    datum.addFV("overlap", string2);
                    continue;
                }
                datum.addFV("conflict", string2);
            }
        }
        return datum;
    }

    public void eventCoref(AceDocument aceDocument, Document document, SyntacticRelationSet syntacticRelationSet) {
        ArrayList<AceEvent> arrayList = aceDocument.events;
        System.out.println("eventCoref: " + arrayList.size() + " event mentions");
        ArrayList<AceEvent> arrayList2 = new ArrayList<AceEvent>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            AceEvent aceEvent = arrayList.get(i);
            int n = -1;
            double d = 0.0;
            for (int j = arrayList2.size() - 1; j >= 0; --j) {
                object = (AceEvent)arrayList2.get(j);
                if (!aceEvent.type.equals(((AceEvent)object).type) || !aceEvent.subtype.equals(((AceEvent)object).subtype)) continue;
                AceEventMention aceEventMention = aceEvent.mentions.get(0);
                String string = EventPattern.normalizedAnchor(aceEventMention.anchorExtent, aceEventMention.anchorText, document, syntacticRelationSet);
                Datum datum = this.corefFeatures((AceEvent)object, aceEvent, string);
                double d2 = this.corefModel.prob(datum, "merge");
                if (!(d2 > COREF_THRESHOLD) || !(d2 > d)) continue;
                n = j;
                d = d2;
            }
            if (n >= 0) {
                AceEvent aceEvent2 = (AceEvent)arrayList2.get(n);
                aceEvent2.arguments = this.mergeArguments(aceEvent.arguments, aceEvent2.arguments);
                object = aceEvent.mentions.get(0);
                aceEvent2.addMention((AceEventMention)object);
                ((AceEventMention)object).setId(aceEvent2.id + "-" + aceEvent2.mentions.size());
                continue;
            }
            arrayList2.add(aceEvent);
        }
        aceDocument.events = arrayList2;
        System.out.println("eventCoref: " + arrayList2.size() + " events");
    }

    private ArrayList<AceEventArgument> mergeArguments(ArrayList<AceEventArgument> arrayList, ArrayList<AceEventArgument> arrayList2) {
        ArrayList<AceEventArgument> arrayList3 = new ArrayList<AceEventArgument>(arrayList);
        block0: for (AceEventArgument aceEventArgument : arrayList2) {
            String string = aceEventArgument.role;
            String string2 = aceEventArgument.value.id;
            for (AceEventArgument aceEventArgument2 : arrayList) {
                String string3 = aceEventArgument2.role;
                String string4 = aceEventArgument2.value.id;
                if (!string3.equals(string) || !string4.equals(string2)) continue;
                continue block0;
            }
            arrayList3.add(aceEventArgument);
        }
        return arrayList3;
    }
}

