/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.util.Iterator;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.IndexWordSet;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.util.factory.Installable;
import net.didion.jwnl.util.logging.Level;
import net.didion.jwnl.util.logging.LogPublishingService;

public abstract class Dictionary
implements Installable {
    private static Dictionary _dictionary = null;
    private MorphologicalProcessor _morph = null;

    public static Dictionary getInstance() {
        if (_dictionary == null) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_017");
        }
        return _dictionary;
    }

    protected static void setDictionary(Dictionary dictionary) {
        LogPublishingService.getInstance().log(Level.INFO, "DICTIONARY_INFO_002", dictionary);
        _dictionary = dictionary;
    }

    public static void uninstall() {
        if (_dictionary != null) {
            _dictionary.close();
            _dictionary = null;
        }
    }

    protected Dictionary() {
    }

    protected Dictionary(MorphologicalProcessor morphologicalProcessor) {
        this._morph = morphologicalProcessor;
    }

    public abstract Iterator getIndexWordIterator(POS var1) throws JWNLException;

    public abstract Iterator getIndexWordIterator(POS var1, String var2) throws JWNLException;

    public abstract IndexWord getIndexWord(POS var1, String var2) throws JWNLException;

    public abstract Iterator getSynsetIterator(POS var1) throws JWNLException;

    public abstract Synset getSynsetAt(POS var1, long var2) throws JWNLException;

    public abstract Iterator getExceptionIterator(POS var1) throws JWNLException;

    public abstract Exc getException(POS var1, String var2) throws JWNLException;

    public abstract void close();

    public boolean isMorphologicalProcessingEnabled() {
        return this.getMorphologicalProcessor() != null;
    }

    public MorphologicalProcessor getMorphologicalProcessor() {
        return this._morph;
    }

    public IndexWord lookupIndexWord(POS pOS, String string) throws JWNLException {
        IndexWord indexWord = this.getIndexWord(pOS, string = string.trim());
        if (indexWord == null && this.isMorphologicalProcessingEnabled()) {
            indexWord = this.getMorphologicalProcessor().lookupBaseForm(pOS, string);
        }
        return indexWord;
    }

    public IndexWordSet lookupAllIndexWords(String string) throws JWNLException {
        string = string.trim();
        IndexWordSet indexWordSet = new IndexWordSet(string);
        int n = 0;
        while (n < POS.CATS.length) {
            IndexWord indexWord = this.lookupIndexWord(POS.CATS[n], string);
            if (indexWord != null) {
                indexWordSet.add(indexWord);
            }
            ++n;
        }
        return indexWordSet;
    }
}

