/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.ConstantMatrix;
import edu.umass.cs.mallet.base.types.DenseMatrix;
import edu.umass.cs.mallet.base.types.FeatureSelection;
import edu.umass.cs.mallet.base.types.Vector;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.util.Arrays;
import java.util.logging.Logger;

public final class Matrix2
extends DenseMatrix {
    private static Logger logger = MalletLogger.getLogger(Matrix2.class.getName());
    int nr;
    int nc;

    public Matrix2(double[] values, int nr, int nc) {
        assert (values.length == nr * nc);
        this.values = values;
        this.nr = nr;
        this.nc = nc;
    }

    public Matrix2(int nr, int nc) {
        this(new double[nr * nc], nr, nc);
    }

    public Matrix2(double[][] values) {
        this.nr = values.length;
        this.nc = values[0].length;
        int i = 1;
        while (i < this.nr) {
            if (values[i].length != this.nc) {
                throw new IllegalArgumentException("Trying to initialize Matrix with array having columns to different lengths.");
            }
            ++i;
        }
        this.values = new double[this.nr * this.nc];
        i = 0;
        while (i < this.nr) {
            System.arraycopy(values[i], 0, values, i * this.nc, this.nc);
            ++i;
        }
    }

    public Matrix2(double value, int nr, int nc) {
        this.nr = nr;
        this.nc = nc;
        this.values = new double[nr * nc];
        Arrays.fill(this.values, value);
    }

    public int getNumDimensions() {
        return 2;
    }

    public int getDimensions(int[] sizes) {
        sizes[0] = this.nr;
        sizes[1] = this.nc;
        return 2;
    }

    public double value(int rowIndex, int colIndex) {
        return this.values[this.nc * rowIndex + colIndex];
    }

    public final void arrayCopyInto(double[] array, int startingArrayIndex) {
        System.arraycopy(this.values, 0, array, startingArrayIndex, this.values.length);
    }

    public final void arrayCopyFrom(double[] array, int startingArrayIndex) {
        System.arraycopy(array, startingArrayIndex, this.values, 0, this.values.length);
    }

    public void setValue(int rowIndex, int colIndex, double value) {
        this.values[this.nc * rowIndex + colIndex] = value;
    }

    public boolean sizeMatches(ConstantMatrix m) {
        if (m instanceof Matrix2) {
            return ((Matrix2)m).nr == this.nr && ((Matrix2)m).nc == this.nc;
        }
        int[] otherDims = new int[10];
        int numDimensions = this.getDimensions(otherDims);
        return numDimensions == 2 && otherDims[0] == this.nr && otherDims[1] == this.nc;
    }

    public boolean sizeMatches(Matrix2 m) {
        return m.nr == this.nr && m.nc == this.nc;
    }

    public int getNumRows() {
        return this.nr;
    }

    public int getNumCols() {
        return this.nc;
    }

    public Matrix2 transpose() {
        Matrix2 ret = new Matrix2(this.nc, this.nr);
        int i = 0;
        while (i < this.nr) {
            int j = 0;
            while (j < this.nc) {
                ret.values[j * this.nr + i] = this.values[i * this.nc + j];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public final double value(int[] indices) {
        assert (indices.length == 2);
        return this.values[indices[0] * this.nc + indices[1]];
    }

    public final void setValue(int[] indices, double val) {
        assert (indices.length == 2);
        this.values[indices[0] * this.nc + indices[1]] = val;
    }

    public final int singleIndex(int[] indices) {
        assert (indices.length == 2);
        return indices[indices[0] * this.nc + indices[1]];
    }

    public final void singleToIndices(int i, int[] indices) {
        assert (indices.length == 2);
        assert (i < this.nc * this.nr);
        indices[0] = i / this.nc;
        indices[1] = i % this.nc;
    }

    public final double singleValue(int i) {
        return this.values[i];
    }

    public final void setSingle(int i, double value) {
        this.values[i] = value;
    }

    public final int singleSize() {
        return this.nc * this.nr;
    }

    public final ConstantMatrix cloneMatrix() {
        return this.cloneMatrix2();
    }

    public final Matrix2 cloneMatrix2() {
        Matrix2 ret = new Matrix2(this.nr, this.nc);
        System.arraycopy(this.values, 0, ret.values, 0, this.values.length);
        return ret;
    }

    public final void setAll(double v) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = v;
            ++i;
        }
    }

    public final void setAll(double v, FeatureSelection fselection, boolean ifSelected) {
        if (fselection == null) {
            if (ifSelected) {
                logger.info("Matrix2.setAll using FeatureSelection==null");
                this.setAll(v);
            }
        } else {
            logger.info("Matrix2.setAll using FeatureSelection");
            int i = 0;
            while (i < this.values.length) {
                if (fselection.contains(i) ^ !ifSelected) {
                    this.values[i] = v;
                }
                ++i;
            }
        }
    }

    public final void rowSetAll(int ri, double v, FeatureSelection fselection, boolean ifSelected) {
        block5: {
            block4: {
                assert (ri < this.nr);
                if (fselection != null) break block4;
                if (!ifSelected) break block5;
                int ci = 0;
                while (ci < this.nc) {
                    this.values[ri * this.nc + ci] = v;
                    ++ci;
                }
                break block5;
            }
            int ci = 0;
            while (ci < this.nc) {
                if (fselection.contains(ci) ^ !ifSelected) {
                    this.values[ri * this.nc + ci] = v;
                }
                ++ci;
            }
        }
    }

    public final void plusEquals(int ri, int ci, double value) {
        assert (ri < this.nr);
        assert (ci < this.nc);
        int n = ri * this.nc + ci;
        this.values[n] = this.values[n] + value;
    }

    public final void rowPlusEquals(int ri, Vector v, double factor) {
        assert (ri < this.nr);
        int vli = 0;
        while (vli < v.numLocations()) {
            int n = ri * this.nc + v.indexAtLocation(vli);
            this.values[n] = this.values[n] + v.valueAtLocation(vli) * factor;
            ++vli;
        }
    }

    public final void rowPlusEquals(int ri, double v, double factor) {
        assert (ri < this.nr);
        int vli = 0;
        while (vli < this.nc) {
            int n = ri * this.nc + vli;
            this.values[n] = this.values[n] + v * factor;
            ++vli;
        }
    }

    public final void columnPlusEquals(int ci, Vector v, double factor) {
        assert (ci < this.nc);
        int vli = 0;
        while (vli < v.numLocations()) {
            int n = v.indexAtLocation(vli) * this.nc + ci;
            this.values[n] = this.values[n] + v.valueAtLocation(vli) * factor;
            ++vli;
        }
    }

    public final void columnPlusEquals(int ci, double v, double factor) {
        assert (ci < this.nc);
        int vli = 0;
        while (vli < this.nr) {
            int n = vli * this.nc + ci;
            this.values[n] = this.values[n] + v * factor;
            ++vli;
        }
    }

    public final double rowDotProduct(int ri, Vector v) {
        double ret = 0.0;
        int cil = 0;
        while (cil < v.numLocations()) {
            int ci = v.indexAtLocation(cil);
            if (ci < this.nc) {
                ret += this.values[ri * this.nc + ci] * v.valueAtLocation(cil);
            }
            ++cil;
        }
        return ret;
    }

    public final double rowDotProduct(int ri, Vector v, int maxCi, FeatureSelection selection) {
        double ret = 0.0;
        if (selection != null) {
            int cil = 0;
            while (cil < v.numLocations()) {
                int ci = v.indexAtLocation(cil);
                if (selection.contains(ci) && ci < this.nc && ci <= maxCi) {
                    ret += this.values[ri * this.nc + ci] * v.valueAtLocation(cil);
                }
                ++cil;
            }
        } else {
            int cil = 0;
            while (cil < v.numLocations()) {
                int ci = v.indexAtLocation(cil);
                if (ci < this.nc && ci <= maxCi) {
                    ret += this.values[ri * this.nc + ci] * v.valueAtLocation(cil);
                }
                ++cil;
            }
        }
        return ret;
    }

    public final double twoNormSquared() {
        double ret = 0.0;
        int i = 0;
        while (i < this.values.length) {
            ret += this.values[i] * this.values[i];
            ++i;
        }
        return ret;
    }

    public void print() {
        int i = 0;
        while (i < this.nr) {
            int j = 0;
            while (j < this.nc) {
                System.out.print(" " + this.values[i * this.nc + j]);
                ++j;
            }
            System.out.println("");
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.nr) {
            int j = 0;
            while (j < this.nc) {
                sb.append(" " + this.values[i * this.nc + j]);
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

