/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.file.DictionaryCatalog;
import net.didion.jwnl.dictionary.file.DictionaryCatalogSet;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file.ObjectDictionaryFile;
import net.didion.jwnl.util.factory.Param;
import net.didion.jwnl.util.logging.Level;
import net.didion.jwnl.util.logging.LogPublishingService;

public class MapBackedDictionary
extends Dictionary {
    public static final String MORPH = "morphological_processor";
    public static final String FILE_TYPE = "file_type";
    public static final String PATH = "dictionary_path";
    private Map _tableMap = new HashMap();
    static /* synthetic */ Class class$net$didion$jwnl$dictionary$file$ObjectDictionaryFile;

    public MapBackedDictionary() {
    }

    public static void install(String string, Class clazz) throws JWNLException {
        MapBackedDictionary.install(string, clazz, null);
    }

    public static void install(String string, Class clazz, MorphologicalProcessor morphologicalProcessor) throws JWNLException {
        MapBackedDictionary.checkFileType(clazz);
        DictionaryCatalogSet dictionaryCatalogSet = new DictionaryCatalogSet(string, clazz);
        Dictionary.setDictionary(new MapBackedDictionary(dictionaryCatalogSet, morphologicalProcessor));
        dictionaryCatalogSet.close();
    }

    public void install(Map map) throws JWNLException {
        Param param = (Param)map.get(MORPH);
        MorphologicalProcessor morphologicalProcessor = param == null ? null : (MorphologicalProcessor)param.create();
        param = (Param)map.get(FILE_TYPE);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(param.getValue());
        }
        catch (Exception exception) {
            throw new JWNLException("DICTIONARY_EXCEPTION_003", param.getValue(), (Throwable)exception);
        }
        MapBackedDictionary.checkFileType(clazz);
        param = (Param)map.get(PATH);
        String string = param.getValue();
        MapBackedDictionary.install(string, clazz, morphologicalProcessor);
    }

    private static void checkFileType(Class clazz) {
        if (!(class$net$didion$jwnl$dictionary$file$ObjectDictionaryFile == null ? (class$net$didion$jwnl$dictionary$file$ObjectDictionaryFile = MapBackedDictionary.class$("net.didion.jwnl.dictionary.file.ObjectDictionaryFile")) : class$net$didion$jwnl$dictionary$file$ObjectDictionaryFile).isAssignableFrom(clazz)) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_010", clazz);
        }
    }

    private MapBackedDictionary(DictionaryCatalogSet dictionaryCatalogSet, MorphologicalProcessor morphologicalProcessor) throws JWNLException {
        super(morphologicalProcessor);
        if (!dictionaryCatalogSet.isOpen()) {
            try {
                dictionaryCatalogSet.open();
            }
            catch (Exception exception) {
                throw new JWNLException("DICTIONARY_EXCEPTION_019", exception);
            }
        }
        LogPublishingService.getInstance().log(Level.INFO, "Loading MapBackedDictionary");
        LogPublishingService.getInstance().log(Level.FINE, "Starting Memory: " + Runtime.getRuntime().freeMemory());
        int n = 0;
        while (n < DictionaryFileType.FILE_TYPES.length) {
            DictionaryFileType dictionaryFileType = DictionaryFileType.FILE_TYPES[n];
            DictionaryCatalog dictionaryCatalog = dictionaryCatalogSet.get(dictionaryFileType);
            int n2 = 0;
            while (n2 < POS.CATS.length) {
                POS pOS = POS.CATS[n2];
                LogPublishingService.getInstance().log(Level.INFO, "Loading " + pOS + " " + dictionaryFileType);
                this.putTable(pOS, dictionaryFileType, this.loadDictFile(dictionaryCatalog.get(pOS)));
                LogPublishingService.getInstance().log(Level.FINE, "Current Memory: " + Runtime.getRuntime().freeMemory());
                ++n2;
            }
            ++n;
        }
    }

    public IndexWord getIndexWord(POS pOS, String string) {
        return (IndexWord)this.getTable(pOS, DictionaryFileType.INDEX).get(string);
    }

    public Iterator getIndexWordIterator(POS pOS, String string) {
        IndexWord indexWord;
        Iterator iterator = this.getIndexWordIterator(pOS);
        Object object = null;
        while (iterator.hasNext()) {
            indexWord = (IndexWord)iterator.next();
            String string2 = indexWord.getLemma();
            if (string2.indexOf(string) == -1) continue;
            object = string2;
            break;
        }
        indexWord = object;
        return new Iterator((String)((Object)indexWord), iterator, string){
            private String nextWord;
            private Iterator i;
            private final /* synthetic */ String val$startWord;
            private final /* synthetic */ Iterator val$itr;
            private final /* synthetic */ String val$substring;
            {
                this.val$startWord = string;
                this.val$itr = iterator;
                this.val$substring = string2;
                this.nextWord = this.val$startWord;
                this.i = this.val$itr;
            }

            public boolean hasNext() {
                return this.nextWord != null;
            }

            public Object next() {
                if (this.hasNext()) {
                    String string = this.nextWord;
                    this.nextWord = null;
                    while (this.i.hasNext()) {
                        IndexWord indexWord = (IndexWord)this.val$itr.next();
                        String string2 = indexWord.getLemma();
                        if (string2.indexOf(this.val$substring) == -1) continue;
                        this.nextWord = string2;
                        break;
                    }
                    return string;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
            }
        };
    }

    public Iterator getIndexWordIterator(POS pOS) {
        return this.getIterator(this.getTable(pOS, DictionaryFileType.INDEX));
    }

    public Iterator getSynsetIterator(POS pOS) {
        return this.getIterator(this.getTable(pOS, DictionaryFileType.DATA));
    }

    public Iterator getExceptionIterator(POS pOS) {
        return this.getIterator(this.getTable(pOS, DictionaryFileType.EXCEPTION));
    }

    private Iterator getIterator(Map map) {
        return map.values().iterator();
    }

    public Synset getSynsetAt(POS pOS, long l) {
        return (Synset)this.getTable(pOS, DictionaryFileType.DATA).get(new Long(l));
    }

    public Exc getException(POS pOS, String string) {
        return (Exc)this.getTable(pOS, DictionaryFileType.EXCEPTION).get(string);
    }

    public void close() {
        this._tableMap = null;
    }

    private Map loadDictFile(DictionaryFile dictionaryFile) throws JWNLException {
        try {
            return (Map)((ObjectDictionaryFile)dictionaryFile).readObject();
        }
        catch (Exception exception) {
            throw new JWNLException("DICTIONARY_EXCEPTION_020", dictionaryFile.getFile(), (Throwable)exception);
        }
    }

    private void putTable(POS pOS, DictionaryFileType dictionaryFileType, Map map) {
        this._tableMap.put(new MapTableKey(pOS, dictionaryFileType), map);
    }

    private Map getTable(POS pOS, DictionaryFileType dictionaryFileType) {
        return (Map)this._tableMap.get(new MapTableKey(pOS, dictionaryFileType));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class MapTableKey {
        private POS _pos;
        private DictionaryFileType _fileType;

        MapTableKey(POS pOS, DictionaryFileType dictionaryFileType) {
            this._pos = pOS;
            this._fileType = dictionaryFileType;
        }

        public int hashCode() {
            return this._pos.hashCode() ^ this._fileType.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof MapTableKey) {
                MapTableKey mapTableKey = (MapTableKey)object;
                return this._pos.equals(mapTableKey._pos) && this._fileType.equals(mapTableKey._fileType);
            }
            return false;
        }
    }
}

