/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.Serializable;
import java.util.ArrayList;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.util.Resolvable;

public final class VerbFrame
implements Serializable {
    static final long serialVersionUID = 1450633678809744269L;
    private static VerbFrame[] _verbFrames;
    private static boolean _initalized;
    private Resolvable _frame;
    private int _index;
    private String _cachedToString = null;

    public static void initialize() {
        if (!_initalized) {
            int n = Integer.parseInt(JWNL.resolveMessage("NUMBER_OF_VERB_FRAMES"));
            _verbFrames = new VerbFrame[n];
            int n2 = 1;
            while (n2 <= n) {
                VerbFrame._verbFrames[n2 - 1] = new VerbFrame(VerbFrame.getKeyString(n2), n2);
                ++n2;
            }
            _initalized = true;
        }
    }

    public static final String getKeyString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VERB_FRAME_");
        int n2 = 3 - String.valueOf(n).length();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(0);
            ++n3;
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static int getVerbFramesSize() {
        return _verbFrames.length;
    }

    public static String getFrame(int n) {
        return _verbFrames[n - 1].getFrame();
    }

    public static String[] getFrames(long l) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < VerbFrame.getVerbFramesSize()) {
            if ((l >> n & 1L) == 1L) {
                arrayList.add(_verbFrames[n].getFrame());
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private VerbFrame(String string, int n) {
        this._frame = new Resolvable(string);
        this._index = n;
    }

    public String getFrame() {
        return this._frame.toString();
    }

    public int getIndex() {
        return this._index;
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_007", this.getFrame());
        }
        return this._cachedToString;
    }

    public int hashCode() {
        return this.getIndex();
    }

    static {
        _initalized = false;
    }
}

