/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import pnuts.lang.Configuration;
import pnuts.lang.Numeric;
import pnuts.lang.Pnuts;
import pnuts.lang.Runtime;

public abstract class BinaryOperator
implements Serializable {
    static BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
    static BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
    static final int SmallIntSize = 64;
    static final Integer[] smallInt = new Integer[64];

    protected Object op_int(int i1, int i2) {
        throw new IllegalArgumentException(i1 + ", " + i2);
    }

    protected Object op_long(long l1, long l2) {
        throw new IllegalArgumentException(l1 + ", " + l2);
    }

    protected Object op_float(float f1, float f2) {
        throw new IllegalArgumentException(f1 + ", " + f2);
    }

    protected Object op_double(double d1, double d2) {
        throw new IllegalArgumentException(d1 + ", " + d2);
    }

    protected Object op_bdec(BigDecimal d1, BigDecimal d2) {
        throw new IllegalArgumentException(d1 + ", " + d2);
    }

    protected Object op_bint(BigInteger b1, BigInteger b2) {
        throw new IllegalArgumentException(b1 + ", " + b2);
    }

    protected Object op_numeric(Numeric n1, Object n2) {
        throw new IllegalArgumentException(n1 + ", " + n2);
    }

    protected Object op_numeric(Object n1, Numeric n2) {
        throw new IllegalArgumentException(n1 + ", " + n2);
    }

    protected Object op_object(Object o1, Object o2) {
        throw new IllegalArgumentException(o1 + ", " + o2);
    }

    protected Object op_string(String n1, Object n2) {
        throw new IllegalArgumentException(n1 + ", " + n2);
    }

    protected Object op_string(Object n1, String n2) {
        throw new IllegalArgumentException(n1 + ", " + n2);
    }

    protected Object op_boolean(boolean b1, boolean b2) {
        throw new IllegalArgumentException(b1 + ", " + b2);
    }

    public Object operateOn(Object n1, Object n2) {
        int t1 = n1 instanceof Integer ? 1 : (n1 instanceof Character ? 2 : (n1 instanceof Byte ? 4 : (n1 instanceof Short ? 8 : (n1 instanceof Long ? 16 : (n1 instanceof Float ? 32 : (n1 instanceof Double ? 64 : (n1 instanceof String ? 128 : (n1 instanceof BigDecimal ? 256 : (n1 instanceof BigInteger ? 512 : (n1 instanceof Boolean ? 1024 : (n1 instanceof Numeric ? 2048 : 0)))))))))));
        int t2 = n2 instanceof Integer ? 1 : (n2 instanceof Character ? 2 : (n2 instanceof Byte ? 4 : (n2 instanceof Short ? 8 : (n2 instanceof Long ? 16 : (n2 instanceof Float ? 32 : (n2 instanceof Double ? 64 : (n2 instanceof String ? 128 : (n2 instanceof BigDecimal ? 256 : (n2 instanceof BigInteger ? 512 : (n2 instanceof Boolean ? 1024 : (n2 instanceof Numeric ? 2048 : 0)))))))))));
        switch (t1 << 16 | t2) {
            case 65540: 
            case 65544: 
            case 262145: 
            case 262148: 
            case 262152: 
            case 524289: 
            case 524292: 
            case 524296: {
                return this.op_int(((Number)n1).intValue(), ((Number)n2).intValue());
            }
            case 65537: {
                return this.op_int((Integer)n1, (Integer)n2);
            }
            case 262146: 
            case 524290: {
                return this.op_int(((Number)n1).intValue(), ((Character)n2).charValue());
            }
            case 65538: {
                return this.op_int((Integer)n1, ((Character)n2).charValue());
            }
            case 65552: 
            case 0x100001: 
            case 0x100010: {
                return this.op_long(((Number)n1).longValue(), ((Number)n2).longValue());
            }
            case 131076: 
            case 131080: {
                return this.op_int(((Character)n1).charValue(), ((Number)n2).intValue());
            }
            case 131073: {
                return this.op_int(((Character)n1).charValue(), (Integer)n2);
            }
            case 131074: {
                return this.op_int(((Character)n1).charValue(), ((Character)n2).charValue());
            }
            case 131088: {
                return this.op_long(((Character)n1).charValue(), (Long)n2);
            }
            case 0x100002: {
                return this.op_long((Long)n1, ((Character)n2).charValue());
            }
            case 65568: 
            case 0x100020: 
            case 0x200001: 
            case 0x200010: 
            case 0x200020: {
                return this.op_float(((Number)n1).floatValue(), ((Number)n2).floatValue());
            }
            case 65600: 
            case 0x100040: 
            case 0x200040: 
            case 0x400001: 
            case 0x400010: 
            case 0x400020: 
            case 0x400040: {
                return this.op_double(((Number)n1).doubleValue(), ((Number)n2).doubleValue());
            }
            case 131104: {
                return this.op_float(((Character)n1).charValue(), ((Float)n2).floatValue());
            }
            case 0x200002: {
                return this.op_float(((Float)n1).floatValue(), ((Character)n2).charValue());
            }
            case 131136: {
                return this.op_double(((Character)n1).charValue(), (Double)n2);
            }
            case 0x400002: {
                return this.op_double((Double)n1, ((Character)n2).charValue());
            }
            case 66048: 
            case 262656: 
            case 524800: 
            case 0x100200: {
                return this.op_bint(BigInteger.valueOf(((Number)n1).longValue()), (BigInteger)n2);
            }
            case 131584: {
                return this.op_bint(BigInteger.valueOf(((Character)n1).charValue()), (BigInteger)n2);
            }
            case 0x2000001: 
            case 0x2000004: 
            case 0x2000008: 
            case 0x2000010: {
                return this.op_bint((BigInteger)n1, BigInteger.valueOf(((Number)n2).longValue()));
            }
            case 0x2000002: {
                return this.op_bint((BigInteger)n1, BigInteger.valueOf(((Character)n2).charValue()));
            }
            case 0x2000200: {
                return this.op_bint((BigInteger)n1, (BigInteger)n2);
            }
            case 0x2000020: {
                float ff = ((Float)n2).floatValue();
                if (Float.isInfinite(ff) || Float.isNaN(ff)) {
                    return n2;
                }
                return this.op_bdec(new BigDecimal((BigInteger)n1), BinaryOperator.doubleToDecimal(ff));
            }
            case 0x2000040: {
                double dd = (Double)n2;
                if (Double.isInfinite(dd) || Double.isNaN(dd)) {
                    return n2;
                }
                return this.op_bdec(new BigDecimal((BigInteger)n1), BinaryOperator.doubleToDecimal(dd));
            }
            case 0x200200: {
                float ff = ((Float)n1).floatValue();
                if (Float.isInfinite(ff) || Float.isNaN(ff)) {
                    return n1;
                }
                return this.op_bdec(BinaryOperator.doubleToDecimal(ff), new BigDecimal((BigInteger)n2));
            }
            case 0x400200: {
                double dd = (Double)n1;
                if (Double.isInfinite(dd) || Double.isNaN(dd)) {
                    return n1;
                }
                return this.op_bdec(BinaryOperator.doubleToDecimal(dd), new BigDecimal((BigInteger)n2));
            }
            case 65792: 
            case 262400: 
            case 524544: 
            case 0x100100: {
                BigDecimal b1 = Configuration.normalConfiguration.longToBigDecimal(((Number)n1).longValue());
                return this.op_bdec(b1, (BigDecimal)n2);
            }
            case 131328: {
                BigDecimal d1 = Configuration.normalConfiguration.longToBigDecimal(((Character)n1).charValue());
                return this.op_bdec(d1, (BigDecimal)n2);
            }
            case 0x200100: {
                float ff = ((Float)n1).floatValue();
                if (Float.isInfinite(ff) || Float.isNaN(ff)) {
                    return n1;
                }
                return this.op_bdec(BinaryOperator.doubleToDecimal(ff), (BigDecimal)n2);
            }
            case 0x400100: {
                double dd = (Double)n1;
                if (Double.isInfinite(dd) || Double.isNaN(dd)) {
                    return n1;
                }
                return this.op_bdec(BinaryOperator.doubleToDecimal(dd), (BigDecimal)n2);
            }
            case 0x1000001: 
            case 0x1000004: 
            case 0x1000008: 
            case 0x1000010: {
                BigDecimal b2 = Configuration.normalConfiguration.longToBigDecimal(((Number)n2).longValue());
                return this.op_bdec((BigDecimal)n1, b2);
            }
            case 0x1000002: {
                BigDecimal d2 = Configuration.normalConfiguration.longToBigDecimal(((Character)n2).charValue());
                return this.op_bdec((BigDecimal)n1, d2);
            }
            case 0x1000020: {
                float ff = ((Float)n2).floatValue();
                if (Float.isInfinite(ff) || Float.isNaN(ff)) {
                    return n2;
                }
                return this.op_bdec((BigDecimal)n1, BinaryOperator.doubleToDecimal(ff));
            }
            case 0x1000040: {
                double dd = (Double)n2;
                if (Double.isInfinite(dd) || Double.isNaN(dd)) {
                    return n2;
                }
                return this.op_bdec((BigDecimal)n1, BinaryOperator.doubleToDecimal(dd));
            }
            case 0x1000100: {
                return this.op_bdec((BigDecimal)n1, (BigDecimal)n2);
            }
            case 0x4000400: {
                return this.op_boolean((Boolean)n1, (Boolean)n2);
            }
            case 0x800000: 
            case 0x800001: 
            case 0x800002: 
            case 0x800004: 
            case 0x800008: 
            case 0x800010: 
            case 0x800020: 
            case 0x800040: 
            case 0x800080: 
            case 0x800100: 
            case 0x800200: 
            case 0x800400: 
            case 0x800800: {
                return this.op_string((String)n1, n2);
            }
            case 128: 
            case 65664: 
            case 131200: 
            case 262272: 
            case 524416: 
            case 0x100080: 
            case 0x200080: 
            case 0x400080: 
            case 0x1000080: 
            case 0x2000080: 
            case 0x4000080: 
            case 0x8000080: {
                return this.op_string(n1, (String)n2);
            }
            case 0x8000001: 
            case 0x8000002: 
            case 0x8000004: 
            case 0x8000008: 
            case 0x8000010: 
            case 0x8000020: 
            case 0x8000040: 
            case 0x8000100: 
            case 0x8000200: 
            case 0x8000800: {
                return this.op_numeric((Numeric)n1, n2);
            }
            case 67584: 
            case 133120: 
            case 264192: 
            case 526336: 
            case 0x100800: 
            case 0x200800: 
            case 0x400800: 
            case 0x1000800: 
            case 0x2000800: {
                return this.op_numeric(n1, (Numeric)n2);
            }
        }
        return this.op_object(n1, n2);
    }

    static BigDecimal doubleToDecimal(double d) {
        return (BigDecimal)Runtime.decimalNumber("" + d, 10);
    }

    protected static Number compressNumber(Number n) {
        return Runtime.compress(n);
    }

    static Object appendArray(Object p1, Object p2) {
        int l1 = Runtime.getArrayLength(p1);
        int l2 = Runtime.getArrayLength(p2);
        Object p3 = Array.newInstance(p1.getClass().getComponentType(), l1 + l2);
        System.arraycopy(p1, 0, p3, 0, l1);
        for (int i = 0; i < l2; ++i) {
            Array.set(p3, i + l1, Array.get(p2, i));
        }
        return p3;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            BinaryOperator.smallInt[i] = new Integer(i);
        }
    }

    public static class Xor
    extends BinaryOperator {
        static Xor instance = new Xor();

        public Object op_int(int i1, int i2) {
            return new Integer(i1 ^ i2);
        }

        public Object op_long(long d1, long d2) {
            return new Long(d1 ^ d2);
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.xor(b2));
        }

        public Object op_boolean(boolean b1, boolean b2) {
            return b1 ^ b2 ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class Or
    extends BinaryOperator {
        static Or instance = new Or();

        public Object op_int(int i1, int i2) {
            return new Integer(i1 | i2);
        }

        public Object op_long(long d1, long d2) {
            return new Long(d1 | d2);
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.or(b2));
        }

        public Object op_boolean(boolean b1, boolean b2) {
            return b1 | b2 ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class And
    extends BinaryOperator {
        static And instance = new And();

        public Object op_int(int i1, int i2) {
            return new Integer(i1 & i2);
        }

        public Object op_long(long d1, long d2) {
            return new Long(d1 & d2);
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.and(b2));
        }

        public Object op_boolean(boolean b1, boolean b2) {
            return b1 & b2 ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class ShiftRight
    extends BinaryOperator {
        static ShiftRight instance = new ShiftRight();

        public Object op_int(int d1, int d2) {
            return new Integer(d1 >> d2);
        }

        public Object op_long(long d1, long d2) {
            long l = d1 >> (int)d2;
            if (l >= 0L && l < 64L) {
                return smallInt[(int)l];
            }
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.shiftRight(b2.intValue()));
        }
    }

    public static class ShiftLeft
    extends BinaryOperator {
        static ShiftLeft instance = new ShiftLeft();

        public Object op_int(int d1, int d2) {
            int m = 0;
            long dd = d1;
            while (dd > 0L) {
                dd >>= 1;
                ++m;
            }
            if (d2 + m > 63) {
                return Runtime.compress(BigInteger.valueOf(d1).shiftLeft(d2));
            }
            long l = (long)d1 << d2;
            if (l >= 0L && l < 64L) {
                return smallInt[(int)l];
            }
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }

        public Object op_long(long d1, long d2) {
            int m = 0;
            long dd = d1;
            while (dd > 0L) {
                dd >>= 1;
                ++m;
            }
            if (d2 + (long)m > 63L) {
                return Runtime.compress(BigInteger.valueOf(d1).shiftLeft((int)d2));
            }
            long l = d1 << (int)d2;
            if (l >= 0L && l < 64L) {
                return smallInt[(int)l];
            }
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.shiftLeft(b2.intValue()));
        }
    }

    public static class ShiftArithmetic
    extends BinaryOperator {
        static ShiftArithmetic instance = new ShiftArithmetic();

        public Object op_int(int d1, int d2) {
            return new Integer(d1 >>> d2);
        }

        public Object op_long(long d1, long d2) {
            long l = d1 >>> (int)d2;
            if (l >= 0L && l < 64L) {
                return smallInt[(int)l];
            }
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }
    }

    public static class Mod
    extends BinaryOperator {
        static Mod instance = new Mod();

        public Object op_int(int i1, int i2) {
            return new Integer(i1 % i2);
        }

        public Object op_long(long d1, long d2) {
            long d3 = d1 % d2;
            if (d3 <= Integer.MAX_VALUE && d3 >= Integer.MIN_VALUE) {
                return new Integer((int)d3);
            }
            return new Long(d3);
        }

        public Object op_float(float f1, float f2) {
            throw new IllegalArgumentException();
        }

        public Object op_double(double d1, double d2) {
            throw new IllegalArgumentException();
        }

        public Object op_bdec(BigDecimal d1, BigDecimal d2) {
            throw new IllegalArgumentException();
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.mod(b2));
        }
    }

    public static class Divide
    extends BinaryOperator {
        static Divide instance = new Divide();

        public Object op_int(int i1, int i2) {
            return new Integer(i1 / i2);
        }

        public Object op_long(long d1, long d2) {
            long d3 = d1 / d2;
            if (d3 <= Integer.MAX_VALUE && d3 >= Integer.MIN_VALUE) {
                return new Integer((int)d3);
            }
            return new Long(d3);
        }

        public Object op_float(float f1, float f2) {
            return new Float(f1 / f2);
        }

        public Object op_double(double d1, double d2) {
            return new Double(d1 / d2);
        }

        public Object op_bdec(BigDecimal d1, BigDecimal d2) {
            return d1.divide(d2, 5);
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.divide(b2));
        }

        public Object op_numeric(Numeric n1, Object n2) {
            return n1.divide(n2);
        }

        public Object op_numeric(Object n1, Numeric n2) {
            return Multiply.instance.operateOn(n2.inverse(), n1);
        }
    }

    public static class Multiply
    extends BinaryOperator {
        static Multiply instance = new Multiply();

        public Object op_int(int i1, int i2) {
            long l = (long)i1 * (long)i2;
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }

        public Object op_long(long d1, long d2) {
            long d3 = d1 * d2;
            if (d2 == 0L) {
                return new Long(0L);
            }
            if (d3 / d2 == d1) {
                if (d3 <= Integer.MAX_VALUE && d3 >= Integer.MIN_VALUE) {
                    return new Integer((int)d3);
                }
                return new Long(d3);
            }
            return this.op_bint(BigInteger.valueOf(d1), BigInteger.valueOf(d2));
        }

        public Object op_float(float f1, float f2) {
            return new Float(f1 * f2);
        }

        public Object op_double(double d1, double d2) {
            return new Double(d1 * d2);
        }

        public Object op_bdec(BigDecimal d1, BigDecimal d2) {
            return d1.multiply(d2);
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.multiply(b2));
        }

        public Object op_numeric(Numeric n1, Object n2) {
            return n1.multiply(n2);
        }

        public Object op_numeric(Object n1, Numeric n2) {
            return n2.multiply(n1);
        }
    }

    public static class Subtract
    extends BinaryOperator {
        static Subtract instance = new Subtract();

        public Object op_int(int i1, int i2) {
            long l = (long)i1 - (long)i2;
            if (l >= 0L && l < 64L) {
                return smallInt[(int)l];
            }
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }

        public Object op_long(long d1, long d2) {
            long d3 = d1 - d2;
            if (d3 > d1 && d2 > 0L || d3 < d1 && d2 < 0L) {
                return this.op_bint(BigInteger.valueOf(d1), BigInteger.valueOf(d2));
            }
            if (d3 <= Integer.MAX_VALUE && d3 >= Integer.MIN_VALUE) {
                return new Integer((int)d3);
            }
            return new Long(d3);
        }

        public Object op_float(float f1, float f2) {
            return new Float(f1 - f2);
        }

        public Object op_double(double d1, double d2) {
            return new Double(d1 - d2);
        }

        public Object op_bdec(BigDecimal d1, BigDecimal d2) {
            return d1.subtract(d2);
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.subtract(b2));
        }

        public Object op_numeric(Numeric n1, Object n2) {
            return n1.subtract(n2);
        }

        public Object op_numeric(Object n1, Numeric n2) {
            return Add.instance.operateOn(n2.negate(), n1);
        }
    }

    public static class Add
    extends BinaryOperator {
        static Add instance = new Add();

        public Object op_int(int i1, int i2) {
            long l = (long)i1 + (long)i2;
            if (l >= 0L && l < 64L) {
                return smallInt[(int)l];
            }
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }

        public Object op_long(long d1, long d2) {
            long d3 = d1 + d2;
            if (d3 > d1 && d2 < 0L || d3 < d1 && d2 > 0L) {
                return Runtime.compress(BigInteger.valueOf(d1).add(BigInteger.valueOf(d2)));
            }
            if (d3 >= 0L && d3 < 64L) {
                return smallInt[(int)d3];
            }
            if (d3 <= Integer.MAX_VALUE && d3 >= Integer.MIN_VALUE) {
                return new Integer((int)d3);
            }
            return new Long(d3);
        }

        public Object op_float(float f1, float f2) {
            return new Float(f1 + f2);
        }

        public Object op_double(double d1, double d2) {
            return new Double(d1 + d2);
        }

        public Object op_bdec(BigDecimal d1, BigDecimal d2) {
            return d1.add(d2);
        }

        public Object op_bint(BigInteger b1, BigInteger b2) {
            return Runtime.compress(b1.add(b2));
        }

        public Object op_numeric(Numeric n1, Object n2) {
            return n1.add(n2);
        }

        public Object op_numeric(Object n1, Numeric n2) {
            return n2.add(n1);
        }

        public Object op_string(String n1, Object n2) {
            StringBuffer sbuf = new StringBuffer(n1);
            Add.concat(n2, sbuf);
            return sbuf.toString();
        }

        public Object op_string(Object n1, String n2) {
            StringBuffer sbuf = new StringBuffer();
            Add.concat(n1, sbuf);
            sbuf.append(n2);
            return sbuf.toString();
        }

        public Object op_object(Object o1, Object o2) {
            if (Runtime.isArray(o1) && Runtime.isArray(o2)) {
                return BinaryOperator.appendArray(o1, o2);
            }
            return super.op_object(o1, o2);
        }

        static void concat(Object o, StringBuffer sbuf) {
            String s = Runtime.isArray(o) ? Pnuts.format(o) : String.valueOf(o);
            sbuf.append(s);
        }
    }
}

