/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.tools.CancelableContext;
import pnuts.tools.Console;
import pnuts.tools.LogReader;
import pnuts.tools.Main;

public class PnutsConsole
extends Console {
    static final String THREAD_NAME = "Pnuts Console";
    public static final String GREETING = "pnuts.tools.PnutsConsole.greeting";
    public static final String INPUTLOG = "pnuts.tools.PnutsConsole.inputlog";
    boolean greeting = true;
    Thread th;
    String inputlog;
    Reader reader;
    Context context;
    ClassLoader classLoader;
    Runnable terminationCallback;
    String[] modules;
    int priority = 5;

    public void setModules(String[] modules) {
        this.modules = modules;
    }

    public String[] getModules() {
        return this.modules;
    }

    public void setGreeting(boolean flag) {
        this.greeting = flag;
    }

    public boolean getGreeting() {
        return this.greeting;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setInputLog(String name) {
        this.inputlog = name;
    }

    public String getInputLog() {
        return this.inputlog;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTerminationCallback(Runnable terminationCallback) {
        this.terminationCallback = terminationCallback;
    }

    public Runnable getTerminationCallback() {
        return this.terminationCallback;
    }

    public void start() {
        if (this.ui == null) {
            throw new IllegalStateException("no UI ");
        }
        final Writer w = this.getWriter();
        final Context c = this.context == null ? new CancelableContext() : this.context;
        if (this.classLoader != null) {
            c.setClassLoader(this.classLoader);
        }
        if (this.modules != null) {
            for (int i = 0; i < this.modules.length; ++i) {
                c.usePackage(this.modules[i]);
            }
        }
        c.setWriter(w);
        c.setErrorWriter(w);
        c.setTerminalWriter(w);
        final Reader r = this.getReader();
        this.th = new Thread(new Runnable(){

            public void run() {
                if (PnutsConsole.this.greeting) {
                    Main.greeting(c);
                }
                Pnuts.load(r, true, c);
                PnutsConsole.this.close();
                try {
                    w.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    r.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, THREAD_NAME);
        this.th.setDaemon(true);
        this.th.setPriority(this.priority);
        if (this.classLoader != null) {
            this.th.setContextClassLoader(this.classLoader);
        }
        this.th.start();
    }

    protected void close() {
        if (this.terminationCallback != null) {
            this.terminationCallback.run();
        }
        this.ui.close();
    }

    public void dispose() {
        try {
            if (this.context instanceof CancelableContext) {
                ((CancelableContext)this.context).cancel();
            }
            this.enter("quit()\n");
            this.getReader().close();
            this.getWriter().close();
            if (this.th != null) {
                this.th.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Reader getReader() {
        if (this.reader == null) {
            if (this.inputlog != null) {
                try {
                    this.reader = new LogReader(super.getReader(), this.inputlog);
                }
                catch (IOException e) {
                    this.reader = super.getReader();
                }
            } else {
                this.reader = super.getReader();
            }
        }
        return this.reader;
    }
}

