/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelWriter;
import opennlp.perceptron.BinaryPerceptronModelWriter;
import opennlp.perceptron.PerceptronModelWriter;
import opennlp.perceptron.PlainTextPerceptronModelWriter;

public class SuffixSensitivePerceptronModelWriter
extends PerceptronModelWriter {
    private final AbstractModelWriter suffixAppropriateWriter;

    public SuffixSensitivePerceptronModelWriter(AbstractModel abstractModel, File file) throws IOException {
        super(abstractModel);
        FilterOutputStream filterOutputStream;
        String string = file.getName();
        if (string.endsWith(".gz")) {
            filterOutputStream = new GZIPOutputStream(new FileOutputStream(file));
            string = string.substring(0, string.length() - 3);
        } else {
            filterOutputStream = new DataOutputStream(new FileOutputStream(file));
        }
        this.suffixAppropriateWriter = string.endsWith(".bin") ? new BinaryPerceptronModelWriter(abstractModel, new DataOutputStream(filterOutputStream)) : new PlainTextPerceptronModelWriter(abstractModel, new BufferedWriter(new OutputStreamWriter(filterOutputStream)));
    }

    public void writeUTF(String string) throws IOException {
        this.suffixAppropriateWriter.writeUTF(string);
    }

    public void writeInt(int n) throws IOException {
        this.suffixAppropriateWriter.writeInt(n);
    }

    public void writeDouble(double d) throws IOException {
        this.suffixAppropriateWriter.writeDouble(d);
    }

    public void close() throws IOException {
        this.suffixAppropriateWriter.close();
    }
}

