/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import AceJet.Ace;
import AceJet.Datum;
import AceJet.EDTtype;
import AceJet.PerfectAce;
import Jet.Console;
import Jet.Control;
import Jet.HMM.HMMNameTagger;
import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.MaxEntModel;
import Jet.Parser.SynFun;
import Jet.Pat.Pat;
import Jet.Refres.Hobbs;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxEntResolve {
    static Vector clauses;
    static Vector entities;
    public static SentenceSet sentenceSet;
    static boolean fullParse;
    public static boolean linkAppositesAndPredComps;
    public static boolean nameTypeMatch;
    private static Annotation speakerEntity;
    static HashMap mentionToEntity;
    static HashMap syntacticAntecedent;
    public static boolean trace;
    static Annotation parseTree;
    static HashMap<Annotation, Annotation> parents;
    static int pronounDefiniteNonCorefSuccessCount;
    static int pronounDefiniteNonCorefFailureCount;
    static String trainingDirectory1;
    static String trainingCollection1;
    static String trainingDirectory;
    static String trainingCollection;
    static String trainingDirectoryParses;
    static String trainingCollectionParses;
    static boolean useParser;
    static MaxEntModel pronounModel;

    public static void references(Document document, Span span) {
        Object object;
        int n;
        Vector<Annotation> vector;
        trace = Resolve.trace;
        if (pronounModel == null) {
            pronounModel = new MaxEntModel();
            String string = JetTest.getConfigFile("Resolve.MaxEntModel.filename");
            if (string == null) {
                System.err.println("No Resolve.MaxEntModel.filename specified");
                System.exit(1);
            }
            pronounModel.loadModel(string);
        }
        if ((vector = document.annotationsAt(n = span.start(), "sentence")) != null && vector.size() > 0) {
            object = vector.get(0);
            fullParse = ((Annotation)object).get("parse") != null;
            parseTree = (Annotation)((Annotation)object).get("parse");
            parents = SynFun.collectParents(parseTree);
        } else {
            fullParse = false;
        }
        Resolve.fullParse = fullParse;
        object = Resolve.gatherMentions(document, span);
        Vector<Annotation> vector2 = Resolve.gatherClauses(document, span);
        MaxEntResolve.references(document, span, (Vector)object, vector2);
    }

    public static void references(Document document, Span span, Vector vector, Vector vector2) {
        entities = document.annotationsOfType("entity");
        if (entities == null) {
            entities = new Vector();
            speakerEntity = null;
        }
        mentionToEntity = new HashMap();
        if (trace) {
            Console.println("Resolving references");
        }
        Resolve.sentenceSet = sentenceSet = new SentenceSet(document);
        Resolve.markMentions(vector);
        syntacticAntecedent = Resolve.gatherSyntacticCoref(document, vector, vector2);
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            MaxEntResolve.resolveMention(document, annotation);
        }
        Resolve.updateEvents(document, span, mentionToEntity);
    }

    public static void train(String string, String string2, int n) throws IOException {
        String string3;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        int n2 = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing file " + ++n2 + ": " + string3);
            String string4 = string + "/" + string3;
            ExternalDocument externalDocument = new ExternalDocument("sgml", string4);
            externalDocument.setAllTags(true);
            externalDocument.open();
            Control.processDocument(externalDocument, null, false, 0);
            Ace.tagReciprocalRelations(externalDocument);
            MaxEntResolve.train(externalDocument);
            if (n2 < n) continue;
            break;
        }
    }

    public static void train(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("sentence");
        if (vector == null) {
            System.err.println("Cannot train reference resolution:  no sentences.");
            return;
        }
        entities = new Vector();
        mentionToEntity = new HashMap();
        Resolve.sentenceSet = sentenceSet = new SentenceSet(document);
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            Resolve.fullParse = fullParse = annotation.get("parse") != null;
            parseTree = (Annotation)annotation.get("parse");
            parents = SynFun.collectParents(parseTree);
            Vector<Annotation> vector2 = Resolve.gatherMentions(document, annotation.span());
            Vector<Annotation> vector3 = Resolve.gatherClauses(document, annotation.span());
            Resolve.markMentions(vector2);
            syntacticAntecedent = Resolve.gatherSyntacticCoref(document, vector2, vector3);
            for (int j = 0; j < vector2.size(); ++j) {
                Annotation annotation2 = vector2.get(j);
                MaxEntResolve.trainOnMention(document, annotation2);
            }
        }
    }

    public static void trainOnMention(Document document, Annotation annotation) {
        ArrayList<Annotation> arrayList = null;
        if (fullParse) {
            arrayList = Hobbs.collectAntecedents(annotation, parents, document);
        }
        Annotation annotation2 = Resolve.getHeadC(annotation);
        String string = (String)annotation2.get("cat");
        Vector<Annotation> vector = document.annotationsEndingAt(annotation2.end(), "mention");
        if (vector == null || vector.isEmpty()) {
            return;
        }
        Annotation annotation3 = vector.get(0);
        String string2 = (String)annotation3.get("entity");
        if (string2 == null) {
            System.err.println("mention tag for '" + document.text(annotation2) + "' has no entity feature");
            return;
        }
        int n = annotation.span().start();
        String string3 = SynFun.getHead(document, annotation);
        if (string3 == null) {
            return;
        }
        String[] stringArray = Resolve.getNameTokens(document, annotation);
        boolean bl = stringArray != null;
        boolean bl2 = false;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = annotation.get("cat") != "np";
            if (bl3 && Ace.gazetteer.isNationality(stringArray)) {
                bl2 = true;
            }
            stringArray = Resolve.normalizeGazName(stringArray, bl3, trace);
        }
        Annotation annotation4 = null;
        for (int i = 0; i < entities.size(); ++i) {
            boolean bl5 = false;
            Annotation annotation5 = (Annotation)entities.elementAt(i);
            boolean bl6 = string2.equals(annotation5.get("eid"));
            if (!bl) {
                if (string == "pro" || string == "det" || string == "np") {
                    String string4 = string3.toLowerCase().intern();
                    MaxEntResolve.trainPronounResolver(document, annotation, string4, annotation5, bl6, fullParse, arrayList);
                } else if (string != "n" && string != "adj" && string != "ven" && string != "v" && string != "tv" && string != "hyphword" && string != "title" && string != "nnp" && string != "nnps" && string != "adv" && string != "$" && string != "q") {
                    System.err.println("Unexpected head cat " + string + " for " + document.text(annotation));
                    break;
                }
            }
            if (!bl6) continue;
            annotation4 = annotation5;
        }
        if (annotation4 == null) {
            annotation4 = Resolve.createNewEntity(document, annotation, string3, bl2, entities);
            annotation4.put("eid", string2);
        } else {
            if (annotation4.get("properAdjective") != null && !bl2) {
                annotation4.put("properAdjective", null);
            }
            if (trace) {
                Console.println("Resolving " + document.text(annotation) + " to " + document.text(annotation4));
            }
        }
        Resolve.addMentionToEntity(document, annotation, string3, stringArray, annotation4, mentionToEntity);
    }

    private static void trainPronounResolver(Document document, Annotation annotation, String string, Annotation annotation2, boolean bl, boolean bl2, ArrayList<Annotation> arrayList) {
        boolean bl3 = Resolve.reflexives.contains(string);
        String string2 = Resolve.nominativeFormOf(string);
        if (string2 != "he" && string2 != "she" && string2 != "it" && string2 != "they") {
            return;
        }
        if (MaxEntResolve.pronounDefiniteNonCoref(string2, annotation2)) {
            if (bl) {
                System.err.println("Error in pronounDefiniteNonCoref, pronoun = " + string + ", antecedent = " + document.text(annotation2));
                ++pronounDefiniteNonCorefFailureCount;
            } else {
                ++pronounDefiniteNonCorefSuccessCount;
            }
            return;
        }
        Datum datum = MaxEntResolve.pronounFeatures(document, annotation, string2, bl3, annotation2, bl2, arrayList);
        datum.setOutcome(bl ? "T" : "F");
        int n = Resolve.distance(document, annotation2, annotation, bl2, arrayList);
        pronounModel.addEvent(datum);
    }

    private static boolean pronounDefiniteNonCoref(String string, Annotation annotation) {
        String string2 = (String)annotation.get("nameType");
        if (string2 != null) {
            string2 = string2.toUpperCase().intern();
        }
        String string3 = (String)annotation.get("ACEtype");
        boolean bl = string == "he" ? annotation.get("human") != null && annotation.get("number") == "singular" && annotation.get("gender") != "female" : (string == "she" ? annotation.get("human") != null && annotation.get("number") == "singular" && annotation.get("gender") != "male" : (string == "it" ? annotation.get("human") == null && annotation.get("number") == "singular" : annotation.get("number") == "plural" || string2 == "ORGANIZATION" || string2 == "GPE" || string3 != null && string3.equals("PERSON:Group")));
        return !bl;
    }

    private static Datum pronounFeatures(Document document, Annotation annotation, String string, boolean bl, Annotation annotation2, boolean bl2, ArrayList<Annotation> arrayList) {
        int n;
        Datum datum = new Datum();
        Annotation annotation3 = (Annotation)annotation2.get("lastMention");
        String string2 = (String)annotation3.get("cat");
        if (bl) {
            n = Hobbs.sameSimplex(annotation3, annotation, parents);
            if (bl2 && n != 0) {
                datum.addFV("reflexdist", "sameSimplex");
            } else {
                int n2 = Resolve.distance(document, annotation2, annotation, bl2, arrayList);
                if (n2 == 9998) {
                    datum.addFV("reflexdist", "sameSent");
                } else {
                    datum.addFV("reflexdist", Math.min(n2 / (useParser ? 1 : 25), 40) + "");
                }
            }
        } else {
            n = Resolve.distance(document, annotation2, annotation, bl2, arrayList);
            if (n == 9998) {
                datum.addFV("dist", "sameSent");
            } else {
                datum.addFV("dist", Math.min(n / (useParser ? 1 : 25), 40) + "");
            }
            Annotation annotation4 = Resolve.getHeadC(annotation3);
            String string3 = SynFun.getHead(document, annotation4);
            datum.addFV("heads", string3 + ":" + string);
            if (annotation3.get("subject-1") != null) {
                datum.addF("subject");
            }
            datum.addFV("lastCat", string2);
        }
        n = ((Vector)annotation2.get("mentions")).size();
        datum.addFV("prior", Math.min(n, 10) + "");
        return datum;
    }

    private static void resolveMention(Document document, Annotation annotation) {
        Object object;
        Object object2;
        ArrayList<Annotation> arrayList = null;
        if (fullParse) {
            arrayList = Hobbs.collectAntecedents(annotation, parents, document);
        }
        Annotation annotation2 = Resolve.getHeadC(annotation);
        String string = (String)annotation2.get("cat");
        int n = annotation.span().start();
        String string2 = SynFun.getHead(document, annotation);
        if (string2.equals("?") && string.equalsIgnoreCase("name") && (object2 = document.annotationsAt(n, "ENAMEX")) != null && ((Vector)object2).size() >= 1) {
            Annotation annotation3 = (Annotation)((Vector)object2).firstElement();
            FeatureSet featureSet = annotation3.attributes();
            string2 = (String)featureSet.get("TYPE");
        }
        if (string2 == null) {
            return;
        }
        object2 = Resolve.getNameTokens(document, annotation);
        boolean bl = object2 != null;
        boolean bl2 = false;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = annotation.get("cat") != "np";
            if (bl3 && Ace.gazetteer.isNationality((String[])object2)) {
                bl2 = true;
            }
            object2 = Resolve.normalizeGazName((String[])object2, bl3, trace);
        }
        Annotation annotation4 = null;
        float f = 0.0f;
        if (syntacticAntecedent.containsKey(annotation) && !Ace.perfectEntities) {
            if (trace) {
                System.out.println("Using syntactically-determined antecedent.");
            }
            if ((annotation4 = (Annotation)mentionToEntity.get(object = (Annotation)syntacticAntecedent.get(annotation))) == null) {
                System.err.println("Resolve:  syntactic antecedent not in entity");
                System.err.println("          mention:    " + document.text(annotation));
                System.err.println("          antecedent: " + document.text((Annotation)object));
            } else {
                f = 1.0f;
            }
        } else if ((string == "pro" || string == "det") && Resolve.nominativeFormOf(string2.toLowerCase()).equals("i") && speakerEntity != null) {
            annotation4 = speakerEntity;
            f = 1.0f;
        } else {
            for (int i = 0; i < entities.size(); ++i) {
                float f2;
                String string3;
                Annotation annotation5 = (Annotation)entities.elementAt(i);
                if (Ace.perfectMentions & !Ace.perfectEntities) {
                    string3 = (String)annotation5.get("typeSubtype");
                    String string4 = PerfectAce.getTypeSubtype(annotation2);
                    if (string3 != null && string4 != null && !string4.equals("") && !string4.equals(string3)) continue;
                }
                if (Ace.perfectEntities) {
                    string3 = PerfectAce.getEntityID(annotation2);
                    boolean bl5 = annotation5.get("entityID") != null && annotation5.get("entityID").equals(string3);
                    f2 = bl5 ? 1.0f : 0.0f;
                } else if (bl) {
                    int n2 = Resolve.matchName((String[])object2, string2, annotation5);
                    boolean bl6 = n2 >= 0;
                    f2 = bl6 ? 1000.0f / (float)(1000 + Resolve.distance(document, annotation5, annotation, fullParse, arrayList)) : 0.0f;
                } else {
                    if (annotation5 == speakerEntity) continue;
                    if (string == "pro" || string == "det" || string == "np") {
                        string3 = string2.toLowerCase().intern();
                        f2 = MaxEntResolve.matchPronoun(document, annotation, string3, annotation5, fullParse, arrayList);
                    } else if (string == "n" || string == "adj" || string == "ven" || string == "v" || string == "tv" || string == "hyphword" || string == "title" || string == "nnp" || string == "nnps" || string == "adv") {
                        boolean bl7 = Resolve.matchNom(document, annotation, annotation5);
                        f2 = bl7 ? 1000.0f / (float)(1000 + Resolve.distance(document, annotation5, annotation, fullParse, arrayList)) : 0.0f;
                    } else if (string == "$") {
                        f2 = 0.0f;
                    } else if (string == "q") {
                        f2 = 0.0f;
                    } else {
                        System.err.println("Unexpected head cat " + string + " for " + document.text(annotation));
                        f2 = 0.0f;
                        break;
                    }
                }
                if (!(f2 > f)) continue;
                f = f2;
                annotation4 = annotation5;
            }
        }
        if ((double)f < 0.01) {
            annotation4 = Resolve.createNewEntity(document, annotation, string2, bl2, entities);
        } else {
            if (annotation4.get("properAdjective") != null && !bl2) {
                annotation4.put("properAdjective", null);
            }
            if (trace) {
                Console.println("Resolving " + document.text(annotation) + " to " + document.text(annotation4));
            }
        }
        Resolve.addMentionToEntity(document, annotation, string2, (String[])object2, annotation4, mentionToEntity);
        object = annotation.span();
        if (HMMNameTagger.inZone(document, (Span)object, "POSTER") || HMMNameTagger.inZone(document, (Span)object, "SPEAKER")) {
            speakerEntity = annotation4;
        }
    }

    public static float matchPronoun(Document document, Annotation annotation, String string, Annotation annotation2, boolean bl, ArrayList<Annotation> arrayList) {
        if (annotation2.get("properAdjective") != null) {
            return 0.0f;
        }
        String string2 = Resolve.nominativeFormOf(string);
        if (string2 == "I" || string2 == "i" || string2 == "we" || string2 == "you") {
            return string2.equals(annotation2.get("head")) ? 1.0f : 0.0f;
        }
        if (string2 != "he" && string2 != "she" && string2 != "it" && string2 != "they") {
            return 0.0f;
        }
        if (MaxEntResolve.pronounDefiniteNonCoref(string2, annotation2)) {
            return 0.0f;
        }
        boolean bl2 = Resolve.reflexives.contains(string);
        Datum datum = MaxEntResolve.pronounFeatures(document, annotation, string2, bl2, annotation2, bl, arrayList);
        return (float)pronounModel.prob(datum, "T");
    }

    public static void main(String[] stringArray) throws IOException {
        if (useParser) {
            JetTest.initializeFromConfig("props/ace 05 use parses noresolve.properties");
        } else {
            JetTest.initializeFromConfig("props/ME ace 05 noresolve.properties");
        }
        pronounModel = useParser ? new MaxEntModel("data/pronounCorefFeaturesP.txt", "data/pronounCorefModelP.txt") : new MaxEntModel("data/pronounCorefFeatures.txt", "data/pronounCorefModel.txt");
        EDTtype.readTypeDict();
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        trace = false;
        if (useParser) {
            MaxEntResolve.train(trainingDirectoryParses, trainingCollectionParses, 300);
        } else {
            MaxEntResolve.train(trainingDirectory, trainingCollection, 300);
        }
        pronounModel.buildModel();
        pronounModel.saveModel();
        System.out.println("pronounDefiniteNonCorefSuccessCount = " + pronounDefiniteNonCorefSuccessCount);
        System.out.println("pronounDefiniteNonCorefFailureCount = " + pronounDefiniteNonCorefFailureCount);
    }

    static {
        fullParse = false;
        linkAppositesAndPredComps = true;
        nameTypeMatch = false;
        speakerEntity = null;
        trace = true;
        parseTree = null;
        parents = null;
        pronounDefiniteNonCorefSuccessCount = 0;
        pronounDefiniteNonCorefFailureCount = 0;
        trainingDirectory1 = "coref";
        trainingCollection1 = "coref/training nwire coref.txt";
        trainingDirectory = "coref/2005-co";
        trainingCollection = "coref/2005-co/bcbnnwCo.txt";
        trainingDirectoryParses = "coref/2005-co-parsed";
        trainingCollectionParses = "coref/2005-co/bcbnnwCo.txt";
        useParser = true;
    }
}

