/*
 * Decompiled with CFR 0.152.
 */
package Jet.Parser;

import Jet.Parser.SynFun;
import Jet.Parser.SyntacticRelation;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class SyntacticRelationSet {
    ArrayList relations = new ArrayList();
    public static String[] relationTypes = new String[]{"of", "on", "in", "to", "by", "at", "through", "for", "with", "subject", "object", "poss", "nameMod"};
    public static HashMap nomVmap = new HashMap();
    public static boolean usePA = true;
    public static boolean useBaseForm = true;
    static final int GLARF_TUPLE_SIZE = 25;
    static final int GLARF_LOGICAL_ROLE = 0;
    static final int GLARF_PA_ROLE = 2;
    static final int GLARF_TRANSPARENT = 4;
    static final int GLARF_FUNCTOR = 5;
    static final int GLARF_FUNCTOR_OFFSET = 6;
    static final int GLARF_FUNCTOR_BASE_FORM = 9;
    static final int GLARF_FUNCTOR_VERB_FOR_NOM = 10;
    static final int GLARF_ARG = 17;
    static final int GLARF_ARG_OFFSET = 18;
    static final int GLARF_ARG_BASE_FORM = 21;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/";
    static final String outputDir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/sents/";

    public void addRelations(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = vector.elementAt(i);
                for (int j = 0; j < relationTypes.length; ++j) {
                    String string = relationTypes[j];
                    if (annotation.get(string) == null) continue;
                    Annotation annotation2 = (Annotation)annotation.get(string);
                    Annotation annotation3 = annotation.get("mainV") != null ? (Annotation)annotation.get("mainV") : Resolve.getHeadC(annotation);
                    String string2 = SynFun.getHead(document, annotation3);
                    Annotation annotation4 = Resolve.getHeadC(annotation2);
                    String string3 = SynFun.getHead(document, annotation4);
                    SyntacticRelation syntacticRelation = new SyntacticRelation(annotation3.start(), string2, string, annotation4.start(), string3);
                    this.relations.add(syntacticRelation);
                    SyntacticRelation syntacticRelation2 = new SyntacticRelation(annotation4.start(), string3, string + "-1", annotation3.start(), string2);
                    this.relations.add(syntacticRelation2);
                }
            }
        }
    }

    public void add(SyntacticRelation syntacticRelation) {
        if (!this.relations.contains(syntacticRelation)) {
            this.relations.add(syntacticRelation);
        }
    }

    public void addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add((SyntacticRelation)iterator.next());
        }
    }

    public int size() {
        return this.relations.size();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SyntacticRelationSet)) {
            return false;
        }
        SyntacticRelationSet syntacticRelationSet = (SyntacticRelationSet)object;
        return this.relations.size() == syntacticRelationSet.relations.size() && this.relations.containsAll(syntacticRelationSet.relations);
    }

    public int hashCode() {
        if (this.size() == 0) {
            return 1;
        }
        return this.size() + this.relations.get(0).hashCode();
    }

    public SyntacticRelation get(int n) {
        return (SyntacticRelation)this.relations.get(n);
    }

    public SyntacticRelation getRelation(int n, int n2) {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation syntacticRelation = (SyntacticRelation)this.relations.get(i);
            if (syntacticRelation.sourcePosn != n || syntacticRelation.targetPosn != n2) continue;
            return syntacticRelation;
        }
        return null;
    }

    public SyntacticRelation getRelation(int n, String string) {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation syntacticRelation = (SyntacticRelation)this.relations.get(i);
            if (syntacticRelation.sourcePosn != n || !syntacticRelation.type.equalsIgnoreCase(string)) continue;
            return syntacticRelation;
        }
        return null;
    }

    public SyntacticRelationSet getRelationsFrom(int n) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation syntacticRelation = (SyntacticRelation)this.relations.get(i);
            if (syntacticRelation.sourcePosn != n) continue;
            syntacticRelationSet.add(syntacticRelation);
        }
        return syntacticRelationSet;
    }

    public SyntacticRelation getRelationTo(int n) {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation syntacticRelation = (SyntacticRelation)this.relations.get(i);
            if (syntacticRelation.targetPosn != n) continue;
            return syntacticRelation;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation syntacticRelation = (SyntacticRelation)this.relations.get(i);
            stringBuffer.append(syntacticRelation.toString());
            if (i >= this.relations.size() - 1) continue;
            stringBuffer.append(this.relations.size() > 3 ? "\n " : "; ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void write(PrintWriter printWriter) {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation syntacticRelation = (SyntacticRelation)this.relations.get(i);
            printWriter.println(syntacticRelation.type + " | " + syntacticRelation.sourceWord + " | " + syntacticRelation.sourcePosn + " | " + syntacticRelation.targetWord + " | " + syntacticRelation.targetPosn);
        }
    }

    public void readRelations(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith(";")) continue;
                String[] stringArray = string2.split(" \\| ");
                if (stringArray.length != 25) {
                    System.out.println("Invalid input line (" + stringArray.length + " fields): " + string2);
                    continue;
                }
                try {
                    SyntacticRelation syntacticRelation;
                    String string3 = stringArray[0].trim();
                    if (string3.equals("RELATIVE") || string3.equals("RED-RELATIVE")) continue;
                    String string4 = stringArray[2].trim();
                    String string5 = useBaseForm ? stringArray[9].trim().toLowerCase() : stringArray[5].trim();
                    int n = Integer.parseInt(stringArray[6].trim());
                    String string6 = stringArray[10].trim().toLowerCase();
                    String string7 = useBaseForm ? stringArray[21].trim().toLowerCase() : stringArray[17].trim();
                    int n2 = Integer.parseInt(stringArray[18].trim());
                    if (!string3.equals("NIL")) {
                        syntacticRelation = new SyntacticRelation(n, string5, string3, n2, string7);
                        boolean bl = stringArray[4].equals("T");
                        if (bl) {
                            syntacticRelation.setTransparent(true);
                        }
                        this.add(syntacticRelation);
                    }
                    if (!string4.equals("NIL") && !string4.equals("SUPPORT")) {
                        syntacticRelation = new SyntacticRelation(n, string5, string4, n2, string7);
                        this.add(syntacticRelation);
                    }
                    if (string6.equals("nil")) continue;
                    nomVmap.put(string5 + "/n", string6);
                    nomVmap.put(string6, string5 + "/n");
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid input line: " + string2);
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("readRelations error: " + iOException);
        }
        this.bypassTransparentLinks();
        this.addInverses();
    }

    private void bypassTransparentLinks() {
        for (int i = 0; i < this.relations.size(); ++i) {
            SyntacticRelation syntacticRelation = (SyntacticRelation)this.relations.get(i);
            String string = syntacticRelation.type;
            if (!string.equals("ARG0") && !string.equals("ARG1") && !string.equals("ARG2") && !string.equals("SBJ") && !string.equals("OBJ") || !syntacticRelation.targetWord.equals("of") && !syntacticRelation.targetWord.equals("by")) continue;
            int n = syntacticRelation.targetPosn;
            for (int j = 0; j < this.relations.size(); ++j) {
                SyntacticRelation syntacticRelation2 = (SyntacticRelation)this.relations.get(j);
                if (i == j || syntacticRelation.targetPosn != syntacticRelation2.sourcePosn || !syntacticRelation2.type.equals("OBJ") || !syntacticRelation2.transparent) continue;
                syntacticRelation.targetWord = syntacticRelation2.targetWord;
                syntacticRelation.targetPosn = syntacticRelation2.targetPosn;
            }
        }
    }

    private void addInverses() {
        int n = this.relations.size();
        for (int i = 0; i < n; ++i) {
            SyntacticRelation syntacticRelation = (SyntacticRelation)this.relations.get(i);
            SyntacticRelation syntacticRelation2 = new SyntacticRelation(syntacticRelation.targetPosn, syntacticRelation.targetWord, syntacticRelation.type + "-1", syntacticRelation.sourcePosn, syntacticRelation.sourceWord);
            this.add(syntacticRelation2);
        }
    }

    public static void main(String[] stringArray) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        syntacticRelationSet.readRelations("C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/sents/nw/AFP_ENG_20030323.0020.sent.txt.acetrip90");
        System.out.println(syntacticRelationSet.toString());
    }
}

