/*
 * Decompiled with CFR 0.152.
 */
package Jet;

import AceJet.Ace;
import AceJet.Gazetteer;
import Jet.Chunk.Chunker;
import Jet.Chunk.MENameTagger;
import Jet.Chunk.MaxEntNE;
import Jet.Concepts.ConceptHierarchy;
import Jet.Console;
import Jet.Control;
import Jet.HMM.BIOWriter;
import Jet.HMM.HMMNameTagger;
import Jet.HMM.HMMTagger;
import Jet.HMM.WordFeatureHMMemitter;
import Jet.JarDate;
import Jet.Lex.EnglishLex;
import Jet.Lex.Lexicon;
import Jet.NE.Dictionary;
import Jet.NE.NameAnnotator;
import Jet.NE.RuleFormatException;
import Jet.NE.TrieDictionary;
import Jet.Parser.Grammar;
import Jet.Parser.StatParser;
import Jet.Pat.Pat;
import Jet.Pat.PatternCollection;
import Jet.Refres.CorefEval;
import Jet.Refres.EntityView;
import Jet.Refres.Resolve;
import Jet.Scorer.NameTagger;
import Jet.Scorer.SGMLProcessor;
import Jet.Time.NumberAnnotator;
import Jet.Time.TimeAnnotator;
import Jet.Tipster.AnnotationColor;
import Jet.Tipster.CollectionAnnotationTool;
import Jet.Tipster.CollectionView;
import Jet.Tipster.Document;
import Jet.Tipster.View;
import Jet.Util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JetTest {
    public static boolean batchFlag = false;
    protected static Properties defaultConfig = new Properties();
    protected static Properties config = null;
    private static File configFile;
    protected static String dataPath;
    public static PatternCollection pc;
    public static File patternFile;
    protected static Grammar gram;
    public static HMMTagger tagger;
    public static NameTagger nameTagger;
    protected static Vector views;
    public static ConceptHierarchy conceptHierarchy;
    public static File conceptHierarchyFile;
    public static String encoding;
    public static String docId;
    public static NameAnnotator extendedNameTagger;
    private static TimeAnnotator timeAnnotator;
    private static DateTime referenceTime;
    private static DateTimeFormatter referenceTimeFormat;
    private static NumberAnnotator numberAnnotator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeFromConfig(File file, String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            config.load(fileInputStream);
            batchFlag = config.getProperty("Jet.batch") != null;
            String string2 = config.getProperty("Jet.dataPath");
            dataPath = string2 == null ? (string == null || string.equals("") ? "." : string) : (string == null || string.equals("") || new File(string2).isAbsolute() ? string2 : string + File.separatorChar + string2);
            if (!batchFlag) {
                new AnnotationColor(dataPath);
            }
            JetTest.initialize();
            System.err.println("Jet Ver. 1.6.6.  Portions (c) 1999-2012 R. Grishman");
            JarDate.print(System.err);
            System.err.println("License granted for use in education, research, and US Government purposes.");
        }
        catch (IOException iOException) {
            try {
                System.err.println("Error: could not open file " + file);
                System.err.println("USAGE: JetTest <configFile>");
                System.exit(1);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(fileInputStream);
        }
        IOUtils.closeQuietly(fileInputStream);
    }

    public static void initializeFromConfig(String string, String string2) {
        JetTest.initializeFromConfig(new File(string), string2);
    }

    public static void initializeFromConfig(File file) {
        JetTest.initializeFromConfig(file, System.getProperty("jetHome"));
    }

    public static void initializeFromConfig(String string) {
        JetTest.initializeFromConfig(string, System.getProperty("jetHome"));
    }

    public static String getConfig(String string) {
        return config.getProperty(string);
    }

    public static String getConfigFile(String string) {
        String string2 = config.getProperty(string);
        if (string2 == null || new File(string2).isAbsolute()) {
            return string2;
        }
        return dataPath + File.separatorChar + string2;
    }

    public static void initialize() {
        if (config.getProperty("Jet.encoding") != null) {
            JetTest.setEncoding(config.getProperty("Jet.encoding"));
        }
        JetTest.readLexicons();
        JetTest.readTags();
        JetTest.readNameTags();
        JetTest.readPatterns();
        JetTest.readGrammar();
        JetTest.readChunkModel();
        if (config.getProperty("StatParser.grammar.fileName") != null) {
            StatParser.initialize(dataPath, config);
        }
        Resolve.readGenderDict(dataPath, config);
        JetTest.readConcepts();
        JetTest.readGazetteer();
        JetTest.readENEData();
        JetTest.initTimex();
        String string = config.getProperty("Resolve.trace");
        if (string != null) {
            if (string.equals("on")) {
                Resolve.trace = true;
            } else if (string.equals("off")) {
                Resolve.trace = false;
            } else {
                System.err.println("*** Invalid value " + string + " for Resolve.trace " + "(should be 'on' or 'off')");
            }
        }
        Resolve.useMaxEnt = config.getProperty("Resolve.useMaxEnt") != null;
    }

    public static void readLexicons() {
        Lexicon.clear();
        for (String string : config.keySet()) {
            if (!string.startsWith("EnglishLex.fileName")) continue;
            String string2 = config.getProperty(string);
            try {
                EnglishLex.readLexicon(dataPath, string2);
            }
            catch (IOException iOException) {
                System.err.println("Error: reading lexicon file " + string2 + ", " + iOException.getMessage());
            }
        }
    }

    public static void readTags() {
        String string = config.getProperty("Tags.fileName");
        if (string != null) {
            try {
                tagger = new HMMTagger();
                tagger.load(dataPath + File.separatorChar + string);
            }
            catch (IOException iOException) {
                System.err.println("Error: reading tag file " + string + ", " + iOException.getMessage());
            }
        }
    }

    public static void readNameTags() {
        String string;
        String string2 = JetTest.getConfigFile("NameTags.fileName");
        String string3 = JetTest.getConfigFile("NameTags.ME.fileName");
        if (string2 != null) {
            try {
                Class<Object> clazz;
                string = config.getProperty("NameTags.emitter", "Jet.HMM.WordFeatureHMMemitter");
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Unknown HMM emitter class " + string);
                    System.err.println("Using class WordFeatureHMMemitter");
                    clazz = WordFeatureHMMemitter.class;
                }
                nameTagger = new HMMNameTagger(clazz);
                nameTagger.load(string2);
                if (config.getProperty("NameTags.trace") != null) {
                    NameTagger.annotator.setTrace(true);
                }
                if (config.getProperty("NameTags.recordMargin") != null) {
                    NameTagger.annotator.setRecordMargin(true);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error: reading name tag file " + string2 + ", " + iOException.getMessage());
            }
        } else if (string3 != null) {
            try {
                nameTagger = new MENameTagger();
                nameTagger.load(string3);
            }
            catch (IOException iOException) {
                System.err.println("Error: reading name tag file " + string3 + ", " + iOException.getMessage());
            }
        }
        if ((string = JetTest.getConfigFile("WordClusters.fileName")) != null) {
            try {
                MaxEntNE.loadWordClusters(string);
            }
            catch (IOException iOException) {
                System.err.println("Error: reading cluster file " + string + ", " + iOException.getMessage());
            }
        }
    }

    public static void readPatterns() {
        pc = new PatternCollection();
        for (String string2 : config.keySet()) {
            if (!string2.startsWith("Pattern.fileName")) continue;
            String string = config.getProperty(string2);
            try {
                patternFile = new File(string);
                if (!patternFile.isAbsolute()) {
                    patternFile = new File(dataPath, string);
                }
                pc.readPatternCollection(new BufferedReader(new FileReader(patternFile)));
            }
            catch (IOException iOException) {
                System.err.println("Error: reading pattern file " + string + ", " + iOException.getMessage());
            }
        }
        pc.makePatternGraph();
        String string = config.getProperty("Pattern.trace");
        if (string != null) {
            if (string.equals("on")) {
                Pat.trace = true;
            } else if (string.equals("off")) {
                Pat.trace = false;
            } else {
                System.err.println("*** Invalid value " + string + " for Pattern.trace " + "(should be 'on' or 'off')");
            }
        }
    }

    public static void readGrammar() {
        String string = config.getProperty("Grammar.fileName");
        if (string != null) {
            try {
                gram = new Grammar(new BufferedReader(new FileReader(dataPath + File.separatorChar + string)));
            }
            catch (IOException iOException) {
                System.err.println("Error: reading grammar file " + string + ", " + iOException.getMessage());
            }
        }
    }

    public static void readChunkModel() {
        String string = config.getProperty("Chunker.fileName");
        if (string != null) {
            Chunker.loadModel(dataPath + File.separatorChar + string);
        }
    }

    public static void readConcepts() {
        String string = config.getProperty("Concepts.fileName");
        if (string == null) {
            conceptHierarchyFile = null;
            conceptHierarchy = new ConceptHierarchy();
        } else {
            conceptHierarchyFile = new File(dataPath + File.separatorChar + string);
            conceptHierarchy = new ConceptHierarchy(conceptHierarchyFile);
        }
    }

    public static void readGazetteer() {
        if (config.getProperty("Gazetteer.fileName") != null) {
            try {
                Ace.gazetteer = new Gazetteer();
                Ace.gazetteer.load();
            }
            catch (IOException iOException) {
                System.err.println("Error reading gazetteer: " + iOException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void readENEData() {
        Object object;
        File file;
        Object object2;
        String string = config.getProperty("ENE.dict.trie");
        String string2 = config.getProperty("ENE.dict.cdb");
        if (string != null && string2 != null) {
            try {
                object2 = new File(dataPath, string);
                file = new File(dataPath, string2);
                object = new TrieDictionary(((File)object2).getPath(), file.getPath());
                extendedNameTagger.setDictionary((Dictionary)object);
            }
            catch (IOException iOException) {
                System.err.println("Error reading ENE dictionary: " + iOException.getMessage());
            }
        }
        if ((object2 = config.getProperty("ENE.rule")) != null) {
            file = new File(dataPath, (String)object2);
            object = null;
            try {
                Charset charset = Charset.forName(encoding);
                object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
                extendedNameTagger.loadRules((Reader)object);
            }
            catch (IOException iOException) {
                System.err.println("Error reading rule file: " + iOException.getMessage());
                IOUtils.closeQuietly((Closeable)object);
            }
            catch (RuleFormatException ruleFormatException) {
                System.err.println("Rule format error: " + ruleFormatException.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(object);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)object);
            }
            IOUtils.closeQuietly((Closeable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initTimex() {
        Object object;
        String string = config.getProperty("Timex.rule");
        String string2 = config.getProperty("Timex.refTime");
        String string3 = config.getProperty("Timex.refFormat");
        if (string != null) {
            object = new File(dataPath, string);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream((File)object);
                timeAnnotator.load(fileInputStream);
            }
            catch (IOException iOException) {
                try {
                    System.err.println("Error reading rule file: " + iOException.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly(fileInputStream);
            }
            IOUtils.closeQuietly(fileInputStream);
        }
        if (string2 != null) {
            object = ISODateTimeFormat.dateTimeParser();
            referenceTime = ((DateTimeFormatter)object).parseDateTime(string2);
        }
        if (string3 != null) {
            referenceTimeFormat = DateTimeFormat.forPattern(string3);
        }
    }

    public static DateTime getReferenceTime() {
        return referenceTime;
    }

    public static void setReferenceTime(DateTime dateTime) {
        referenceTime = dateTime;
    }

    public static DateTimeFormatter getReferenceTimeFormat() {
        return referenceTimeFormat;
    }

    public static TimeAnnotator getTimeAnnotator() {
        return timeAnnotator;
    }

    public static NumberAnnotator getNumberAnnotator() {
        return numberAnnotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processFile(String string, boolean bl) throws IOException {
        long l = System.currentTimeMillis();
        File file = new File(string).isAbsolute() ? new File(string) : new File(dataPath, string);
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            Serializable serializable;
            Charset charset = Charset.forName(encoding);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            if (config.getProperty("WriteSGML.type") != null) {
                serializable = new File(file.getParent(), "response-" + file.getName());
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)serializable), encoding));
            }
            int n = 0;
            while ((serializable = JetTest.readDocument(bufferedReader)) != null) {
                String string2 = config.getProperty("ReadSGML.type");
                if (string2 != null) {
                    String[] stringArray = string2.split("\\s*,\\s*");
                    serializable = SGMLProcessor.sgmlToDoc(((Document)serializable).text(), stringArray);
                    ((Document)serializable).stretchAll();
                }
                Control.processDocument((Document)serializable, bufferedWriter, bl, ++n);
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            IOUtils.closeQuietly(bufferedWriter);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedReader);
        IOUtils.closeQuietly(bufferedWriter);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.err.println("Processing of file " + string + " took " + l3 + " ms");
    }

    public static void processFiles(boolean bl) {
        for (String string : config.keySet()) {
            if (!string.startsWith("JetTest.fileName")) continue;
            String string2 = config.getProperty(string);
            try {
                JetTest.processFile(string2, bl);
            }
            catch (IOException iOException) {
                System.err.println("Error: could not process document file " + string2 + ", " + iOException.getMessage());
            }
        }
    }

    public static void closeAllViews() {
        for (int i = 0; i < views.size(); ++i) {
            ((View)views.get(i)).dispose();
        }
        views.clear();
    }

    public static Document readDocument(BufferedReader bufferedReader) throws IOException {
        int n;
        String string;
        do {
            if ((string = bufferedReader.readLine()) != null) continue;
            return null;
        } while (!string.startsWith("<DOC"));
        Document document = new Document();
        document.append(string);
        document.append("\n");
        int n2 = string.indexOf("id=\"");
        if (n2 > 0 && (n = string.indexOf("\"", n2 += 4)) > 0) {
            docId = string.substring(n2, n);
        }
        do {
            if ((string = bufferedReader.readLine()) == null) {
                System.err.println("no </DOC>");
                return null;
            }
            if (string.startsWith("<DOCID>") && string.trim().endsWith("</DOCID>")) {
                String string2 = string.trim();
                docId = string2.substring(7, string2.length() - 8).trim();
            }
            document.append(string);
            document.append("\n");
        } while (!string.trim().equals("</DOC>"));
        return document;
    }

    public static boolean setEncoding(String string) {
        try {
            if (Charset.isSupported(string)) {
                encoding = string;
                return true;
            }
            System.err.println("Character set " + string + " is not supported.");
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            System.err.println(string + " is an illegal character set name.");
        }
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Iterator<String> iterator = sortedMap.keySet().iterator();
        System.err.println("Supported character sets are:");
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            Charset charset = (Charset)sortedMap.get(string2);
            System.err.println("  " + string2 + " " + charset.aliases());
        }
        System.err.println(" ");
        return false;
    }

    static boolean hasDisplay() {
        try {
            new JFrame();
            return true;
        }
        catch (InternalError internalError) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0 && ((String)(object = stringArray[0])).length() > 0 && ((String)object).charAt(0) == '-') {
            if (((String)object).equals("-AnnotateCollection")) {
                CollectionAnnotationTool.task(stringArray);
                return;
            }
            if (((String)object).equals("-CorefEval")) {
                CorefEval.task(stringArray);
                System.exit(0);
            } else if (((String)object).equals("-BIOWriter")) {
                BIOWriter.task(stringArray);
                System.exit(0);
            } else {
                if (((String)object).equals("-CorefView")) {
                    EntityView.task(stringArray);
                    return;
                }
                if (((String)object).equals("-CollectionView")) {
                    CollectionView.task(stringArray);
                    return;
                }
                System.err.println("Unknown Jet task: " + (String)object);
                System.exit(1);
            }
        }
        if (stringArray.length == 0) {
            if (!JetTest.hasDisplay()) {
                System.err.println("Error:  no configuration file selected.");
                System.err.println("USAGE: JetTest <configFile>");
                System.exit(1);
            }
            object = new JFileChooser();
            ((JFileChooser)object).setDialogTitle("Select Jet configuration file");
            File file = new File(System.getProperty("user.dir"), "props");
            ((JFileChooser)object).setCurrentDirectory(file);
            int n = ((JFileChooser)object).showOpenDialog(null);
            if (n == 0) {
                configFile = ((JFileChooser)object).getSelectedFile();
            } else {
                System.err.println("Error:  no configuration file selected.");
                System.exit(1);
            }
        } else {
            configFile = new File(stringArray[0]);
            if (stringArray.length > 1) {
                System.err.println("Warning:  extra command line arguments ignored.");
            }
        }
        JetTest.initializeFromConfig(configFile);
        if (batchFlag) {
            JetTest.processFiles(false);
        } else {
            new Console();
        }
    }

    static {
        views = new Vector();
        encoding = "ISO-8859-1";
        docId = "";
        extendedNameTagger = new NameAnnotator();
        timeAnnotator = new TimeAnnotator();
        numberAnnotator = new NumberAnnotator();
        defaultConfig.put("processDocument", "tag(TEXT), TEXT:processTextZone");
        defaultConfig.put("processTextZone", "sentenceSplit, sentence:processSentence");
        config = new Properties(defaultConfig);
    }
}

