/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEvent;
import AceJet.AceEventAnchor;
import AceJet.AceEventArgument;
import AceJet.AceEventArgumentValue;
import AceJet.AceEventMention;
import AceJet.AceEventMentionArgument;
import AceJet.AceMention;
import AceJet.AcePatternNode;
import AceJet.ChunkPath;
import AceJet.EventPatternArgument;
import AceJet.EventSyntacticPattern;
import AceJet.Gazetteer;
import AceJet.PatternEvaluation;
import Jet.Control;
import Jet.JetTest;
import Jet.Parser.SynFun;
import Jet.Parser.SyntacticRelation;
import Jet.Parser.SyntacticRelationSet;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;

public class EventPattern {
    String patternType;
    ArrayList nodes = new ArrayList();
    ArrayList[] roles;
    ArrayList<ChunkPath> paths = null;
    SyntacticRelationSet syntax = null;
    int anchorPosn;
    String anchor;
    String eventType;
    String eventSubtype;
    ArrayList eventArgs = new ArrayList();
    PatternEvaluation evaluation = new PatternEvaluation();
    static boolean useChunkPatterns = true;
    public int matchScore = 0;
    private int chunkMatchScore = 0;
    int syntaxMatchScore = 0;
    int MIN_MATCH_SCORE = 0;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ace = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/";
    static final String triplesDir = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/011306-fast-tuples/";
    static final String triplesSuffix = ".sent.txt.ns-2005-fast-ace-n-tuple92";

    EventPattern(String string, Document document, SyntacticRelationSet syntacticRelationSet, AceEvent aceEvent, AceEventMention aceEventMention) {
        int n;
        int n2;
        int n3;
        AceMention aceMention;
        int n4;
        this.patternType = string;
        if (string == "CHUNK") {
            this.paths = new ArrayList();
        } else if (string == "SYNTAX" || string == "PA") {
            this.syntax = new SyntacticRelationSet();
        } else {
            System.err.println("Invalid patternType " + string + " in EventPattern constructor.");
            return;
        }
        ArrayList<AceEventMentionArgument> arrayList = aceEventMention.arguments;
        ArrayList<AceEventMentionArgument> arrayList2 = new ArrayList<AceEventMentionArgument>(arrayList);
        ArrayList<AceMention> arrayList3 = new ArrayList<AceMention>();
        int[] nArray = new int[arrayList2.size()];
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            AceMention aceMention2 = arrayList2.get((int)n4).value;
            if (arrayList3.contains(aceMention2)) {
                nArray[n4] = arrayList3.indexOf(aceMention2);
                continue;
            }
            nArray[n4] = arrayList3.size();
            arrayList3.add(aceMention2);
        }
        for (n4 = 0; n4 < arrayList3.size() - 1; ++n4) {
            for (int i = n4 + 1; i < arrayList3.size(); ++i) {
                AceMention aceMention3 = (AceMention)arrayList3.get(n4);
                aceMention = (AceMention)arrayList3.get(i);
                if (aceMention3.jetExtent.start() <= aceMention.jetExtent.start()) continue;
                arrayList3.set(n4, aceMention);
                arrayList3.set(i, aceMention3);
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (nArray[n3] == n4) {
                        nArray[n3] = i;
                        continue;
                    }
                    if (nArray[n3] != i) continue;
                    nArray[n3] = n4;
                }
            }
        }
        Span span = aceEventMention.anchorJetExtent;
        String string2 = aceEventMention.anchorText;
        this.anchorPosn = -1;
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            aceMention = (AceMention)arrayList3.get(n2);
            if (aceMention.getJetHead().start() <= span.start()) continue;
            this.anchorPosn = n2;
            arrayList3.add(n2, null);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] < this.anchorPosn) continue;
                int n5 = n3;
                nArray[n5] = nArray[n5] + 1;
            }
            break;
        }
        if (this.anchorPosn < 0) {
            this.anchorPosn = arrayList3.size();
            arrayList3.add(null);
        }
        this.anchor = EventPattern.normalizedAnchor(span, string2, document, syntacticRelationSet);
        n2 = 0;
        aceMention = null;
        AceMention aceMention4 = null;
        int[] nArray2 = new int[arrayList3.size()];
        for (n = 0; n < arrayList3.size(); ++n) {
            if (n == this.anchorPosn) {
                aceMention = new AceEventAnchor(aceEventMention.anchorExtent, aceEventMention.anchorJetExtent, aceEventMention.anchorText, document);
                nArray2[n] = span.start();
                this.nodes.add(null);
            } else {
                aceMention = (AceMention)arrayList3.get(n);
                nArray2[n] = n2 = aceMention.getJetHead().start();
                this.nodes.add(new AcePatternNode(aceMention));
            }
            if (n > 0 && string == "CHUNK") {
                ChunkPath chunkPath = new ChunkPath(document, aceMention4, aceMention);
                if (chunkPath == null) {
                    System.err.println("EventPattern:  unable to build chunk path.");
                }
                this.paths.add(chunkPath);
            }
            aceMention4 = aceMention;
        }
        if (string == "SYNTAX" || string == "PA") {
            this.syntax = EventSyntacticPattern.buildPattern(string, span.start(), nArray2, syntacticRelationSet);
        }
        this.eventType = aceEvent.type;
        this.eventSubtype = aceEvent.subtype;
        this.roles = new ArrayList[this.nodes.size()];
        for (n = 0; n < this.roles.length; ++n) {
            this.roles[n] = new ArrayList();
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            int n6 = nArray[n];
            AceEventMentionArgument aceEventMentionArgument = arrayList2.get(n);
            String string3 = aceEventMentionArgument.role;
            this.eventArgs.add(new EventPatternArgument(string3, new Integer(n6 + 1)));
            this.roles[n6].add(string3);
        }
    }

    public EventPattern(EventPattern eventPattern) {
        this.patternType = eventPattern.patternType;
        this.nodes = eventPattern.nodes;
        this.roles = eventPattern.roles;
        this.paths = eventPattern.paths;
        this.syntax = eventPattern.syntax;
        this.anchorPosn = eventPattern.anchorPosn;
        this.anchor = eventPattern.anchor;
        this.eventType = eventPattern.eventType;
        this.eventSubtype = eventPattern.eventSubtype;
        this.eventArgs = eventPattern.eventArgs;
        this.evaluation = eventPattern.evaluation;
    }

    public boolean empty() {
        return !(this.patternType != "SYNTAX" && this.patternType != "PA" || this.syntax != null && this.syntax.size() != 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventPattern)) {
            return false;
        }
        EventPattern eventPattern = (EventPattern)object;
        if (this.paths == null ? eventPattern.paths != null : !this.paths.equals(eventPattern.paths)) {
            return false;
        }
        if (this.syntax == null ? eventPattern.syntax != null : !this.syntax.equals(eventPattern.syntax)) {
            return false;
        }
        return this.nodes.equals(eventPattern.nodes) && this.anchorPosn == eventPattern.anchorPosn && this.anchor.equals(eventPattern.anchor) && this.eventType.equals(eventPattern.eventType) && this.eventSubtype.equals(eventPattern.eventSubtype) && this.eventArgs.equals(eventPattern.eventArgs);
    }

    public int hashCode() {
        return (this.anchor + this.nodes.size()).hashCode();
    }

    static String normalizedAnchor(Span span, String string, Document document, SyntacticRelationSet syntacticRelationSet) {
        int n = span.start();
        Vector<Annotation> vector = document.annotationsAt(n, "constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = vector.get(i);
                String string2 = (String)annotation.get("cat");
                if (string2 != "n" && string2 != "v" && string2 != "tv" && string2 != "ven" && string2 != "ving" && string2 != "adj") continue;
                return EventPattern.normalizedAnchor(annotation, document, syntacticRelationSet);
            }
        }
        return string;
    }

    static String normalizedAnchor(Annotation annotation, Document document, SyntacticRelationSet syntacticRelationSet) {
        String string = (String)annotation.get("cat");
        String string2 = "";
        if (string == "n") {
            return SynFun.getHead(document, annotation).toLowerCase() + string2 + "/n";
        }
        return SynFun.getHead(document, annotation).toLowerCase() + string2;
    }

    private static String getSenseOfWordAt(int n, SyntacticRelationSet syntacticRelationSet) {
        SyntacticRelationSet syntacticRelationSet2 = syntacticRelationSet.getRelationsFrom(n);
        for (int i = 0; i < syntacticRelationSet2.size(); ++i) {
            SyntacticRelation syntacticRelation = syntacticRelationSet2.get(i);
            if (syntacticRelation.type.endsWith("-1")) continue;
            return syntacticRelation.sourceWordSense;
        }
        return "1";
    }

    public AceEvent match(Span span, String string, Document document, SyntacticRelationSet syntacticRelationSet, AceDocument aceDocument) {
        if (!this.anchor.equals(string)) {
            return null;
        }
        ArrayList arrayList = this.chunkMatch(span, document, syntacticRelationSet, aceDocument);
        ArrayList arrayList2 = EventSyntacticPattern.match(this, span.start(), document, syntacticRelationSet, aceDocument);
        ArrayList arrayList3 = null;
        if (arrayList == null && arrayList2 == null) {
            return null;
        }
        if (arrayList != null && this.chunkMatchScore >= this.syntaxMatchScore) {
            arrayList3 = arrayList;
            this.matchScore = this.chunkMatchScore;
        } else {
            arrayList3 = arrayList2;
            this.matchScore = this.syntaxMatchScore;
        }
        Span span2 = this.computeExtent(span, arrayList3);
        AceEvent aceEvent = new AceEvent("id", this.eventType, this.eventSubtype);
        AceEventMention aceEventMention = new AceEventMention("id", span2, span, document.text());
        aceEvent.addMention(aceEventMention);
        for (int i = 0; i < arrayList3.size(); ++i) {
            AceEventMentionArgument aceEventMentionArgument = (AceEventMentionArgument)arrayList3.get(i);
            this.addEventMentionArgument(aceEventMention, aceEventMentionArgument.role, aceEventMentionArgument.value);
            AceEventArgumentValue aceEventArgumentValue = aceEventMentionArgument.value.getParent();
            this.addEventArgument(aceEvent, aceEventMentionArgument.role, aceEventArgumentValue);
        }
        return aceEvent;
    }

    private void addEventMentionArgument(AceEventMention aceEventMention, String string, AceMention aceMention) {
        ArrayList<AceEventMentionArgument> arrayList = aceEventMention.arguments;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventMentionArgument aceEventMentionArgument = arrayList.get(i);
            if (!aceEventMentionArgument.role.equals(string) || !aceEventMentionArgument.value.equals(aceMention)) continue;
            return;
        }
        aceEventMention.addArgument(new AceEventMentionArgument(aceMention, string));
    }

    private void addEventArgument(AceEvent aceEvent, String string, AceEventArgumentValue aceEventArgumentValue) {
        ArrayList<AceEventArgument> arrayList = aceEvent.arguments;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventArgument aceEventArgument = arrayList.get(i);
            if (!aceEventArgument.role.equals(string) || !aceEventArgument.value.equals(aceEventArgumentValue)) continue;
            return;
        }
        aceEvent.addArgument(new AceEventArgument(aceEventArgumentValue, string));
    }

    public int getMatchScore() {
        return this.matchScore;
    }

    private ArrayList chunkMatch(Span span, Document document, SyntacticRelationSet syntacticRelationSet, AceDocument aceDocument) {
        String string;
        int n;
        AceMention aceMention;
        String string2;
        ArrayList arrayList;
        AcePatternNode acePatternNode;
        ChunkPath chunkPath;
        boolean bl;
        int n2;
        AceMention aceMention2;
        int n3;
        ArrayList<AceEventMentionArgument> arrayList2 = new ArrayList<AceEventMentionArgument>();
        this.chunkMatchScore = 0;
        if (this.paths == null) {
            return null;
        }
        if (!useChunkPatterns) {
            return null;
        }
        Annotation annotation = EventPattern.containingSentence(document, span);
        if (annotation == null) {
            System.err.println("** Cannot find sentence containing trigger");
            return null;
        }
        ArrayList<AceMention> arrayList3 = aceDocument.getAllMentions();
        LinkedList<AceMention> linkedList = new LinkedList<AceMention>();
        LinkedList<AceMention> linkedList2 = new LinkedList<AceMention>();
        for (n3 = 0; n3 < arrayList3.size(); ++n3) {
            aceMention2 = arrayList3.get(n3);
            if (!aceMention2.getJetHead().within(annotation.span())) continue;
            if (aceMention2.getJetHead().start() < span.start()) {
                linkedList.add(aceMention2);
                continue;
            }
            linkedList2.add(aceMention2);
        }
        n3 = 0;
        AceMention aceMention3 = aceMention2 = new AceEventAnchor(span, span, document.text(span).trim(), document);
        for (n2 = this.anchorPosn - 1; n2 >= 0; --n2) {
            bl = false;
            chunkPath = this.paths.get(n2);
            acePatternNode = (AcePatternNode)this.nodes.get(n2);
            arrayList = this.roles[n2];
            string2 = (String)arrayList.get(0);
            while (!linkedList.isEmpty()) {
                aceMention = (AceMention)linkedList.removeLast();
                n3 = acePatternNode.match(aceMention);
                if (n3 <= this.MIN_MATCH_SCORE || !AceEventArgument.isValid(this.eventSubtype, string2, aceMention) || !new ChunkPath(document, aceMention, aceMention3).equals(chunkPath)) continue;
                this.chunkMatchScore += n3;
                for (n = 0; n < arrayList.size(); ++n) {
                    string = (String)arrayList.get(n);
                    arrayList2.add(new AceEventMentionArgument(aceMention, string));
                }
                aceMention3 = aceMention;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        aceMention3 = aceMention2;
        for (n2 = this.anchorPosn; n2 < this.nodes.size() - 1; ++n2) {
            bl = false;
            chunkPath = this.paths.get(n2);
            acePatternNode = (AcePatternNode)this.nodes.get(n2 + 1);
            arrayList = this.roles[n2 + 1];
            string2 = (String)arrayList.get(0);
            while (!linkedList2.isEmpty()) {
                aceMention = (AceMention)linkedList2.removeFirst();
                n3 = acePatternNode.match(aceMention);
                if (n3 <= this.MIN_MATCH_SCORE || !AceEventArgument.isValid(this.eventSubtype, string2, aceMention) || !new ChunkPath(document, aceMention3, aceMention).equals(chunkPath)) continue;
                this.chunkMatchScore += n3;
                for (n = 0; n < arrayList.size(); ++n) {
                    string = (String)arrayList.get(n);
                    arrayList2.add(new AceEventMentionArgument(aceMention, string));
                }
                aceMention3 = aceMention;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        return arrayList2;
    }

    private static int nonNullLength(Object[] objectArray) {
        if (objectArray == null) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            ++n;
        }
        return n;
    }

    static Annotation containingSentence(Document document, Span span) {
        Vector<Annotation> vector = document.annotationsOfType("sentence");
        Annotation annotation = null;
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation2 = vector.get(i);
            if (!span.within(annotation2.span())) continue;
            annotation = annotation2;
            break;
        }
        return annotation;
    }

    private Span computeExtent(Span span, ArrayList arrayList) {
        int n = span.start();
        int n2 = span.end();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                AceEventMentionArgument aceEventMentionArgument = (AceEventMentionArgument)arrayList.get(i);
                AceMention aceMention = aceEventMentionArgument.value;
                n = Math.min(n, aceMention.jetExtent.start());
                n2 = Math.max(n2, aceMention.jetExtent.end());
            }
        }
        return new Span(n, n2);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.nodes.size(); ++n) {
            if (n == this.anchorPosn) {
                stringBuffer.append("$" + this.anchor + "$");
            } else {
                stringBuffer.append(this.nodes.get(n));
            }
            stringBuffer.append(" ");
            if (n >= this.nodes.size() - 1) continue;
            stringBuffer.append("[" + (this.paths == null ? "" : this.paths.get(n)) + "]");
            stringBuffer.append(" ");
        }
        if (this.syntax != null) {
            stringBuffer.append(" " + this.syntax);
        }
        stringBuffer.append(" --> " + this.eventType + ":" + this.eventSubtype);
        if (this.eventArgs.size() > 0) {
            stringBuffer.append("( ");
            for (n = 0; n < this.eventArgs.size(); ++n) {
                stringBuffer.append(this.eventArgs.get(n) + " ");
            }
            stringBuffer.append(")");
        }
        if (this.evaluation.successCount > 0 || this.evaluation.failureCount > 0) {
            stringBuffer.append("\n  " + this.evaluation);
        }
        return stringBuffer.toString();
    }

    public void write(PrintWriter printWriter) {
        int n;
        printWriter.println("$eventPattern");
        printWriter.println("$type " + this.patternType);
        printWriter.println("$nodes");
        for (n = 0; n < this.nodes.size(); ++n) {
            AcePatternNode acePatternNode = (AcePatternNode)this.nodes.get(n);
            if (acePatternNode == null) {
                printWriter.println("anchor=" + this.anchor);
                continue;
            }
            acePatternNode.write(printWriter);
        }
        if (this.paths != null) {
            printWriter.println("$paths");
            for (n = 0; n < this.paths.size(); ++n) {
                this.paths.get(n).write(printWriter);
            }
        }
        if (this.syntax != null) {
            printWriter.println("$syntax");
            this.syntax.write(printWriter);
        }
        printWriter.println("$event");
        printWriter.println(this.eventType + ":" + this.eventSubtype);
        for (n = 0; n < this.eventArgs.size(); ++n) {
            ((EventPatternArgument)this.eventArgs.get(n)).write(printWriter);
        }
        printWriter.println("$eval");
        this.evaluation.write(printWriter);
        printWriter.println("$endPattern");
    }

    public EventPattern(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("$endPattern")) {
            if (string.startsWith("$type ")) {
                this.patternType = string.substring(6).trim();
                string = bufferedReader.readLine();
                continue;
            }
            if (string.equals("$nodes")) {
                string = bufferedReader.readLine();
                while (string != null && !string.startsWith("$")) {
                    if (string.startsWith("anchor=")) {
                        this.anchor = string.substring(7);
                        this.anchorPosn = this.nodes.size();
                        this.nodes.add(null);
                    } else {
                        AcePatternNode acePatternNode = new AcePatternNode(string);
                        if (acePatternNode.type != null) {
                            this.nodes.add(acePatternNode);
                        }
                    }
                    string = bufferedReader.readLine();
                }
                this.roles = new ArrayList[this.nodes.size()];
                for (int i = 0; i < this.roles.length; ++i) {
                    this.roles[i] = new ArrayList();
                }
                continue;
            }
            if (string.equals("$paths")) {
                this.paths = new ArrayList();
                string = bufferedReader.readLine();
                while (string != null && !string.startsWith("$")) {
                    ChunkPath chunkPath = new ChunkPath(string);
                    this.paths.add(chunkPath);
                    string = bufferedReader.readLine();
                }
                continue;
            }
            if (string.equals("$syntax")) {
                string = bufferedReader.readLine();
                this.syntax = new SyntacticRelationSet();
                while (string != null && !string.startsWith("$")) {
                    SyntacticRelation syntacticRelation = new SyntacticRelation(string);
                    this.syntax.add(syntacticRelation);
                    string = bufferedReader.readLine();
                }
                continue;
            }
            if (string.equals("$event")) {
                string = bufferedReader.readLine();
                String[] stringArray = string.split(":");
                this.eventType = stringArray[0];
                this.eventSubtype = stringArray[1];
                string = bufferedReader.readLine();
                this.eventArgs = new ArrayList();
                while (string != null && !string.startsWith("$")) {
                    EventPatternArgument eventPatternArgument = new EventPatternArgument(string);
                    this.eventArgs.add(eventPatternArgument);
                    this.roles[(Integer)eventPatternArgument.source - 1].add(eventPatternArgument.role);
                    string = bufferedReader.readLine();
                }
                continue;
            }
            if (string.equals("$eval")) {
                this.evaluation = new PatternEvaluation(bufferedReader);
                string = bufferedReader.readLine();
                continue;
            }
            System.err.println("EventPattern:  invalid input line " + string);
            string = bufferedReader.readLine();
        }
        if (this.paths != null && this.paths.size() == 0) {
            this.paths = null;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        JetTest.initializeFromConfig("props/ace use parses.properties");
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("data/loc.dict");
        AceDocument.ace2005 = true;
        String string = "nw/XIN_ENG_20030423.0011";
        String string2 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/nw/XIN_ENG_20030423.0011.apf.xml";
        String string3 = "C:/Documents and Settings/Ralph Grishman/My Documents/Ace 05/V4/perfect-parses/nw/XIN_ENG_20030423.0011.sgm";
        ExternalDocument externalDocument = new ExternalDocument("sgml", string3);
        externalDocument.setAllTags(true);
        externalDocument.open();
        Resolve.trace = false;
        Control.processDocument(externalDocument, null, false, 0);
        AceDocument aceDocument = new AceDocument(string3, string2);
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        syntacticRelationSet.readRelations(triplesDir + string + triplesSuffix);
        ArrayList<AceEvent> arrayList = aceDocument.events;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEvent aceEvent = arrayList.get(i);
            ArrayList<AceEventMention> arrayList2 = aceEvent.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventMention aceEventMention = arrayList2.get(j);
                System.out.println("Processing mention " + aceEventMention.id + " = " + aceEventMention.text);
                EventPattern eventPattern = new EventPattern("CHUNK", externalDocument, syntacticRelationSet, aceEvent, aceEventMention);
                System.out.println("chunkEvPat = " + eventPattern);
                Span span = aceEventMention.anchorJetExtent;
                String string4 = EventPattern.normalizedAnchor(span, aceEventMention.anchorText, externalDocument, syntacticRelationSet);
                AceEvent aceEvent2 = eventPattern.match(span, string4, externalDocument, syntacticRelationSet, aceDocument);
                if (aceEvent2 == null) {
                    System.out.println("**** match failed ****");
                } else {
                    System.out.println("Original      event " + aceEventMention);
                    System.out.println("Reconstructed " + aceEvent2);
                }
                EventPattern eventPattern2 = new EventPattern("SYNTAX", externalDocument, syntacticRelationSet, aceEvent, aceEventMention);
                System.out.println("synEvPat = " + eventPattern2);
                aceEvent2 = eventPattern2.match(span, string4, externalDocument, syntacticRelationSet, aceDocument);
                if (aceEvent2 == null) {
                    System.out.println("**** match failed ****");
                } else {
                    System.out.println("Original      event " + aceEventMention);
                    System.out.println("Reconstructed " + aceEvent2);
                }
                EventPattern eventPattern3 = new EventPattern("PA", externalDocument, syntacticRelationSet, aceEvent, aceEventMention);
                System.out.println("paEvPat = " + eventPattern3);
                aceEvent2 = eventPattern3.match(span, string4, externalDocument, syntacticRelationSet, aceDocument);
                if (aceEvent2 == null) {
                    System.out.println("**** match failed ****");
                    continue;
                }
                System.out.println("Original      event " + aceEventMention);
                System.out.println("Reconstructed " + aceEvent2);
            }
        }
    }
}

