/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelWriter;
import opennlp.model.ComparablePredicate;
import opennlp.model.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PerceptronModelWriter
extends AbstractModelWriter {
    protected Context[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected String[] PRED_LABELS;
    int numOutcomes;

    public PerceptronModelWriter(AbstractModel abstractModel) {
        Object[] objectArray = abstractModel.getDataStructures();
        this.numOutcomes = abstractModel.getNumOutcomes();
        this.PARAMS = (Context[])objectArray[0];
        Map map = (Map)objectArray[1];
        this.OUTCOME_LABELS = (String[])objectArray[2];
        this.PRED_LABELS = new String[map.size()];
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            this.PRED_LABELS[((Integer)map.get((Object)string)).intValue()] = string = (String)iterator.next();
        }
    }

    protected ComparablePredicate[] sortValues() {
        int n;
        ComparablePredicate[] comparablePredicateArray = new ComparablePredicate[this.PARAMS.length];
        int[] nArray = new int[this.numOutcomes];
        double[] dArray = new double[this.numOutcomes];
        int n2 = 0;
        for (n = 0; n < this.PARAMS.length; ++n) {
            int n3 = 0;
            double[] dArray2 = this.PARAMS[n].getParameters();
            int[] nArray2 = this.PARAMS[n].getOutcomes();
            for (int i = 0; i < dArray2.length; ++i) {
                if (dArray2[i] == 0.0) continue;
                nArray[n3] = nArray2[i];
                dArray[n3] = dArray2[i];
                ++n3;
            }
            int[] nArray3 = new int[n3];
            double[] dArray3 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                nArray3[i] = nArray[i];
                dArray3[i] = dArray[i];
            }
            if (n3 == 0) continue;
            comparablePredicateArray[n2] = new ComparablePredicate(this.PRED_LABELS[n], nArray3, dArray3);
            ++n2;
        }
        System.err.println("Compressed " + this.PARAMS.length + " parameters to " + n2);
        Object[] objectArray = new ComparablePredicate[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = comparablePredicateArray[n];
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    protected List<List<ComparablePredicate>> computeOutcomePatterns(ComparablePredicate[] comparablePredicateArray) {
        ComparablePredicate comparablePredicate = comparablePredicateArray[0];
        ArrayList<List<ComparablePredicate>> arrayList = new ArrayList<List<ComparablePredicate>>();
        ArrayList<ComparablePredicate> arrayList2 = new ArrayList<ComparablePredicate>();
        for (int i = 0; i < comparablePredicateArray.length; ++i) {
            if (comparablePredicate.compareTo(comparablePredicateArray[i]) == 0) {
                arrayList2.add(comparablePredicateArray[i]);
                continue;
            }
            comparablePredicate = comparablePredicateArray[i];
            arrayList.add(arrayList2);
            arrayList2 = new ArrayList();
            arrayList2.add(comparablePredicateArray[i]);
        }
        arrayList.add(arrayList2);
        System.err.println(arrayList.size() + " outcome patterns");
        return arrayList;
    }

    @Override
    public void persist() throws IOException {
        int n;
        this.writeUTF("Perceptron");
        this.writeInt(this.OUTCOME_LABELS.length);
        for (int i = 0; i < this.OUTCOME_LABELS.length; ++i) {
            this.writeUTF(this.OUTCOME_LABELS[i]);
        }
        ComparablePredicate[] comparablePredicateArray = this.sortValues();
        List<List<ComparablePredicate>> list = this.computeOutcomePatterns(comparablePredicateArray);
        this.writeInt(list.size());
        for (n = 0; n < list.size(); ++n) {
            List<ComparablePredicate> list2 = list.get(n);
            this.writeUTF(list2.size() + list2.get(0).toString());
        }
        this.writeInt(comparablePredicateArray.length);
        for (n = 0; n < comparablePredicateArray.length; ++n) {
            this.writeUTF(comparablePredicateArray[n].name);
        }
        for (n = 0; n < comparablePredicateArray.length; ++n) {
            for (int i = 0; i < comparablePredicateArray[n].params.length; ++i) {
                this.writeDouble(comparablePredicateArray[n].params[i]);
            }
        }
        this.close();
    }
}

