/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.relationship;

import java.util.List;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTree;
import net.didion.jwnl.data.list.PointerTargetTreeNode;
import net.didion.jwnl.data.list.PointerTargetTreeNodeList;
import net.didion.jwnl.data.relationship.Relationship;
import net.didion.jwnl.data.relationship.RelationshipList;

public class SymmetricRelationship
extends Relationship {
    private static final int DEFAULT_SEARCH_DEPTH = 2;

    private SymmetricRelationship(PointerTargetNodeList pointerTargetNodeList, Relationship relationship) {
        super(pointerTargetNodeList, relationship);
    }

    private SymmetricRelationship(PointerType pointerType, Synset synset, Synset synset2) {
        super(pointerType, synset, synset2);
    }

    public Relationship reverse() {
        PointerTargetNodeList pointerTargetNodeList = ((PointerTargetNodeList)this.getNodeList().deepClone()).reverse();
        int n = 0;
        while (n < pointerTargetNodeList.size()) {
            ((PointerTargetNode)pointerTargetNodeList.get(n)).setType(this.getType().getSymmetricType());
            ++n;
        }
        return new SymmetricRelationship(pointerTargetNodeList, this);
    }

    static RelationshipList findSymmetricRelationships(Synset synset, Synset synset2, PointerType pointerType) throws JWNLException {
        return SymmetricRelationship.findSymmetricRelationships(synset, synset2, pointerType, 2);
    }

    static RelationshipList findSymmetricRelationships(Synset synset, Synset synset2, PointerType pointerType, int n) throws JWNLException {
        PointerTargetTree pointerTargetTree = new PointerTargetTree(synset, PointerUtils.makePointerTargetTreeList(synset, pointerType, null, n, false));
        final Synset synset3 = synset2;
        PointerTargetTreeNodeList.Operation operation = new PointerTargetTreeNodeList.Operation(){

            public Object execute(PointerTargetTreeNode pointerTargetTreeNode) {
                if (synset3.equals(pointerTargetTreeNode.getPointerTarget())) {
                    return pointerTargetTreeNode;
                }
                return null;
            }
        };
        List list = pointerTargetTree.getAllMatches(operation);
        RelationshipList relationshipList = new RelationshipList();
        SymmetricRelationship symmetricRelationship = new SymmetricRelationship(pointerType, synset, synset2);
        int n2 = 0;
        while (n2 < list.size()) {
            relationshipList.add(SymmetricRelationship.findSymmetricRelationship((PointerTargetTreeNode)list.get(n2), symmetricRelationship));
            ++n2;
        }
        return relationshipList;
    }

    private static Relationship findSymmetricRelationship(PointerTargetTreeNode pointerTargetTreeNode, Relationship relationship) {
        PointerTargetNodeList pointerTargetNodeList = new PointerTargetNodeList();
        SymmetricRelationship.buildSymmetricRelationshipList(pointerTargetNodeList, pointerTargetTreeNode);
        pointerTargetNodeList = pointerTargetNodeList.reverse();
        ((PointerTargetNode)pointerTargetNodeList.get(0)).setType(relationship.getType());
        return new SymmetricRelationship(pointerTargetNodeList, relationship);
    }

    private static void buildSymmetricRelationshipList(PointerTargetNodeList pointerTargetNodeList, PointerTargetTreeNode pointerTargetTreeNode) {
        pointerTargetNodeList.add(pointerTargetTreeNode.getPointerTarget(), pointerTargetTreeNode.getType());
        if (pointerTargetTreeNode.getParent() != null) {
            SymmetricRelationship.buildSymmetricRelationshipList(pointerTargetNodeList, pointerTargetTreeNode.getParent());
        }
    }
}

