/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.util.Resolvable;

public final class PointerType
implements Serializable {
    static final long serialVersionUID = 220886251671304256L;
    private static final int N = 1;
    private static final int V = 2;
    private static final int ADJ = 4;
    private static final int ADV = 8;
    private static final int LEXICAL = 16;
    public static final PointerType ANTONYM = new PointerType("ANTONYM", "ANTONYM_KEY", 31);
    public static final PointerType HYPERNYM = new PointerType("HYPERNYM", "HYPERNYM_KEY", 3);
    public static final PointerType HYPONYM = new PointerType("HYPONYM", "HYPONYM_KEY", 3);
    public static final PointerType ATTRIBUTE = new PointerType("ATTRIBUTE", "ATTRIBUTE_KEY", 5);
    public static final PointerType SEE_ALSO = new PointerType("ALSO_SEE", "ALSO_SEE_KEY", 23);
    public static final PointerType ENTAILMENT = new PointerType("ENTAILMENT", "ENTAILMENT_KEY", 2);
    public static final PointerType ENTAILED_BY = new PointerType("ENTAILED_BY", "ENTAILED_BY_KEY", 2);
    public static final PointerType CAUSE = new PointerType("CAUSE", "CAUSE_KEY", 2);
    public static final PointerType VERB_GROUP = new PointerType("VERB_GROUP", "VERB_GROUP_KEY", 2);
    public static final PointerType MEMBER_HOLONYM = new PointerType("MEMBER_HOLONYM", "MEMBER_HOLONYM_KEY", 1);
    public static final PointerType SUBSTANCE_HOLONYM = new PointerType("SUBSTANCE_HOLONYM", "SUBSTANCE_HOLONYM_KEY", 1);
    public static final PointerType PART_HOLONYM = new PointerType("PART_HOLONYM", "PART_HOLONYM_KEY", 1);
    public static final PointerType MEMBER_MERONYM = new PointerType("MEMBER_MERONYM", "MEMBER_MERONYM_KEY", 1);
    public static final PointerType SUBSTANCE_MERONYM = new PointerType("SUBSTANCE_MERONYM", "SUBSTANCE_MERONYM_KEY", 1);
    public static final PointerType PART_MERONYM = new PointerType("PART_MERONYM", "PART_MERONYM_KEY", 1);
    public static final PointerType SIMILAR_TO = new PointerType("SIMILAR", "SIMILAR_KEY", 4);
    public static final PointerType PARTICIPLE_OF = new PointerType("PARTICIPLE_OF", "PARTICIPLE_OF_KEY", 20);
    public static final PointerType PERTAINYM = new PointerType("PERTAINYM", "PERTAINYM_KEY", 20);
    public static final PointerType DERIVED = new PointerType("DERIVED", "DERIVED_KEY", 8);
    public static final PointerType[] TYPES = new PointerType[]{ANTONYM, HYPERNYM, HYPONYM, ATTRIBUTE, SEE_ALSO, ENTAILMENT, ENTAILED_BY, CAUSE, VERB_GROUP, MEMBER_MERONYM, SUBSTANCE_MERONYM, PART_MERONYM, MEMBER_HOLONYM, SUBSTANCE_HOLONYM, PART_HOLONYM, SIMILAR_TO, PARTICIPLE_OF, DERIVED};
    private static final Map POS_TO_MASK_MAP;
    private static final Map KEY_TO_POINTER_TYPE_MAP;
    private static boolean _initialized;
    private Resolvable _label;
    private Resolvable _key;
    private int _flags;
    private PointerType _symmetricType;
    private transient String _cachedToString = null;
    private String _flagStringCache = null;

    private static void setSymmetric(PointerType pointerType, PointerType pointerType2) {
        pointerType._symmetricType = pointerType2;
        pointerType2._symmetricType = pointerType;
    }

    public static boolean isSymmetric(PointerType pointerType) {
        return pointerType.symmetricTo(pointerType);
    }

    public static void initialize() {
        if (!_initialized) {
            POS_TO_MASK_MAP.put(POS.NOUN, new Integer(1));
            POS_TO_MASK_MAP.put(POS.VERB, new Integer(2));
            POS_TO_MASK_MAP.put(POS.ADJECTIVE, new Integer(4));
            POS_TO_MASK_MAP.put(POS.ADVERB, new Integer(8));
            int n = 0;
            while (n < TYPES.length) {
                KEY_TO_POINTER_TYPE_MAP.put(TYPES[n].getKey(), TYPES[n]);
                ++n;
            }
            _initialized = true;
        }
    }

    private static int getPOSMask(POS pOS) {
        return (Integer)POS_TO_MASK_MAP.get(pOS);
    }

    public static PointerType getPointerTypeForKey(String string) {
        PointerType pointerType = (PointerType)KEY_TO_POINTER_TYPE_MAP.get(string);
        if (pointerType == null) {
            throw new JWNLRuntimeException("DATA_EXCEPTION_002", string);
        }
        return pointerType;
    }

    private PointerType(String string, String string2, int n) {
        this._label = new Resolvable(string);
        this._key = new Resolvable(string2);
        this._flags = n;
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_011", new Object[]{this.getLabel(), this.getKey(), this.getFlagsAsString()});
        }
        return this._cachedToString;
    }

    public String getKey() {
        return this._key.toString();
    }

    public String getLabel() {
        return this._label.toString();
    }

    public boolean appliesTo(POS pOS) {
        return (this._flags & PointerType.getPOSMask(pOS)) != 0;
    }

    public boolean isSymmetric() {
        return this.symmetricTo(this);
    }

    public boolean symmetricTo(PointerType pointerType) {
        return this.getSymmetricType() != null && this.getSymmetricType().equals(pointerType);
    }

    public PointerType getSymmetricType() {
        return this._symmetricType;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    private String getFlagsAsString() {
        if (this._flagStringCache == null) {
            String string = "";
            if ((this._flags & 1) != 0) {
                string = string + JWNL.resolveMessage("NOUN") + ", ";
            }
            if ((this._flags & 2) != 0) {
                string = string + JWNL.resolveMessage("VERB") + ", ";
            }
            if ((this._flags & 4) != 0) {
                string = string + JWNL.resolveMessage("ADJECTIVE") + ", ";
            }
            if ((this._flags & 8) != 0) {
                string = string + JWNL.resolveMessage("ADVERB") + ", ";
            }
            if ((this._flags & 0x10) != 0) {
                string = string + JWNL.resolveMessage("LEXICAL") + ", ";
            }
            this._flagStringCache = string.substring(0, string.length() - 2);
        }
        return this._flagStringCache;
    }

    static {
        PointerType.setSymmetric(ANTONYM, ANTONYM);
        PointerType.setSymmetric(HYPERNYM, HYPONYM);
        PointerType.setSymmetric(MEMBER_MERONYM, MEMBER_HOLONYM);
        PointerType.setSymmetric(SUBSTANCE_MERONYM, SUBSTANCE_HOLONYM);
        PointerType.setSymmetric(PART_MERONYM, PART_HOLONYM);
        PointerType.setSymmetric(SIMILAR_TO, SIMILAR_TO);
        PointerType.setSymmetric(ENTAILMENT, ENTAILED_BY);
        POS_TO_MASK_MAP = new HashMap();
        KEY_TO_POINTER_TYPE_MAP = new HashMap();
        _initialized = false;
    }
}

