/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.pipe.iterator;

import edu.umass.cs.mallet.base.pipe.iterator.AbstractPipeInputIterator;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.Dirichlet;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.TokenSequence;
import edu.umass.cs.mallet.base.util.MalletLogger;
import edu.umass.cs.mallet.base.util.Random;
import java.net.URI;
import java.util.logging.Logger;

public class RandomTokenSequenceIterator
extends AbstractPipeInputIterator {
    private static Logger logger = MalletLogger.getLogger(RandomTokenSequenceIterator.class.getName());
    Random r;
    Dirichlet classCentroidDistribution;
    double classCentroidAvergeAlphaMean;
    double classCentroidAvergeAlphaVariance;
    double featureVectorSizePoissonLambda;
    double classInstanceCountPoissonLamba;
    String[] classNames;
    int[] numInstancesPerClass;
    Dirichlet[] classCentroid;
    int currentClassIndex;
    int currentInstanceIndex;

    public RandomTokenSequenceIterator(Random r, Dirichlet classCentroidDistribution, double classCentroidAvergeAlphaMean, double classCentroidAvergeAlphaVariance, double featureVectorSizePoissonLambda, double classInstanceCountPoissonLamba, String[] classNames) {
        this.r = r;
        this.classCentroidDistribution = classCentroidDistribution;
        assert (classCentroidDistribution.getAlphabet() instanceof Alphabet);
        this.classCentroidAvergeAlphaMean = classCentroidAvergeAlphaMean;
        this.classCentroidAvergeAlphaVariance = classCentroidAvergeAlphaVariance;
        this.featureVectorSizePoissonLambda = featureVectorSizePoissonLambda;
        this.classInstanceCountPoissonLamba = classInstanceCountPoissonLamba;
        this.classNames = classNames;
        this.numInstancesPerClass = new int[classNames.length];
        this.classCentroid = new Dirichlet[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            logger.fine("classCentroidAvergeAlphaMean = " + classCentroidAvergeAlphaMean);
            double aveAlpha = r.nextGaussian(classCentroidAvergeAlphaMean, classCentroidAvergeAlphaVariance);
            logger.fine("aveAlpha = " + aveAlpha);
            this.classCentroid[i] = classCentroidDistribution.randomDirichlet(r, aveAlpha);
            ++i;
        }
        this.reset();
    }

    public RandomTokenSequenceIterator(Random r, Alphabet vocab, String[] classnames) {
        this(r, new Dirichlet(vocab, 2.0), 30.0, 0.0, 10.0, 20.0, classnames);
    }

    public Alphabet getAlphabet() {
        return this.classCentroidDistribution.getAlphabet();
    }

    private static Alphabet dictOfSize(int size) {
        Alphabet ret = new Alphabet();
        int i = 0;
        while (i < size) {
            ret.lookupIndex("feature" + i);
            ++i;
        }
        return ret;
    }

    private static String[] classNamesOfSize(int size) {
        String[] ret = new String[size];
        int i = 0;
        while (i < size) {
            ret[i] = "class" + i;
            ++i;
        }
        return ret;
    }

    public RandomTokenSequenceIterator(Random r, int vocabSize, int numClasses) {
        this(r, new Dirichlet(RandomTokenSequenceIterator.dictOfSize(vocabSize), 2.0), 30.0, 0.0, 10.0, 20.0, RandomTokenSequenceIterator.classNamesOfSize(numClasses));
    }

    public void reset() {
        int i = 0;
        while (i < this.classNames.length) {
            this.numInstancesPerClass[i] = this.r.nextPoisson(this.classInstanceCountPoissonLamba);
            logger.fine("Class " + this.classNames[i] + " will have " + this.numInstancesPerClass[i] + " instances.");
            ++i;
        }
        this.currentClassIndex = this.classNames.length - 1;
        this.currentInstanceIndex = this.numInstancesPerClass[this.currentClassIndex] - 1;
    }

    public Instance nextInstance() {
        if (this.currentInstanceIndex < 0) {
            if (this.currentClassIndex <= 0) {
                throw new IllegalStateException("No next TokenSequence.");
            }
            --this.currentClassIndex;
            this.currentInstanceIndex = this.numInstancesPerClass[this.currentClassIndex] - 1;
        }
        URI uri = null;
        try {
            uri = new URI("random:" + this.classNames[this.currentClassIndex] + "/" + this.currentInstanceIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
        int randomSize = (int)this.featureVectorSizePoissonLambda;
        TokenSequence ts = this.classCentroid[this.currentClassIndex].randomTokenSequence(this.r, randomSize);
        --this.currentInstanceIndex;
        return new Instance(ts, this.classNames[this.currentClassIndex], uri, null);
    }

    public boolean hasNext() {
        return this.currentClassIndex != 0 || this.currentInstanceIndex != 0;
    }
}

